/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.apache.commons.io.input.ReaderInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import us.ihmc.yoVariables.parameters.DefaultParameterReader;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.parameters.ParameterLoadStatus;
import us.ihmc.yoVariables.parameters.XmlParameterReader;
import us.ihmc.yoVariables.parameters.XmlParameterWriter;
import us.ihmc.yoVariables.registry.YoRegistry;

@Execution(value=ExecutionMode.SAME_THREAD)
public class XMLParameterIOTest {
    public static YoRegistry createRegistries() {
        YoRegistry[] regs = new YoRegistry[]{new YoRegistry("root"), new YoRegistry("a"), new YoRegistry("b"), new YoRegistry("c")};
        regs[0].addChild(regs[1]);
        regs[1].addChild(regs[2]);
        regs[2].addChild(regs[3]);
        new DoubleParameter("paramA", "parameter A description", regs[3], 0.0);
        new DoubleParameter("paramB", regs[3], 0.0);
        new DoubleParameter("paramC", regs[3], 0.0);
        new DoubleParameter("paramD", regs[3], 0.0);
        new DoubleParameter("paramE", regs[2], 0.0);
        new DoubleParameter("paramF", regs[1], 0.0);
        new DoubleParameter("paramG", regs[0], 0.0);
        return regs[0];
    }

    @Test
    public void testEmptyFile() throws IOException {
        YoRegistry target = XMLParameterIOTest.createRegistries();
        String data = "<parameters/>";
        StringReader reader = new StringReader(data);
        XmlParameterReader parameterReader = new XmlParameterReader(new InputStream[]{new ReaderInputStream((Reader)reader, Charset.defaultCharset())});
        parameterReader.readParametersInRegistry(target);
    }

    @Test
    public void testWritingAndReading() throws IOException {
        YoRegistry source = XMLParameterIOTest.createRegistries();
        YoRegistry target = XMLParameterIOTest.createRegistries();
        DefaultParameterReader defaultReader = new DefaultParameterReader();
        defaultReader.readParametersInRegistry(source);
        source.findVariable("root.a.b.c.paramA").setValueFromDouble(1.0);
        source.findVariable("root.a.b.c.paramB").setValueFromDouble(2.0);
        source.findVariable("root.a.b.c.paramC").setValueFromDouble(3.0);
        source.findVariable("root.a.b.c.paramD").setValueFromDouble(4.0);
        source.findVariable("root.a.b.paramE").setValueFromDouble(5.0);
        source.findVariable("root.a.paramF").setValueFromDouble(6.0);
        source.findVariable("root.paramG").setValueFromDouble(7.0);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XmlParameterWriter writer = new XmlParameterWriter();
        writer.addParameters(source);
        writer.write((OutputStream)os);
        XmlParameterReader reader = new XmlParameterReader(new InputStream[]{new ByteArrayInputStream(os.toByteArray())});
        reader.readParametersInRegistry(target);
        Assertions.assertEquals((double)source.findVariable("root.a.b.c.paramA").getValueAsDouble(), (double)target.findVariable("root.a.b.c.paramA").getValueAsDouble(), (double)1.0E-9);
        Assertions.assertEquals((double)source.findVariable("root.a.b.c.paramB").getValueAsDouble(), (double)target.findVariable("root.a.b.c.paramB").getValueAsDouble(), (double)1.0E-9);
        Assertions.assertEquals((double)source.findVariable("root.a.b.c.paramC").getValueAsDouble(), (double)target.findVariable("root.a.b.c.paramC").getValueAsDouble(), (double)1.0E-9);
        Assertions.assertEquals((double)source.findVariable("root.a.b.c.paramD").getValueAsDouble(), (double)target.findVariable("root.a.b.c.paramD").getValueAsDouble(), (double)1.0E-9);
        Assertions.assertEquals((double)source.findVariable("root.a.b.paramE").getValueAsDouble(), (double)target.findVariable("root.a.b.paramE").getValueAsDouble(), (double)1.0E-9);
        Assertions.assertEquals((double)source.findVariable("root.a.paramF").getValueAsDouble(), (double)target.findVariable("root.a.paramF").getValueAsDouble(), (double)1.0E-9);
        Assertions.assertEquals((double)source.findVariable("root.paramG").getValueAsDouble(), (double)target.findVariable("root.paramG").getValueAsDouble(), (double)1.0E-9);
    }

    @Test
    public void testOverwritingDuringContruction() throws IOException {
        YoRegistry target = new YoRegistry("TestRegistry");
        DoubleParameter parameter1 = new DoubleParameter("TestParameter1", target);
        DoubleParameter parameter2 = new DoubleParameter("TestParameter2", target);
        String data1 = "<parameters><registry name=\"TestRegistry\"><parameter name=\"TestParameter1\" type=\"DoubleParameter\" min=\"0.0\" max=\"1.0\" value=\"0.5\"/><parameter name=\"TestParameter2\" type=\"DoubleParameter\" min=\"0.0\" max=\"1.0\" value=\"0.5\"/></registry></parameters>";
        StringReader reader1 = new StringReader(data1);
        ReaderInputStream stream1 = new ReaderInputStream((Reader)reader1, Charset.forName("UTF-8"));
        String data2 = "<parameters><registry name=\"TestRegistry\"><parameter name=\"TestParameter1\" type=\"DoubleParameter\" min=\"0.0\" max=\"1.0\" value=\"0.0\"/></registry></parameters>";
        StringReader reader2 = new StringReader(data2);
        ReaderInputStream stream2 = new ReaderInputStream((Reader)reader2, Charset.forName("UTF-8"));
        XmlParameterReader parameterReader = new XmlParameterReader(new InputStream[]{stream1, stream2});
        parameterReader.readParametersInRegistry(target);
        Assertions.assertEquals((double)0.0, (double)parameter1.getValue(), (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)0.5, (double)parameter2.getValue(), (double)Double.MIN_VALUE);
    }

    @Test
    public void testOverwriting() throws IOException {
        YoRegistry target = new YoRegistry("TestRegistry");
        DoubleParameter parameter1 = new DoubleParameter("TestParameter1", target);
        DoubleParameter parameter2 = new DoubleParameter("TestParameter2", target);
        String data1 = "<parameters><registry name=\"TestRegistry\"><parameter name=\"TestParameter1\" type=\"DoubleParameter\" min=\"0.0\" max=\"1.0\" value=\"0.5\"/><parameter name=\"TestParameter2\" type=\"DoubleParameter\" min=\"0.0\" max=\"1.0\" value=\"0.5\"/></registry></parameters>";
        StringReader reader1 = new StringReader(data1);
        ReaderInputStream stream1 = new ReaderInputStream((Reader)reader1, Charset.forName("UTF-8"));
        String data2 = "<parameters><registry name=\"TestRegistry\"><parameter name=\"TestParameter1\" type=\"DoubleParameter\" min=\"0.0\" max=\"1.0\" value=\"0.0\"/></registry></parameters>";
        StringReader reader2 = new StringReader(data2);
        ReaderInputStream stream2 = new ReaderInputStream((Reader)reader2, Charset.forName("UTF-8"));
        XmlParameterReader parameterReader = new XmlParameterReader(new InputStream[]{stream1});
        parameterReader.overwrite(new InputStream[]{stream2});
        parameterReader.readParametersInRegistry(target);
        Assertions.assertEquals((double)0.0, (double)parameter1.getValue(), (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)0.5, (double)parameter2.getValue(), (double)Double.MIN_VALUE);
    }

    @Test
    public void testOverwritingAvoidingException() throws IOException {
        YoRegistry target = new YoRegistry("TestRegistry");
        DoubleParameter parameter1 = new DoubleParameter("TestParameter1", target);
        DoubleParameter parameter2 = new DoubleParameter("TestParameter2", target);
        DoubleParameter parameter3 = new DoubleParameter("TestParameter3", target);
        String data1 = "<parameters><registry name=\"TestRegistry\"><parameter name=\"TestParameter1\" type=\"DoubleParameter\" min=\"0.0\" max=\"1.0\" value=\"0.5\"/><parameter name=\"TestParameter2\" type=\"DoubleParameter\" min=\"0.0\" max=\"1.0\" value=\"0.5\"/></registry></parameters>";
        StringReader reader1 = new StringReader(data1);
        ReaderInputStream stream1 = new ReaderInputStream((Reader)reader1, Charset.forName("UTF-8"));
        String data2 = "<parameters><registry name=\"TestRegistry\"><parameter name=\"TestParameter1\" type=\"DoubleParameter\" min=\"0.0\" max=\"1.0\" value=\"0.0\"/><parameter name=\"TestParameter3\" type=\"DoubleParameter\" min=\"0.0\" max=\"1.0\" value=\"0.3\"/></registry></parameters>";
        StringReader reader2 = new StringReader(data2);
        ReaderInputStream stream2 = new ReaderInputStream((Reader)reader2, Charset.forName("UTF-8"));
        XmlParameterReader parameterReader = new XmlParameterReader(new InputStream[]{stream1});
        parameterReader.readAndOverwrite(new InputStream[]{stream2});
        parameterReader.readParametersInRegistry(target);
        Assertions.assertEquals((double)0.0, (double)parameter1.getValue(), (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)0.5, (double)parameter2.getValue(), (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)0.3, (double)parameter3.getValue(), (double)Double.MIN_VALUE);
    }

    @Test
    public void testOverwritingFails() throws IOException {
        Assertions.assertThrows(RuntimeException.class, () -> {
            YoRegistry target = new YoRegistry("TestRegistry");
            DoubleParameter parameter1 = new DoubleParameter("TestParameter1", target);
            DoubleParameter parameter2 = new DoubleParameter("TestParameter2", target);
            String data1 = "<parameters><registry name=\"TestRegistry\"><parameter name=\"TestParameter2\" type=\"DoubleParameter\" min=\"0.0\" max=\"1.0\" value=\"0.5\"/></registry></parameters>";
            StringReader reader1 = new StringReader(data1);
            ReaderInputStream stream1 = new ReaderInputStream((Reader)reader1, Charset.forName("UTF-8"));
            String data2 = "<parameters><registry name=\"TestRegistry\"><parameter name=\"TestParameter1\" type=\"DoubleParameter\" min=\"0.0\" max=\"1.0\" value=\"0.0\"/></registry></parameters>";
            StringReader reader2 = new StringReader(data2);
            ReaderInputStream stream2 = new ReaderInputStream((Reader)reader2, Charset.forName("UTF-8"));
            XmlParameterReader parameterReader = new XmlParameterReader(new InputStream[]{stream1});
            parameterReader.overwrite(new InputStream[]{stream2});
            parameterReader.readParametersInRegistry(target);
            Assertions.assertEquals((double)0.0, (double)parameter1.getValue(), (double)Double.MIN_VALUE);
            Assertions.assertEquals((double)0.5, (double)parameter2.getValue(), (double)Double.MIN_VALUE);
        });
    }

    @Test
    public void testRootNamespaceDoesNotMatch() throws IOException {
        YoRegistry target = new YoRegistry("Root");
        DoubleParameter parameter = new DoubleParameter("TestParameter", target);
        String data1 = "<parameters><registry name=\"" + target.getName() + "\"><parameter name=\"" + parameter.getName() + "\" type=\"DoubleParameter\" min=\"0.0\" max=\"1.0\" value=\"0.5\"/></registry></parameters>";
        StringReader reader1 = new StringReader(data1);
        ReaderInputStream stream1 = new ReaderInputStream((Reader)reader1, Charset.forName("UTF-8"));
        XmlParameterReader parameterReader = new XmlParameterReader("SomeOtherRoot", new InputStream[]{stream1});
        parameterReader.readParametersInRegistry(target);
        Assertions.assertEquals((Object)parameter.getLoadStatus(), (Object)ParameterLoadStatus.DEFAULT);
    }

    @Test
    public void testRootNamespaceMatches() throws IOException {
        YoRegistry target = new YoRegistry("Root");
        DoubleParameter parameter = new DoubleParameter("TestParameter", target);
        String data1 = "<parameters><registry name=\"" + target.getName() + "\"><parameter name=\"" + parameter.getName() + "\" type=\"DoubleParameter\" min=\"0.0\" max=\"1.0\" value=\"0.5\"/></registry></parameters>";
        StringReader reader1 = new StringReader(data1);
        ReaderInputStream stream1 = new ReaderInputStream((Reader)reader1, Charset.forName("UTF-8"));
        XmlParameterReader parameterReader = new XmlParameterReader(target.getName(), new InputStream[]{stream1});
        parameterReader.readParametersInRegistry(target);
        Assertions.assertEquals((Object)parameter.getLoadStatus(), (Object)ParameterLoadStatus.LOADED);
    }

    @Test
    public void testReadingWithMinMax() throws IOException {
        YoRegistry target = new YoRegistry("Root");
        DoubleParameter parameter = new DoubleParameter("TestParameter", target);
        double min = -0.4536;
        double max = 9509.3;
        String data1 = "<parameters><registry name=\"" + target.getName() + "\"><parameter name=\"" + parameter.getName() + "\" type=\"DoubleParameter\" min=\"" + min + "\" max=\"" + max + "\" value=\"0.5\"/></registry></parameters>";
        StringReader reader1 = new StringReader(data1);
        ReaderInputStream stream1 = new ReaderInputStream((Reader)reader1, Charset.forName("UTF-8"));
        XmlParameterReader parameterReader = new XmlParameterReader(target.getName(), new InputStream[]{stream1});
        parameterReader.readParametersInRegistry(target);
        Assertions.assertEquals((Object)parameter.getLoadStatus(), (Object)ParameterLoadStatus.LOADED);
        Assertions.assertEquals((double)min, (double)parameter.getLowerBound(), (double)Double.MIN_VALUE);
        Assertions.assertEquals((double)max, (double)parameter.getUpperBound(), (double)Double.MIN_VALUE);
    }

    @Test
    public void testReadingWithoutMinMax() throws IOException {
        YoRegistry target = new YoRegistry("Root");
        DoubleParameter parameter = new DoubleParameter("TestParameter", target);
        String data1 = "<parameters><registry name=\"" + target.getName() + "\"><parameter name=\"" + parameter.getName() + "\" type=\"BooleanParameter\" value=\"0.5\"/></registry></parameters>";
        StringReader reader1 = new StringReader(data1);
        ReaderInputStream stream1 = new ReaderInputStream((Reader)reader1, Charset.forName("UTF-8"));
        XmlParameterReader parameterReader = new XmlParameterReader(target.getName(), new InputStream[]{stream1});
        parameterReader.readParametersInRegistry(target);
        Assertions.assertEquals((Object)parameter.getLoadStatus(), (Object)ParameterLoadStatus.LOADED);
    }
}

