/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameTuple3DBasicsTest;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoMutableFrameVector3DTest
extends FrameTuple3DBasicsTest<YoMutableFrameVector3D> {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    public Tuple3DBasics createRandomFramelessTuple(Random random) {
        return EuclidCoreRandomTools.nextVector3D((Random)random);
    }

    public YoMutableFrameVector3D createFrameTuple(ReferenceFrame referenceFrame, double x, double y, double z) {
        return new YoMutableFrameVector3D("", "", null, referenceFrame, x, y, z);
    }

    @Test
    public void testMutableFrameObject() {
        YoRegistry registry = new YoRegistry("TestRegistry");
        Random random = new Random(4290L);
        ArrayList<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
        frames.addAll(Arrays.asList(EuclidFrameRandomTools.nextReferenceFrameTree((Random)random)));
        frames.add(null);
        YoMutableFrameVector3D mutableFrameObject = new YoMutableFrameVector3D("", "", registry);
        YoVariable frameIndex = registry.findVariable(YoGeometryNameTools.assembleName((String[])new String[]{"", "frame", ""}));
        Assertions.assertNotNull((Object)frameIndex);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame frame = (ReferenceFrame)frames.get(random.nextInt(frames.size()));
            mutableFrameObject.setReferenceFrame(frame);
            Assertions.assertTrue((frame == mutableFrameObject.getReferenceFrame() ? 1 : 0) != 0);
            if (frame == null) {
                Assertions.assertEquals((long)-1L, (long)frameIndex.getValueAsLongBits());
                continue;
            }
            Assertions.assertEquals((long)frame.getFrameIndex(), (long)frameIndex.getValueAsLongBits());
        }
    }

    @Test
    public void testConstructors() throws Exception {
        YoMutableFrameVector3D YoMutableFrameVector3D2;
        Vector3D randomTuple;
        ReferenceFrame randomFrame;
        int i;
        Random random = new Random(435345L);
        YoMutableFrameVector3D YoMutableFrameVector3D3 = new YoMutableFrameVector3D("", "", null);
        Assertions.assertTrue((YoMutableFrameVector3D3.getReferenceFrame() == worldFrame ? 1 : 0) != 0);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)YoMutableFrameVector3D3);
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFrameVector3D YoMutableFrameVector3D4 = new YoMutableFrameVector3D("", "", null, randomFrame);
            Assertions.assertTrue((YoMutableFrameVector3D4.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)YoMutableFrameVector3D4);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFrameVector3D2 = new YoMutableFrameVector3D("", "", null, randomFrame, (randomTuple = EuclidCoreRandomTools.nextVector3D((Random)random)).getX(), randomTuple.getY(), randomTuple.getZ());
            Assertions.assertTrue((YoMutableFrameVector3D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple, (EuclidGeometry)YoMutableFrameVector3D2, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidCoreRandomTools.nextVector3D((Random)random);
            double[] array = new double[3];
            randomTuple.get(array);
            YoMutableFrameVector3D YoMutableFrameVector3D5 = new YoMutableFrameVector3D("", "", null, randomFrame, array);
            Assertions.assertTrue((YoMutableFrameVector3D5.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple, (EuclidGeometry)YoMutableFrameVector3D5, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFrameVector3D2 = new YoMutableFrameVector3D("", "", null, randomFrame, (Tuple3DReadOnly)(randomTuple = EuclidCoreRandomTools.nextVector3D((Random)random)));
            Assertions.assertTrue((YoMutableFrameVector3D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple, (EuclidGeometry)YoMutableFrameVector3D2, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            Vector2D randomTuple2D;
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFrameVector3D2 = new YoMutableFrameVector3D("", "", null, randomFrame, (Tuple2DReadOnly)(randomTuple2D = EuclidCoreRandomTools.nextVector2D((Random)random)));
            Assertions.assertTrue((YoMutableFrameVector3D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple2D, (EuclidGeometry)new Vector2D((Tuple3DReadOnly)YoMutableFrameVector3D2), (double)1.0E-15);
            Assertions.assertTrue((YoMutableFrameVector3D2.getZ() == 0.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FrameVector2D randomFrameTuple2D = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)randomFrame);
            YoMutableFrameVector3D2 = new YoMutableFrameVector3D("", "", null, (FrameTuple2DReadOnly)randomFrameTuple2D);
            Assertions.assertTrue((YoMutableFrameVector3D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomFrameTuple2D, (EuclidGeometry)new Vector2D((Tuple3DReadOnly)YoMutableFrameVector3D2), (double)1.0E-15);
            Assertions.assertTrue((YoMutableFrameVector3D2.getZ() == 0.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)randomFrame);
            YoMutableFrameVector3D2 = new YoMutableFrameVector3D("", "", null, (FrameTuple3DReadOnly)randomTuple);
            Assertions.assertTrue((YoMutableFrameVector3D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)randomTuple, (EuclidGeometry)YoMutableFrameVector3D2, (double)1.0E-15);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)randomTuple, (EuclidFrameGeometry)YoMutableFrameVector3D2, (double)1.0E-15);
        }
    }

    @Test
    public void testSetMatchingFrame() throws Exception {
        FrameVector3D source;
        ReferenceFrame destinationFrame;
        ReferenceFrame sourceFrame;
        int i;
        Random random = new Random(544354L);
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            source = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)sourceFrame);
            YoMutableFrameVector3D actual = (YoMutableFrameVector3D)this.createEmptyFrameTuple(destinationFrame);
            actual.setMatchingFrame((FrameTuple3DReadOnly)source);
            YoMutableFrameVector3D expected = new YoMutableFrameVector3D("", "", null, (FrameTuple3DReadOnly)source);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expected, (EuclidFrameGeometry)actual, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            source = EuclidFrameRandomTools.nextFrameVector2D((Random)random, (ReferenceFrame)sourceFrame);
            double z = EuclidCoreRandomTools.nextDouble((Random)random);
            YoMutableFrameVector3D actual = (YoMutableFrameVector3D)this.createEmptyFrameTuple(destinationFrame);
            actual.setMatchingFrame((FrameTuple2DReadOnly)source, z);
            YoMutableFrameVector3D expected = new YoMutableFrameVector3D("", "", null);
            expected.setIncludingFrame((FrameTuple2DReadOnly)source, z);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expected, (EuclidFrameGeometry)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testChangeFrame() throws Exception {
        Random random = new Random(43563L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Vector3D expected = EuclidCoreRandomTools.nextVector3D((Random)random);
            YoMutableFrameVector3D actual = new YoMutableFrameVector3D("", "", null, initialFrame, (Tuple3DReadOnly)expected);
            RigidBodyTransform transform = initialFrame.getTransformToDesiredFrame(anotherFrame);
            expected.applyTransform((Transform)transform);
            actual.changeFrame(anotherFrame);
            Assertions.assertTrue((anotherFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)1.0E-15);
            ReferenceFrame differentRootFrame = ReferenceFrameTools.constructARootFrame((String)"anotherRootFrame");
            try {
                actual.changeFrame(differentRootFrame);
                Assertions.fail((String)"Should have thrown a RuntimeException");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(32120L);
        for (int i = 0; i < 1000; ++i) {
            YoMutableFrameVector3D frameVector1 = new YoMutableFrameVector3D("", "", null, worldFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
            YoMutableFrameVector3D frameVector2 = new YoMutableFrameVector3D("", "", null, worldFrame);
            double epsilon = random.nextDouble();
            Vector3D difference = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(0.99 * epsilon));
            frameVector2.add((FrameTuple3DReadOnly)frameVector1, (Tuple3DReadOnly)difference);
            Assertions.assertTrue((boolean)frameVector1.geometricallyEquals((EuclidFrameGeometry)frameVector2, epsilon));
            difference = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(1.01 * epsilon));
            frameVector2.add((FrameTuple3DReadOnly)frameVector1, (Tuple3DReadOnly)difference);
            Assertions.assertFalse((boolean)frameVector1.geometricallyEquals((EuclidFrameGeometry)frameVector2, epsilon));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(763L);
        for (int i = 0; i < 1000; ++i) {
            FrameVector3D expected = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame, (double)-1.0E15, (double)1.0E15);
            YoMutableFrameVector3D actual = new YoMutableFrameVector3D("", "", null, worldFrame, (Tuple3DReadOnly)expected);
            Assertions.assertEquals((int)expected.hashCode(), (int)actual.hashCode());
        }
    }

    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Vector3D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Vector3D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Vector3D.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(YoMutableFrameVector3D.class, Vector3D.class, true, 1, methodFilter);
    }
}

