/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.registry;

import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableHolderImplementationTest {
    private YoVariableList yoVariableHolderImplementation = null;

    @BeforeEach
    public void setUp() {
        this.yoVariableHolderImplementation = new YoVariableList("Blop");
        YoRegistry robotRegistry = new YoRegistry("robot");
        YoRegistry robot2Registry = new YoRegistry("robot2");
        YoRegistry registryA = new YoRegistry("registryA");
        YoRegistry registryB = new YoRegistry("registryB");
        YoRegistry registryC = new YoRegistry("registryC");
        robotRegistry.addChild(registryA);
        robotRegistry.addChild(registryB);
        robotRegistry.addChild(registryC);
        YoRegistry registryC2 = new YoRegistry("registryC");
        robot2Registry.addChild(registryC2);
        YoDouble variableOneA = new YoDouble("variableOne", registryA);
        YoDouble variableOneB = new YoDouble("variableOne", registryB);
        YoDouble variableOneC = new YoDouble("variableOne", registryC);
        YoDouble variableOneC2 = new YoDouble("variableOne", registryC2);
        YoDouble variableTwoA = new YoDouble("variableTwo", registryA);
        YoDouble variableTwoB = new YoDouble("variableTwo", registryB);
        YoDouble variableTwoC = new YoDouble("variableTwo", registryC);
        YoDouble variableTwoC2 = new YoDouble("variableTwo", registryC2);
        YoDouble variableThreeA = new YoDouble("variableThree", registryA);
        YoDouble variableThreeB = new YoDouble("variableThree", registryB);
        YoDouble variableThreeC = new YoDouble("variableThree", registryC);
        YoDouble variableThreeC2 = new YoDouble("variableThree", registryC2);
        this.yoVariableHolderImplementation.add((YoVariable)variableOneA);
        this.yoVariableHolderImplementation.add((YoVariable)variableOneB);
        this.yoVariableHolderImplementation.add((YoVariable)variableOneC);
        this.yoVariableHolderImplementation.add((YoVariable)variableOneC2);
        this.yoVariableHolderImplementation.add((YoVariable)variableTwoA);
        this.yoVariableHolderImplementation.add((YoVariable)variableTwoB);
        this.yoVariableHolderImplementation.add((YoVariable)variableTwoC);
        this.yoVariableHolderImplementation.add((YoVariable)variableTwoC2);
        this.yoVariableHolderImplementation.add((YoVariable)variableThreeA);
        this.yoVariableHolderImplementation.add((YoVariable)variableThreeB);
        this.yoVariableHolderImplementation.add((YoVariable)variableThreeC);
        this.yoVariableHolderImplementation.add((YoVariable)variableThreeC2);
    }

    @AfterEach
    public void tearDown() {
        this.yoVariableHolderImplementation = null;
    }

    @Test
    public void testGetVariable() {
        YoVariable variable = this.yoVariableHolderImplementation.findVariable("robot.registryA.variableOne");
        Assertions.assertEquals((Object)variable.getName(), (Object)"variableOne");
        variable = this.yoVariableHolderImplementation.findVariable("registryA.variableOne");
        Assertions.assertEquals((Object)variable.getName(), (Object)"variableOne");
        variable = this.yoVariableHolderImplementation.findVariable("robot.registryA.variableOne");
        Assertions.assertEquals((Object)variable.getName(), (Object)"variableOne");
        variable = this.yoVariableHolderImplementation.findVariable("istryA.variableOne");
        Assertions.assertNull((Object)variable);
        variable = this.yoVariableHolderImplementation.findVariable("robot.registryA.variableTwo");
        Assertions.assertEquals((Object)variable.getName(), (Object)"variableTwo");
    }

    @Test
    public void testGetVariable1() {
        YoVariable variable = this.yoVariableHolderImplementation.findVariable("robot.registryA", "variableOne");
        Assertions.assertEquals((Object)variable.getName(), (Object)"variableOne");
        Assertions.assertEquals((Object)variable.getFullNameString(), (Object)"robot.registryA.variableOne");
        variable = this.yoVariableHolderImplementation.findVariable("robot.registryB", "variableOne");
        Assertions.assertEquals((Object)variable.getName(), (Object)"variableOne");
        Assertions.assertEquals((Object)variable.getFullNameString(), (Object)"robot.registryB.variableOne");
        variable = this.yoVariableHolderImplementation.findVariable("robot.registryC", "variableOne");
        Assertions.assertEquals((Object)variable.getName(), (Object)"variableOne");
        Assertions.assertEquals((Object)variable.getFullNameString(), (Object)"robot.registryC.variableOne");
        variable = this.yoVariableHolderImplementation.findVariable("registryA", "variableOne");
        Assertions.assertEquals((Object)variable.getName(), (Object)"variableOne");
        Assertions.assertEquals((Object)variable.getFullNameString(), (Object)"robot.registryA.variableOne");
        variable = this.yoVariableHolderImplementation.findVariable("registryB", "variableTwo");
        Assertions.assertEquals((Object)variable.getName(), (Object)"variableTwo");
        Assertions.assertEquals((Object)variable.getFullNameString(), (Object)"robot.registryB.variableTwo");
        variable = this.yoVariableHolderImplementation.findVariable("registryC", "variableOne");
        Assertions.assertEquals((Object)variable.getFullNameString(), (Object)"robot.registryC.variableOne");
        variable = this.yoVariableHolderImplementation.findVariable("registryC", "variableTwo");
        Assertions.assertEquals((Object)variable.getFullNameString(), (Object)"robot.registryC.variableTwo");
    }

    @Test
    public void testGetVariables() {
        YoNamespace namespace = new YoNamespace("robot.registryA");
        List variables = this.yoVariableHolderImplementation.findVariables(namespace);
        Assertions.assertEquals((int)3, (int)variables.size());
        namespace = new YoNamespace("robot.registryB");
        variables = this.yoVariableHolderImplementation.findVariables(namespace);
        Assertions.assertEquals((int)3, (int)variables.size());
        namespace = new YoNamespace("robot.registryC");
        variables = this.yoVariableHolderImplementation.findVariables(namespace);
        Assertions.assertEquals((int)3, (int)variables.size());
        namespace = new YoNamespace("robot2.registryC");
        variables = this.yoVariableHolderImplementation.findVariables(namespace);
        Assertions.assertEquals((int)3, (int)variables.size());
        namespace = new YoNamespace("robot");
        variables = this.yoVariableHolderImplementation.findVariables(namespace);
        Assertions.assertEquals((int)0, (int)variables.size());
        namespace = new YoNamespace("registryA");
        variables = this.yoVariableHolderImplementation.findVariables(namespace);
        Assertions.assertEquals((int)0, (int)variables.size());
    }

    @Test
    public void testGetVariables1() {
        List variables = this.yoVariableHolderImplementation.findVariables("variableOne");
        boolean aFound = false;
        boolean bFound = false;
        boolean cFound = false;
        boolean c2Found = false;
        for (YoVariable variable : variables) {
            if (variable.getFullNameString().equals("robot.registryA.variableOne")) {
                aFound = true;
            }
            if (variable.getFullNameString().equals("robot.registryB.variableOne")) {
                bFound = true;
            }
            if (variable.getFullNameString().equals("robot.registryC.variableOne")) {
                cFound = true;
            }
            if (!variable.getFullNameString().equals("robot2.registryC.variableOne")) continue;
            c2Found = true;
        }
        assert (aFound && bFound && cFound && c2Found);
        Assertions.assertEquals((int)4, (int)variables.size());
        variables = this.yoVariableHolderImplementation.findVariables("variableTwo");
        Assertions.assertEquals((int)4, (int)variables.size());
        variables = this.yoVariableHolderImplementation.findVariables("variableThree");
        Assertions.assertEquals((int)4, (int)variables.size());
        variables = this.yoVariableHolderImplementation.findVariables("var");
        Assertions.assertEquals((int)0, (int)variables.size());
    }

    @Test
    public void testGetVariables2() {
        List variables = this.yoVariableHolderImplementation.findVariables("robot.registryA", "variableOne");
        Assertions.assertEquals((int)1, (int)variables.size());
        variables = this.yoVariableHolderImplementation.findVariables("robot", "variableOne");
        Assertions.assertEquals((int)0, (int)variables.size());
        variables = this.yoVariableHolderImplementation.findVariables("registryC", "variableOne");
        Assertions.assertEquals((int)2, (int)variables.size());
        boolean cFound = false;
        boolean c2Found = false;
        boolean testPassed = true;
        for (YoVariable variable : variables) {
            if (variable.getFullNameString().equals("robot.registryC.variableOne")) {
                cFound = true;
            }
            if (!variable.getFullNameString().equals("robot2.registryC.variableOne")) continue;
            c2Found = true;
        }
        assert (cFound && c2Found);
        try {
            variables = this.yoVariableHolderImplementation.findVariables("robot", "registryC.variableOne");
            testPassed = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        assert (testPassed);
    }

    @Test
    public void testHasUniqueVariable() {
        Assertions.assertTrue((!this.yoVariableHolderImplementation.hasUniqueVariable("variableOne") ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.yoVariableHolderImplementation.hasUniqueVariable("robot.registryA.variableOne"));
        Assertions.assertTrue((boolean)this.yoVariableHolderImplementation.hasUniqueVariable("registryA.variableOne"));
        Assertions.assertTrue((boolean)this.yoVariableHolderImplementation.hasUniqueVariable("robot.registryA.variableOne"));
        Assertions.assertTrue((!this.yoVariableHolderImplementation.hasUniqueVariable("istryA.variableOne") ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.yoVariableHolderImplementation.hasUniqueVariable("robot.registryA.variableTwo"));
        Assertions.assertTrue((!this.yoVariableHolderImplementation.hasUniqueVariable("registryC.variableTwo") ? 1 : 0) != 0);
    }

    @Test
    public void testHasUniqueVariable1() {
        assert (this.yoVariableHolderImplementation.hasUniqueVariable("robot.registryA", "variableOne"));
        assert (this.yoVariableHolderImplementation.hasUniqueVariable("registryA", "variableOne"));
        assert (!this.yoVariableHolderImplementation.hasUniqueVariable("registryC", "variableTwo"));
        assert (!this.yoVariableHolderImplementation.hasUniqueVariable("istryA", "variableOne"));
        assert (this.yoVariableHolderImplementation.hasUniqueVariable("robot.registryA", "variableTwo"));
        assert (!this.yoVariableHolderImplementation.hasUniqueVariable("robot", "variableOne"));
        boolean testPassed = true;
        try {
            this.yoVariableHolderImplementation.hasUniqueVariable("robot", "registryC.variableOne");
            testPassed = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        assert (testPassed);
    }
}

