/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.registry;

import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.exceptions.IllegalNameException;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;
import us.ihmc.yoVariables.listener.YoRegistryChangedListener;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoRegistryRestrictionLevel;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoRegistryTest {
    private static final int N_VARS_IN_ROOT = 4;
    private YoRegistry robotRegistry = null;
    private YoRegistry controllerRegistry = null;
    private YoRegistry testRegistry = null;
    private YoRegistryChangedListener listener = null;
    private YoVariable lastRegisteredVariable = null;
    private YoRegistry lastAddedRegistry = null;
    private YoRegistry lastRemovedRegistry = null;
    private YoRegistry lastClearedRegistry = null;
    private YoDouble robotVariable;
    private YoDouble controlVariable;

    @BeforeEach
    public void setUp() {
        this.robotRegistry = new YoRegistry("robot");
        this.controllerRegistry = new YoRegistry("controller");
        this.testRegistry = new YoRegistry("testRegistry");
        this.robotRegistry.addChild(this.controllerRegistry);
        this.controllerRegistry.addChild(this.testRegistry);
        this.robotVariable = new YoDouble("robotVariable", this.robotRegistry);
        this.controlVariable = new YoDouble("controlVariable", this.controllerRegistry);
        this.createAndAddNYoVariables(4, this.testRegistry);
        this.listener = new YoRegistryChangedListener(){

            public void changed(YoRegistryChangedListener.Change change) {
                if (change.wasVariableAdded()) {
                    YoRegistryTest.this.lastRegisteredVariable = change.getTargetVariable();
                }
                if (change.wasRegistryAdded()) {
                    YoRegistryTest.this.lastAddedRegistry = change.getTargetRegistry();
                }
                if (change.wasRegistryRemoved()) {
                    YoRegistryTest.this.lastRemovedRegistry = change.getTargetRegistry();
                }
                if (change.wasCleared()) {
                    YoRegistryTest.this.lastClearedRegistry = change.getSource();
                }
            }
        };
    }

    private void createAndAddNYoVariables(int numberVariablesToAdd, YoRegistry registry) {
        if (numberVariablesToAdd >= 1) {
            new YoDouble("variableOne", registry);
        }
        if (numberVariablesToAdd >= 2) {
            new YoDouble("variableTwo", registry);
        }
        if (numberVariablesToAdd >= 3) {
            new YoDouble("variableThree", registry);
        }
        if (numberVariablesToAdd >= 4) {
            new YoDouble("variableFour", registry);
        }
    }

    @AfterEach
    public void tearDown() {
        this.robotRegistry = null;
        this.controllerRegistry = null;
        this.testRegistry = null;
        this.listener = null;
        this.lastRegisteredVariable = null;
        this.lastAddedRegistry = null;
        this.lastClearedRegistry = null;
    }

    @Test
    public void testCantAddChildWithSameName() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            String name = "sameName";
            YoRegistry child1 = new YoRegistry(name);
            YoRegistry child2 = new YoRegistry(name);
            this.testRegistry.addChild(child1);
            this.testRegistry.addChild(child2);
        });
    }

    @Test
    public void testGetName() {
        Assertions.assertEquals((Object)"robot", (Object)this.robotRegistry.getName());
        Assertions.assertEquals((Object)"controller", (Object)this.controllerRegistry.getName());
        Assertions.assertEquals((Object)"testRegistry", (Object)this.testRegistry.getName());
    }

    @Test
    public void testGetAllVariables() {
        List allVars = this.testRegistry.collectSubtreeVariables();
        Assertions.assertTrue((allVars.size() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testGetNamespace() {
        YoNamespace expectedReturn = new YoNamespace("robot.controller.testRegistry");
        YoNamespace actualReturn = this.testRegistry.getNamespace();
        Assertions.assertEquals((Object)expectedReturn, (Object)actualReturn, (String)"return value");
    }

    @Test
    public void testGetVariable() {
        YoVariable variableOne = this.testRegistry.findVariable("variableOne");
        YoVariable variableTwo = this.testRegistry.findVariable("variableTwo");
        YoVariable variableThree = this.testRegistry.findVariable("variableThree");
        YoVariable variableFour = this.testRegistry.findVariable("variableFour");
        Assertions.assertTrue((boolean)variableOne.getName().equals("variableOne"));
        Assertions.assertTrue((boolean)variableTwo.getName().equals("variableTwo"));
        Assertions.assertTrue((boolean)variableThree.getName().equals("variableThree"));
        Assertions.assertTrue((boolean)variableFour.getName().equals("variableFour"));
        YoVariable doesntExist = this.testRegistry.findVariable("fooy");
        Assertions.assertTrue((doesntExist == null ? 1 : 0) != 0);
        variableOne = this.testRegistry.findVariable("robot.controller.testRegistry.variableOne");
        variableTwo = this.testRegistry.findVariable("robot.controller.testRegistry.variableTwo");
        variableThree = this.testRegistry.findVariable("robot.controller.testRegistry.variableThree");
        variableFour = this.testRegistry.findVariable("robot.controller.testRegistry.variableFour");
        Assertions.assertTrue((boolean)variableOne.getName().equals("variableOne"));
        Assertions.assertTrue((boolean)variableTwo.getName().equals("variableTwo"));
        Assertions.assertTrue((boolean)variableThree.getName().equals("variableThree"));
        Assertions.assertTrue((boolean)variableFour.getName().equals("variableFour"));
        variableOne = this.testRegistry.findVariable("testRegistry.variableOne");
        variableTwo = this.testRegistry.findVariable("controller.testRegistry.variableTwo");
        variableThree = this.testRegistry.findVariable("testRegistry.variableThree");
        variableFour = this.testRegistry.findVariable("controller.testRegistry.variableFour");
        Assertions.assertTrue((boolean)variableOne.getName().equals("variableOne"));
        Assertions.assertTrue((boolean)variableTwo.getName().equals("variableTwo"));
        Assertions.assertTrue((boolean)variableThree.getName().equals("variableThree"));
        Assertions.assertTrue((boolean)variableFour.getName().equals("variableFour"));
        variableOne = this.testRegistry.findVariable("robot.controller.variableOne");
        variableTwo = this.testRegistry.findVariable("robot.testRegistry.variableTwo");
        variableThree = this.testRegistry.findVariable("bot.controller.testRegistry.variableThree");
        variableFour = this.testRegistry.findVariable("robot.controller.testRegis.variableFour");
        Assertions.assertNull((Object)variableOne);
        Assertions.assertNull((Object)variableTwo);
        Assertions.assertNull((Object)variableThree);
        Assertions.assertNull((Object)variableFour);
    }

    @Test
    public void testCaseInsensitivityToNameButNotNamespace() {
        YoVariable variableOne = this.testRegistry.findVariable("variableone");
        YoVariable variableTwo = this.testRegistry.findVariable("variableTWO");
        YoVariable variableThree = this.testRegistry.findVariable("VAriableThree");
        YoVariable variableFour = this.testRegistry.findVariable("variableFour");
        Assertions.assertTrue((boolean)variableOne.getName().equals("variableOne"));
        Assertions.assertTrue((boolean)variableTwo.getName().equals("variableTwo"));
        Assertions.assertTrue((boolean)variableThree.getName().equals("variableThree"));
        Assertions.assertTrue((boolean)variableFour.getName().equals("variableFour"));
        variableOne = this.testRegistry.findVariable("robot.controller.testRegistry.variableONE");
        variableTwo = this.testRegistry.findVariable("robot.controller.testRegistry.variableTwo");
        variableThree = this.testRegistry.findVariable("robot.controller.testRegistry.variableTHREe");
        variableFour = this.testRegistry.findVariable("robot.controller.testRegistry.VAriableFour");
        Assertions.assertTrue((boolean)variableOne.getName().equals("variableOne"));
        Assertions.assertTrue((boolean)variableTwo.getName().equals("variableTwo"));
        Assertions.assertTrue((boolean)variableThree.getName().equals("variableThree"));
        Assertions.assertTrue((boolean)variableFour.getName().equals("variableFour"));
        variableOne = this.testRegistry.findVariable("testRegistry.variableONE");
        variableTwo = this.testRegistry.findVariable("controller.testRegistry.variableTWO");
        variableThree = this.testRegistry.findVariable("testRegistry.variableThREE");
        variableFour = this.testRegistry.findVariable("controller.testRegistry.VAriableFour");
        Assertions.assertTrue((boolean)variableOne.getName().equals("variableOne"));
        Assertions.assertTrue((boolean)variableTwo.getName().equals("variableTwo"));
        Assertions.assertTrue((boolean)variableThree.getName().equals("variableThree"));
        Assertions.assertTrue((boolean)variableFour.getName().equals("variableFour"));
        variableOne = this.testRegistry.findVariable("Robot.controller.testRegistry.variableOne");
        variableTwo = this.testRegistry.findVariable("robot.coNtroller.testRegistry.variableTwo");
        variableThree = this.testRegistry.findVariable("robot.controller.TestRegistry.variableThree");
        variableFour = this.testRegistry.findVariable("robot.controller.testRegistrY.variableFour");
        Assertions.assertNull((Object)variableOne);
        Assertions.assertNull((Object)variableTwo);
        Assertions.assertNull((Object)variableThree);
        Assertions.assertNull((Object)variableFour);
    }

    @Test
    public void testGetVariable1() {
        String namespace = "robot.controller.testRegistry";
        YoVariable variableOne = this.testRegistry.findVariable(namespace, "variableOne");
        YoVariable variableTwo = this.testRegistry.findVariable(namespace, "variableTwo");
        YoVariable variableThree = this.testRegistry.findVariable(namespace, "variableThree");
        YoVariable variableFour = this.testRegistry.findVariable(namespace, "variableFour");
        Assertions.assertTrue((boolean)variableOne.getName().equals("variableOne"));
        Assertions.assertTrue((boolean)variableTwo.getName().equals("variableTwo"));
        Assertions.assertTrue((boolean)variableThree.getName().equals("variableThree"));
        Assertions.assertTrue((boolean)variableFour.getName().equals("variableFour"));
        namespace = "controller.testRegistry";
        variableOne = this.testRegistry.findVariable(namespace, "variableOne");
        variableTwo = this.testRegistry.findVariable(namespace, "variableTwo");
        variableThree = this.testRegistry.findVariable(namespace, "variableThree");
        variableFour = this.testRegistry.findVariable(namespace, "variableFour");
        Assertions.assertTrue((boolean)variableOne.getName().equals("variableOne"));
        Assertions.assertTrue((boolean)variableTwo.getName().equals("variableTwo"));
        Assertions.assertTrue((boolean)variableThree.getName().equals("variableThree"));
        Assertions.assertTrue((boolean)variableFour.getName().equals("variableFour"));
        namespace = "testRegistry";
        variableOne = this.testRegistry.findVariable(namespace, "variableOne");
        variableTwo = this.testRegistry.findVariable(namespace, "variableTwo");
        variableThree = this.testRegistry.findVariable(namespace, "variableThree");
        variableFour = this.testRegistry.findVariable(namespace, "variableFour");
        Assertions.assertTrue((boolean)variableOne.getName().equals("variableOne"));
        Assertions.assertTrue((boolean)variableTwo.getName().equals("variableTwo"));
        Assertions.assertTrue((boolean)variableThree.getName().equals("variableThree"));
        Assertions.assertTrue((boolean)variableFour.getName().equals("variableFour"));
        namespace = ".testRegistry";
        variableOne = this.testRegistry.findVariable(namespace, "variableOne");
        variableTwo = this.testRegistry.findVariable(namespace, "variableTwo");
        variableThree = this.testRegistry.findVariable(namespace, "variableThree");
        variableFour = this.testRegistry.findVariable(namespace, "variableFour");
        Assertions.assertNull((Object)variableOne);
        Assertions.assertNull((Object)variableTwo);
        Assertions.assertNull((Object)variableThree);
        Assertions.assertNull((Object)variableFour);
        boolean testPassed = true;
        try {
            this.testRegistry.findVariable(namespace, "foo.variableOne");
            testPassed = false;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)testPassed);
    }

    @Test
    public void testGetVariables1() {
        List variables = this.testRegistry.findVariables("variableOne");
        Assertions.assertTrue((variables.size() == 1 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("variableTwo");
        Assertions.assertTrue((variables.size() == 1 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("variableThree");
        Assertions.assertTrue((variables.size() == 1 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("variableFour");
        Assertions.assertTrue((variables.size() == 1 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("variable");
        Assertions.assertTrue((variables.size() == 0 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("robot.controller.testRegistry.variableOne");
        Assertions.assertTrue((variables.size() == 1 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("controller.testRegistry.variableOne");
        Assertions.assertTrue((variables.size() == 1 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("testRegistry.variableOne");
        Assertions.assertTrue((variables.size() == 1 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("estRegistry.variableOne");
        Assertions.assertTrue((variables.size() == 0 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("foo.robot.controller.testRegistry.variableOne");
        Assertions.assertTrue((variables.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetVariables2() {
        List variables = this.testRegistry.findVariables("robot.controller.testRegistry", "variableOne");
        Assertions.assertTrue((variables.size() == 1 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("robot.controller.testRegistry", "variableTwo");
        Assertions.assertTrue((variables.size() == 1 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("robot.controller.testRegistry", "variableThree");
        Assertions.assertTrue((variables.size() == 1 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("robot.controller.testRegistry", "variableFour");
        Assertions.assertTrue((variables.size() == 1 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("robot.controller.testRegistry", "variable");
        Assertions.assertTrue((variables.size() == 0 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("controller.testRegistry", "variableOne");
        Assertions.assertTrue((variables.size() == 1 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("testRegistry", "variableOne");
        Assertions.assertTrue((variables.size() == 1 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("estRegistry", "variableOne");
        Assertions.assertTrue((variables.size() == 0 ? 1 : 0) != 0);
        variables = this.testRegistry.findVariables("foo.robot.controller.testRegistry", "variableOne");
        Assertions.assertTrue((variables.size() == 0 ? 1 : 0) != 0);
        boolean testPassed = true;
        try {
            variables = this.testRegistry.findVariables("robot.controller.testRegistry", "robot.controller.testRegistry.variableOne");
            testPassed = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)testPassed);
    }

    @Test
    public void testHasUniqueVariable() {
        String name = "";
        boolean expectedReturn = false;
        boolean actualReturn = this.testRegistry.hasUniqueVariable(name);
        Assertions.assertEquals((Object)expectedReturn, (Object)actualReturn, (String)"return value");
        Assertions.assertTrue((boolean)this.testRegistry.hasUniqueVariable("variableOne"));
        Assertions.assertFalse((boolean)this.testRegistry.hasUniqueVariable("dontHaveMeVariable"));
        Assertions.assertTrue((boolean)this.testRegistry.hasUniqueVariable("robot.controller.testRegistry", "variableTwo"));
        Assertions.assertTrue((boolean)this.testRegistry.hasUniqueVariable("controller.testRegistry", "variableTwo"));
        Assertions.assertFalse((boolean)this.testRegistry.hasUniqueVariable("robot.controller", "variableTwo"));
    }

    @Test
    public void testHasUniqueVariable1() {
        String namespace = "";
        String name = "";
        boolean expectedReturn = false;
        boolean actualReturn = this.testRegistry.hasUniqueVariable(namespace, name);
        Assertions.assertEquals((Object)expectedReturn, (Object)actualReturn, (String)"return value");
    }

    @Test
    public void testRegisterVariable() {
        boolean testPassed = true;
        try {
            this.testRegistry.addVariable(null);
            testPassed = false;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)testPassed);
        this.testRegistry.addVariable((YoVariable)new YoDouble("variableFive", null));
        Assertions.assertTrue((boolean)this.testRegistry.hasUniqueVariable("variableFive"));
    }

    @Test
    public void testCannotRegisterSameVariableName() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            YoDouble variableFiveOnce = new YoDouble("variableFive", null);
            YoDouble variableFiveTwice = new YoDouble("variableFive", null);
            this.testRegistry.addVariable((YoVariable)variableFiveOnce);
            Assertions.assertTrue((boolean)this.testRegistry.hasUniqueVariable("variableFive"));
            this.testRegistry.addVariable((YoVariable)variableFiveTwice);
        });
    }

    @Test
    public void testGetYoVariables() {
        List robotVariablesOnly = this.robotRegistry.getVariables();
        List controlVariablesOnly = this.controllerRegistry.getVariables();
        List testRegistryVariablesOnly = this.testRegistry.getVariables();
        Assertions.assertEquals((int)1, (int)robotVariablesOnly.size());
        Assertions.assertEquals((int)1, (int)controlVariablesOnly.size());
        Assertions.assertEquals((int)4, (int)testRegistryVariablesOnly.size());
    }

    @Test
    public void testAddChildAndGetParentAndGetChildren() {
        Assertions.assertEquals((Object)this.robotRegistry.getParent(), null);
        YoRegistry childOne = new YoRegistry("childOne");
        Assertions.assertEquals((Object)childOne.getParent(), null);
        this.testRegistry.addChild(childOne);
        boolean testPassed = true;
        try {
            YoRegistry childOneRepeat = new YoRegistry("childOne");
            this.testRegistry.addChild(childOneRepeat);
            testPassed = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)testPassed);
    }

    @Test
    public void testDontLetAChildGetAddedToTwoRegistries() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            YoRegistry root1 = new YoRegistry("root1");
            root1.setRestrictionLevel(YoRegistryRestrictionLevel.RESTRICTED);
            YoRegistry root2 = new YoRegistry("root2");
            YoRegistry child = new YoRegistry("child");
            root1.addChild(child);
            root2.addChild(child);
        });
    }

    @Test
    public void testIllegalName1() {
        String illegalName = "foo..foo";
        boolean runtimeExceptionThrown = false;
        try {
            this.testRegistry = new YoRegistry(illegalName);
        }
        catch (RuntimeException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains(illegalName));
            runtimeExceptionThrown = true;
        }
        Assertions.assertTrue((boolean)runtimeExceptionThrown);
    }

    @Test
    public void testIllegalName2() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            this.testRegistry = new YoRegistry("foo.");
        });
    }

    @Test
    public void testNoDotsAllowed() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            this.testRegistry = new YoRegistry("foo.bar");
        });
    }

    @Test
    public void testIllegalAddChild() {
        Assertions.assertThrows(IllegalOperationException.class, () -> {
            YoRegistry childOne = new YoRegistry("childOne");
            childOne.addChild(childOne);
        });
    }

    @Test
    public void testGetAllVariablesIncludingDescendants() {
        YoRegistry childOne = new YoRegistry("childOne");
        int nVarsChildOne = 3;
        this.createAndAddNYoVariables(nVarsChildOne, childOne);
        YoRegistry childTwo = new YoRegistry("childTwo");
        int nVarsChildTwo = 2;
        this.createAndAddNYoVariables(nVarsChildTwo, childTwo);
        this.testRegistry.addChild(childOne);
        this.testRegistry.addChild(childTwo);
        int nVarsExpected = nVarsChildOne + nVarsChildTwo + 4;
        List allVariables = this.testRegistry.collectSubtreeVariables();
        Assertions.assertEquals((int)nVarsExpected, (int)allVariables.size());
        Assertions.assertEquals((int)nVarsChildTwo, (int)childTwo.collectSubtreeVariables().size());
    }

    @Test
    public void testFamilyRelations() {
        YoRegistry childOne = new YoRegistry("childOne");
        YoRegistry childTwo = new YoRegistry("childTwo");
        this.testRegistry.addChild(childOne);
        this.testRegistry.addChild(childTwo);
        Assertions.assertEquals((Object)childOne.getParent(), (Object)this.testRegistry);
        Assertions.assertEquals((Object)childTwo.getParent(), (Object)this.testRegistry);
        List children = this.testRegistry.getChildren();
        int childrenSize = children.size();
        Assertions.assertEquals((int)2, (int)childrenSize);
        Assertions.assertTrue((boolean)children.contains(childOne));
        Assertions.assertTrue((boolean)children.contains(childTwo));
    }

    @Test
    public void testCantAddDuplicateSubnames() {
        Assertions.assertThrows(IllegalNameException.class, () -> {
            YoRegistry childOne = new YoRegistry("childOne");
            this.testRegistry.addChild(childOne);
            YoRegistry grandChildOne = new YoRegistry(childOne.getParent().getNamespace().getRootName());
            childOne.addChild(grandChildOne);
        });
    }

    @Test
    public void testNullChild() {
        YoRegistry nullChild = null;
        YoRegistry testNullChild = new YoRegistry("TestNullChild");
        testNullChild.addChild(nullChild);
        Assertions.assertEquals((int)0, (int)testNullChild.getChildren().size());
    }

    @Test
    public void testRegistryTree() {
        YoRegistry root = new YoRegistry("root");
        YoRegistry registry0 = new YoRegistry("registry0");
        Assertions.assertEquals((Object)"registry0", (Object)registry0.getNamespace().getName());
        YoRegistry registry1 = new YoRegistry("registry1");
        YoRegistry registry2 = new YoRegistry("registry2");
        root.addChild(registry0);
        Assertions.assertEquals((Object)"root.registry0", (Object)registry0.getNamespace().getName());
        Assertions.assertEquals((Object)"registry0", (Object)registry0.getNamespace().getShortName());
        root.addChild(registry2);
        YoRegistry registry00 = new YoRegistry("registry00");
        YoRegistry registry01 = new YoRegistry("registry01");
        registry0.addChild(registry00);
        registry0.addChild(registry01);
        YoRegistry registry10 = new YoRegistry("registry10");
        registry1.addChild(registry10);
        YoRegistry registry010 = new YoRegistry("registry010");
        YoRegistry registry011 = new YoRegistry("registry011");
        registry01.addChild(registry010);
        YoDouble variable0_A = new YoDouble("variable0_A", registry0);
        YoDouble variable0_B = new YoDouble("variable0_B", registry0);
        YoDouble variable10_A = new YoDouble("variable10_A", registry10);
        YoDouble variable011_A = new YoDouble("variable011_A", registry011);
        YoDouble repeatedVariable_root = new YoDouble("repeatedVariable", root);
        YoDouble repeatedVariable_registry0 = new YoDouble("repeatedVariable", registry0);
        YoDouble repeatedVariable_registry01 = new YoDouble("repeatedVariable", registry01);
        YoDouble repeatedVariable_registry010 = new YoDouble("repeatedVariable", registry010);
        root.addChild(registry1);
        registry01.addChild(registry011);
        Assertions.assertEquals((Object)"root.registry0.registry01.registry011", (Object)registry011.getNamespace().getName());
        Assertions.assertEquals((Object)"root.registry0.variable0_A", (Object)variable0_A.getFullNameString());
        Assertions.assertEquals((Object)"root.registry0.variable0_B", (Object)variable0_B.getFullNameString());
        Assertions.assertEquals((Object)"root.registry1.registry10.variable10_A", (Object)variable10_A.getFullNameString());
        Assertions.assertEquals((Object)"root.registry0.registry01.registry011.variable011_A", (Object)variable011_A.getFullNameString());
        List allRootVariables = root.collectSubtreeVariables();
        Assertions.assertEquals((int)8, (int)allRootVariables.size());
        Assertions.assertTrue((boolean)registry10.hasUniqueVariable("root.registry1.registry10.variable10_A"));
        Assertions.assertEquals((Object)variable10_A, (Object)registry10.findVariable("root.registry1.registry10.variable10_A"));
        Assertions.assertEquals((Object)variable10_A, (Object)registry10.findVariable("registry10.variable10_A"));
        Assertions.assertEquals((Object)variable10_A, (Object)registry10.findVariable("variable10_A"));
        Assertions.assertTrue((boolean)root.hasUniqueVariable("root.registry1.registry10.variable10_A"));
        Assertions.assertTrue((boolean)root.hasUniqueVariable("registry1.registry10.variable10_A"));
        Assertions.assertTrue((boolean)root.hasUniqueVariable("registry10.variable10_A"));
        Assertions.assertTrue((boolean)root.hasUniqueVariable("variable10_A"));
        Assertions.assertFalse((boolean)root.hasUniqueVariable("repeatedVariable"));
        Assertions.assertFalse((boolean)registry0.hasUniqueVariable("repeatedVariable"));
        Assertions.assertFalse((boolean)registry01.hasUniqueVariable("repeatedVariable"));
        Assertions.assertTrue((boolean)registry010.hasUniqueVariable("repeatedVariable"));
        Assertions.assertTrue((boolean)root.hasUniqueVariable("registry0.repeatedVariable"));
        Assertions.assertTrue((boolean)root.hasUniqueVariable("registry0", "repeatedVariable"));
        Assertions.assertFalse((boolean)root.hasUniqueVariable("registry0.noWay"));
        Assertions.assertFalse((boolean)root.hasUniqueVariable("noWay.repeatedVariable"));
        Assertions.assertFalse((boolean)root.hasUniqueVariable("noWay", "repeatedVariable"));
        Assertions.assertEquals((Object)variable10_A, (Object)registry1.findVariable("variable10_A"));
        Assertions.assertEquals((Object)variable10_A, (Object)root.findVariable("variable10_A"));
        Assertions.assertEquals((Object)variable011_A, (Object)root.findVariable("variable011_A"));
        Assertions.assertEquals((Object)variable011_A, (Object)registry0.findVariable("variable011_A"));
        Assertions.assertEquals((Object)variable011_A, (Object)registry01.findVariable("variable011_A"));
        Assertions.assertEquals((Object)variable011_A, (Object)registry011.findVariable("variable011_A"));
        Assertions.assertEquals((Object)repeatedVariable_root, (Object)root.findVariable("repeatedVariable"));
        Assertions.assertEquals((Object)repeatedVariable_registry0, (Object)registry0.findVariable("repeatedVariable"));
        Assertions.assertEquals((Object)repeatedVariable_registry01, (Object)registry01.findVariable("repeatedVariable"));
        Assertions.assertEquals((Object)repeatedVariable_registry010, (Object)registry010.findVariable("repeatedVariable"));
        Assertions.assertEquals((int)4, (int)root.findVariables("repeatedVariable").size());
    }

    @Test
    public void testDontAllowRepeatRegistryNames() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            YoRegistry root = new YoRegistry("root");
            YoRegistry levelOne = new YoRegistry("levelOne");
            YoRegistry registryOne = new YoRegistry("registryOne");
            YoRegistry registryOneRepeat = new YoRegistry("registryOne");
            root.addChild(levelOne);
            levelOne.addChild(registryOne);
            levelOne.addChild(registryOneRepeat);
        });
    }

    @Test
    public void testCantAddAChildWithANullNamespace() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            YoRegistry root = new YoRegistry("root");
            YoRegistry child = new YoRegistry("");
            root.addChild(child);
        });
    }

    @Test
    public void testGetAllRegistriesIncludingChildren() {
        List registries = this.robotRegistry.collectSubtreeRegistries();
        Assertions.assertEquals((int)3, (int)registries.size());
        Assertions.assertTrue((boolean)registries.contains(this.robotRegistry));
        Assertions.assertTrue((boolean)registries.contains(this.controllerRegistry));
        Assertions.assertTrue((boolean)registries.contains(this.testRegistry));
    }

    @Test
    public void testGetRegistry() {
        Assertions.assertEquals((Object)this.robotRegistry, (Object)this.robotRegistry.findRegistry(new YoNamespace("robot")));
        Assertions.assertEquals((Object)this.controllerRegistry, (Object)this.robotRegistry.findRegistry(new YoNamespace("robot.controller")));
        Assertions.assertEquals((Object)this.testRegistry, (Object)this.robotRegistry.findRegistry(new YoNamespace("robot.controller.testRegistry")));
        Assertions.assertEquals((Object)this.controllerRegistry, (Object)this.controllerRegistry.findRegistry(new YoNamespace("robot.controller")));
        Assertions.assertEquals((Object)this.testRegistry, (Object)this.controllerRegistry.findRegistry(new YoNamespace("robot.controller.testRegistry")));
        Assertions.assertEquals((Object)this.testRegistry, (Object)this.testRegistry.findRegistry(new YoNamespace("robot.controller.testRegistry")));
        Assertions.assertTrue((this.testRegistry == this.robotRegistry.findRegistry(new YoNamespace("testRegistry")) ? 1 : 0) != 0);
        Assertions.assertTrue((this.testRegistry == this.robotRegistry.findRegistry(new YoNamespace("controller.testRegistry")) ? 1 : 0) != 0);
        Assertions.assertTrue((this.robotRegistry != this.controllerRegistry.findRegistry(new YoNamespace("robot")) ? 1 : 0) != 0);
    }

    @Test
    public void testGetNumberOfVariables() {
        Assertions.assertEquals((int)1, (int)this.robotRegistry.getNumberOfVariables());
        Assertions.assertEquals((int)1, (int)this.controllerRegistry.getNumberOfVariables());
        Assertions.assertEquals((int)4, (int)this.testRegistry.getNumberOfVariables());
    }

    @Test
    public void testListenersOne() {
        this.robotRegistry.addListener(this.listener);
        Assertions.assertNull((Object)this.lastRegisteredVariable);
        YoDouble addedYoVariable = new YoDouble("addedLater", this.controllerRegistry);
        Assertions.assertEquals((Object)addedYoVariable, (Object)this.lastRegisteredVariable);
        Assertions.assertNull((Object)this.lastAddedRegistry);
        YoRegistry addedRegistry = new YoRegistry("addedRegistry");
        this.testRegistry.addChild(addedRegistry);
        Assertions.assertEquals((Object)addedRegistry, (Object)this.lastAddedRegistry);
        this.testRegistry.addListener(this.listener);
        Assertions.assertNull((Object)this.lastClearedRegistry);
        Assertions.assertNull((Object)this.lastRemovedRegistry);
        this.testRegistry.clear();
        Assertions.assertEquals((Object)this.testRegistry, (Object)this.lastRemovedRegistry);
        Assertions.assertEquals((Object)this.testRegistry, (Object)this.lastClearedRegistry);
    }

    @Test
    public void testAreEqual() {
        YoRegistry robotRegistryClone = new YoRegistry("robot");
        YoRegistry controllerRegistryClone = new YoRegistry("controller");
        YoRegistry testRegistryClone = new YoRegistry("testRegistry");
        robotRegistryClone.addChild(controllerRegistryClone);
        controllerRegistryClone.addChild(testRegistryClone);
        new YoDouble("robotVariable", robotRegistryClone);
        new YoDouble("controlVariable", controllerRegistryClone);
        this.createAndAddNYoVariables(4, testRegistryClone);
        Assertions.assertTrue((boolean)this.robotRegistry.equals((Object)robotRegistryClone));
    }

    @Test
    public void testClear() {
        Assertions.assertFalse((this.robotRegistry.collectSubtreeVariables().size() == 0 ? 1 : 0) != 0);
        Assertions.assertFalse((this.robotRegistry.getChildren().size() == 0 ? 1 : 0) != 0);
        this.robotRegistry.clear();
        Assertions.assertTrue((this.robotRegistry.collectSubtreeVariables().size() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.robotRegistry.getChildren().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetVariables() {
        YoNamespace robotNamespace = new YoNamespace("robot");
        List robotVariables = this.robotRegistry.findVariables(robotNamespace);
        Assertions.assertTrue((robotVariables.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)robotVariables.contains(this.robotVariable));
        Assertions.assertFalse((boolean)robotVariables.contains(this.controlVariable));
        YoNamespace controllerNamespace = new YoNamespace("robot.controller");
        List controllerVariables = this.robotRegistry.findVariables(controllerNamespace);
        Assertions.assertTrue((controllerVariables.size() == 1 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)controllerVariables.contains(this.robotVariable));
        Assertions.assertTrue((boolean)controllerVariables.contains(this.controlVariable));
    }

    @Test
    public void testParameters() {
        YoRegistry a = new YoRegistry("a");
        YoRegistry aa = new YoRegistry("aa");
        YoRegistry ab = new YoRegistry("ab");
        YoRegistry aaa = new YoRegistry("aaa");
        YoRegistry aab = new YoRegistry("aab");
        DoubleParameter paramater1 = new DoubleParameter("parameter1", aa);
        DoubleParameter paramater2 = new DoubleParameter("parameter2", aaa);
        DoubleParameter paramater3 = new DoubleParameter("parameter3", aaa);
        new YoDouble("double1", a);
        new YoDouble("double2", aa);
        new YoDouble("double3", ab);
        new YoDouble("double4", aaa);
        new YoDouble("double5", aab);
        a.addChild(aa);
        a.addChild(ab);
        aa.addChild(aaa);
        aa.addChild(aab);
        Assertions.assertFalse((boolean)a.hasParameters());
        Assertions.assertTrue((boolean)a.hasParametersDeep());
        Assertions.assertTrue((boolean)aa.hasParameters());
        Assertions.assertTrue((boolean)aaa.hasParameters());
        Assertions.assertFalse((boolean)ab.hasParameters());
        Assertions.assertFalse((boolean)aab.hasParameters());
        Assertions.assertEquals((int)3, (int)a.collectSubtreeParameters().size());
        Assertions.assertEquals((int)3, (int)aa.collectSubtreeParameters().size());
        Assertions.assertEquals((int)2, (int)aaa.collectSubtreeParameters().size());
        Assertions.assertEquals((int)0, (int)ab.collectSubtreeParameters().size());
        Assertions.assertEquals((int)0, (int)aab.collectSubtreeParameters().size());
        Assertions.assertEquals((int)1, (int)aa.getParameters().size());
        Assertions.assertEquals((int)2, (int)aaa.getParameters().size());
        Assertions.assertEquals((int)0, (int)a.getParameters().size());
        Assertions.assertEquals((int)0, (int)ab.getParameters().size());
        Assertions.assertEquals((int)0, (int)aab.getParameters().size());
        Assertions.assertTrue((boolean)a.collectSubtreeParameters().contains(paramater1));
        Assertions.assertTrue((boolean)a.collectSubtreeParameters().contains(paramater2));
        Assertions.assertTrue((boolean)a.collectSubtreeParameters().contains(paramater3));
        Assertions.assertTrue((boolean)aa.getParameters().contains(paramater1));
        Assertions.assertTrue((boolean)aaa.getParameters().contains(paramater2));
        Assertions.assertTrue((boolean)aaa.getParameters().contains(paramater3));
    }
}

