/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import us.ihmc.yoVariables.listener.YoParameterChangedListener;
import us.ihmc.yoVariables.parameters.LongParameter;
import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoLong;

@Execution(value=ExecutionMode.SAME_THREAD)
public class LongParameterTest {
    private static final long initialValue = 42L;

    public LongParameter createParameterWithNamespace() {
        YoRegistry root = new YoRegistry("root");
        YoRegistry a = new YoRegistry("a");
        YoRegistry b = new YoRegistry("b");
        YoRegistry c = new YoRegistry("c");
        root.addChild(a);
        a.addChild(b);
        b.addChild(c);
        LongParameter param = new LongParameter("param", "paramDescription", c, 42L, -102024L, 294L);
        return param;
    }

    @Test
    public void testConstructDefaultValue() {
        YoRegistry dummy = new YoRegistry("dummy");
        LongParameter test = new LongParameter("test", dummy);
        test.loadDefault();
        Assertions.assertEquals((long)0L, (long)test.getValue());
    }

    @Test
    public void testDuplicate() {
        LongParameter param = this.createParameterWithNamespace();
        YoLong var = param.getVariable();
        param.loadDefault();
        var.set(632L);
        YoRegistry newRegistry = new YoRegistry("newRegistry");
        YoLong newVar = var.duplicate(newRegistry);
        LongParameter newParam = (LongParameter)newVar.getParameter();
        Assertions.assertEquals((Object)param.getName(), (Object)newParam.getName());
        Assertions.assertEquals((Object)param.getDescription(), (Object)newParam.getDescription());
        Assertions.assertEquals((double)param.getValue(), (double)newParam.getValue(), (double)1.0E-9);
        Assertions.assertEquals((double)var.getLowerBound(), (double)newVar.getLowerBound(), (double)1.0E-9);
        Assertions.assertEquals((double)var.getUpperBound(), (double)newVar.getUpperBound(), (double)1.0E-9);
    }

    @Test
    public void testGetNamespace() {
        LongParameter param = this.createParameterWithNamespace();
        Assertions.assertEquals((Object)"root.a.b.c", (Object)param.getNamespace().toString());
        Assertions.assertEquals((Object)"param", (Object)param.getName());
    }

    @Test
    public void testLoadFromString() {
        for (long s = -214748364800L; s < 214748364700L; s += Integer.MAX_VALUE) {
            YoRegistry dummy = new YoRegistry("dummy");
            LongParameter param = new LongParameter("test", dummy);
            param.load(String.valueOf(s));
            Assertions.assertEquals((long)s, (long)param.getValue());
            Assertions.assertEquals((Object)String.valueOf(s), (Object)param.getValueAsString());
        }
    }

    @Test
    public void testGetBeforeLoad() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            LongParameter param = this.createParameterWithNamespace();
            param.getValue();
        });
    }

    @Test
    public void testDefault() {
        LongParameter param = this.createParameterWithNamespace();
        param.loadDefault();
        Assertions.assertEquals((long)42L, (long)param.getValue());
    }

    @Test
    public void testListener() {
        LongParameter param = this.createParameterWithNamespace();
        CallbackTest callback = new CallbackTest();
        param.addListener((YoParameterChangedListener)callback);
        Assertions.assertFalse((boolean)callback.set);
        param.loadDefault();
        callback.set = false;
        param.getVariable().setValueFromDouble(param.getVariable().getValueAsDouble());
        Assertions.assertFalse((boolean)callback.set);
        param.getVariable().setValueFromDouble(1.0);
        Assertions.assertTrue((boolean)callback.set);
    }

    private class CallbackTest
    implements YoParameterChangedListener {
        boolean set = false;

        private CallbackTest() {
        }

        public void changed(YoParameter v) {
            this.set = true;
        }
    }
}

