/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoVariable;

class YoMutableFramePose3DTest {
    YoMutableFramePose3DTest() {
    }

    @Test
    public void testMutableFrameObject() {
        YoRegistry registry = new YoRegistry("TestRegistry");
        Random random = new Random(4290L);
        ArrayList<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
        frames.addAll(Arrays.asList(EuclidFrameRandomTools.nextReferenceFrameTree((Random)random)));
        frames.add(null);
        YoMutableFramePose3D mutableFrameObject = new YoMutableFramePose3D("", "", registry);
        YoVariable frameIndex = registry.findVariable(YoGeometryNameTools.assembleName((String[])new String[]{"", "frame", ""}));
        Assertions.assertNotNull((Object)frameIndex);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame frame = (ReferenceFrame)frames.get(random.nextInt(frames.size()));
            mutableFrameObject.setReferenceFrame(frame);
            Assertions.assertTrue((frame == mutableFrameObject.getReferenceFrame() ? 1 : 0) != 0);
            if (frame == null) {
                Assertions.assertEquals((long)-1L, (long)frameIndex.getValueAsLongBits());
                continue;
            }
            Assertions.assertEquals((long)frame.getFrameIndex(), (long)frameIndex.getValueAsLongBits());
        }
    }

    @Test
    void testConstructors() {
        YoRegistry registry = new YoRegistry("dummy");
        new YoMutableFramePose3D("the", "pose", registry);
    }
}

