/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.variable;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoVariableType;

public class YoBooleanTest {
    private YoBoolean yoBoolean;
    private YoRegistry registry;
    private static final double EPSILON = 1.0E-10;

    @BeforeEach
    public void setUp() {
        this.registry = new YoRegistry("testRegistry");
        this.yoBoolean = new YoBoolean("booleanVariable", this.registry);
    }

    @AfterEach
    public void tearDown() {
        this.yoBoolean = null;
        this.registry = null;
    }

    @Test
    public void testBooleanYoVariable() {
        Assertions.assertEquals((Object)"booleanVariable", (Object)this.yoBoolean.getName());
        Assertions.assertEquals((Object)"testRegistry", (Object)this.yoBoolean.getRegistry().getName());
        Assertions.assertEquals((Object)false, (Object)this.yoBoolean.getBooleanValue());
    }

    @Test
    public void testValueEquals() {
        this.yoBoolean.set(false);
        Assertions.assertFalse((boolean)this.yoBoolean.valueEquals(true));
        this.yoBoolean.set(true);
        Assertions.assertTrue((boolean)this.yoBoolean.valueEquals(true));
        this.yoBoolean.set(false);
        Assertions.assertTrue((boolean)this.yoBoolean.valueEquals(false));
        this.yoBoolean.set(true);
        Assertions.assertFalse((boolean)this.yoBoolean.valueEquals(false));
    }

    @Test
    public void testGetAndSetBooleanYoVariable() {
        this.yoBoolean.set(false);
        Assertions.assertFalse((boolean)this.yoBoolean.getBooleanValue());
        this.yoBoolean.set(true);
        Assertions.assertTrue((boolean)this.yoBoolean.getBooleanValue());
    }

    @Test
    public void testSet_boolean_boolean() {
        Assertions.assertFalse((boolean)this.yoBoolean.getBooleanValue());
        boolean value = true;
        boolean notifyListeners = true;
        boolean result = this.yoBoolean.set(value, notifyListeners);
        Assertions.assertTrue((boolean)this.yoBoolean.getBooleanValue());
        Assertions.assertTrue((boolean)result);
        result = this.yoBoolean.set(value, notifyListeners);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    public void testGetAndSetAsDouble() {
        Random rng = new Random();
        double testRandom = 0.0;
        this.yoBoolean.setValueFromDouble(0.0);
        Assertions.assertFalse((boolean)this.yoBoolean.getBooleanValue());
        testRandom = (double)rng.nextInt(23000) / (double)rng.nextInt(5);
        this.yoBoolean.setValueFromDouble(10000.0);
        Assertions.assertTrue((boolean)this.yoBoolean.getBooleanValue());
        this.yoBoolean.setValueFromDouble(-0.4);
        Assertions.assertFalse((boolean)this.yoBoolean.getBooleanValue());
        for (int counter = 0; counter < 100; ++counter) {
            testRandom = rng.nextDouble();
            this.yoBoolean.setValueFromDouble(testRandom);
            if (testRandom >= 0.5) {
                Assertions.assertTrue((boolean)this.yoBoolean.getBooleanValue());
                continue;
            }
            Assertions.assertFalse((boolean)this.yoBoolean.getBooleanValue());
        }
    }

    @Test
    public void testGetValueAsDouble() {
        Assertions.assertFalse((boolean)this.yoBoolean.getBooleanValue());
        double result = this.yoBoolean.getValueAsDouble();
        Assertions.assertEquals((double)0.0, (double)result, (double)1.0E-10);
        this.yoBoolean.set(true);
        Assertions.assertTrue((boolean)this.yoBoolean.getBooleanValue());
        result = this.yoBoolean.getValueAsDouble();
        Assertions.assertEquals((double)1.0, (double)result, (double)1.0E-10);
    }

    @Test
    public void testToString() {
        this.yoBoolean.set(false);
        Assertions.assertEquals((Object)this.yoBoolean.toString(), (Object)"booleanVariable: false");
        this.yoBoolean.set(true);
        Assertions.assertEquals((Object)this.yoBoolean.toString(), (Object)"booleanVariable: true");
    }

    @Test
    public void testGetAndSetValueAsLongBits() {
        Assertions.assertFalse((boolean)this.yoBoolean.getBooleanValue());
        long value = this.yoBoolean.getValueAsLongBits();
        Assertions.assertEquals((long)0L, (long)value);
        this.yoBoolean.set(true);
        Assertions.assertTrue((boolean)this.yoBoolean.getBooleanValue());
        value = this.yoBoolean.getValueAsLongBits();
        Assertions.assertEquals((long)1L, (long)value);
        boolean notifyListeners = true;
        this.yoBoolean.setValueFromLongBits(value, notifyListeners);
    }

    @Test
    public void testYoVariableType() {
        Assertions.assertEquals((Object)this.yoBoolean.getType(), (Object)YoVariableType.BOOLEAN);
    }

    @Test
    public void testDuplicate() {
        YoRegistry newRegistry = new YoRegistry("newTestRegistry");
        this.yoBoolean.set(true);
        YoBoolean val = this.yoBoolean.duplicate(newRegistry);
        YoBoolean testVal = (YoBoolean)newRegistry.getVariables().get(0);
        Assertions.assertEquals((Object)this.yoBoolean.getBooleanValue(), (Object)val.getBooleanValue());
        Assertions.assertEquals((Object)this.yoBoolean.getBooleanValue(), (Object)testVal.getBooleanValue());
        Assertions.assertTrue((boolean)val.getRegistry().equals((Object)newRegistry));
        Assertions.assertTrue((boolean)val.getRegistry().equals((Object)testVal.getRegistry()));
        newRegistry = null;
    }

    @Test
    public void testProviderValue() {
        Assertions.assertEquals((Object)this.yoBoolean.getBooleanValue(), (Object)this.yoBoolean.getValue());
        this.yoBoolean.set(true);
        Assertions.assertEquals((Object)this.yoBoolean.getBooleanValue(), (Object)this.yoBoolean.getValue());
    }
}

