/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.tools.YoSearchTools;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableListTest {
    @Test
    public void testCommonUsage() {
        YoVariableList varList = new YoVariableList("listOne");
        YoRegistry registryOne = new YoRegistry("registryOne");
        YoRegistry registryTwo = new YoRegistry("registryTwo");
        YoBoolean booleanOne = new YoBoolean("booleanOne", registryOne);
        YoDouble doubleOne = new YoDouble("doubleOne", registryOne);
        varList.add((YoVariable)booleanOne);
        varList.add((YoVariable)doubleOne);
        YoBoolean booleanTwo = new YoBoolean("booleanTwo", registryTwo);
        YoDouble doubleTwo = new YoDouble("doubleTwo", registryTwo);
        varList.add((YoVariable)booleanTwo);
        varList.add((YoVariable)doubleTwo);
        YoBoolean repeatBooleanOne = new YoBoolean("booleanOne", registryTwo);
        varList.add((YoVariable)repeatBooleanOne);
        YoBoolean notIncluded = new YoBoolean("notIncluded", registryTwo);
        Assertions.assertEquals((Object)"listOne", (Object)varList.getName());
        Assertions.assertEquals((int)0, (int)varList.indexOf((Object)booleanOne));
        Assertions.assertEquals((int)1, (int)varList.indexOf((Object)doubleOne));
        Assertions.assertEquals((int)2, (int)varList.indexOf((Object)booleanTwo));
        Assertions.assertEquals((int)3, (int)varList.indexOf((Object)doubleTwo));
        Assertions.assertEquals((int)4, (int)varList.indexOf((Object)repeatBooleanOne));
        Assertions.assertEquals((int)-1, (int)varList.indexOf((Object)notIncluded));
        Assertions.assertTrue((boolean)varList.contains((Object)booleanOne));
        Assertions.assertTrue((boolean)varList.contains((Object)doubleOne));
        Assertions.assertTrue((boolean)varList.contains((Object)booleanTwo));
        Assertions.assertTrue((boolean)varList.contains((Object)doubleTwo));
        Assertions.assertTrue((boolean)varList.contains((Object)repeatBooleanOne));
        Assertions.assertFalse((boolean)varList.contains((Object)notIncluded));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> varList.get(-1));
        Assertions.assertTrue((booleanOne == varList.get(0) ? 1 : 0) != 0);
        Assertions.assertTrue((doubleOne == varList.get(1) ? 1 : 0) != 0);
        Assertions.assertTrue((booleanTwo == varList.get(2) ? 1 : 0) != 0);
        Assertions.assertTrue((doubleTwo == varList.get(3) ? 1 : 0) != 0);
        Assertions.assertTrue((repeatBooleanOne == varList.get(4) ? 1 : 0) != 0);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> varList.get(5));
        Assertions.assertTrue((boolean)varList.hasVariable("booleanOne"));
        Assertions.assertFalse((boolean)varList.hasUniqueVariable("booleanOne"));
        Assertions.assertTrue((boolean)varList.hasUniqueVariable("registryOne.booleanOne"));
        Assertions.assertTrue((boolean)varList.hasUniqueVariable("doubleOne"));
        Assertions.assertTrue((boolean)varList.hasUniqueVariable("registryOne.doubleOne"));
        Assertions.assertTrue((boolean)varList.hasUniqueVariable("booleanTwo"));
        Assertions.assertTrue((boolean)varList.hasUniqueVariable("registryTwo.booleanTwo"));
        Assertions.assertTrue((boolean)varList.hasUniqueVariable("doubleTwo"));
        Assertions.assertTrue((boolean)varList.hasUniqueVariable("registryTwo.doubleTwo"));
        Assertions.assertTrue((boolean)varList.hasUniqueVariable("registryTwo.booleanOne"));
        Assertions.assertFalse((boolean)varList.hasUniqueVariable("notIncluded"));
        Assertions.assertFalse((boolean)varList.hasUniqueVariable("registryOne.doubleTwo"));
        Assertions.assertTrue((booleanOne == varList.findVariable("booleanOne") ? 1 : 0) != 0);
        Assertions.assertTrue((doubleOne == varList.findVariable("doubleOne") ? 1 : 0) != 0);
        Assertions.assertTrue((booleanTwo == varList.findVariable("booleanTwo") ? 1 : 0) != 0);
        Assertions.assertTrue((doubleTwo == varList.findVariable("doubleTwo") ? 1 : 0) != 0);
        Assertions.assertTrue((booleanOne == varList.findVariable("registryOne.booleanOne") ? 1 : 0) != 0);
        Assertions.assertTrue((doubleOne == varList.findVariable("registryOne.doubleOne") ? 1 : 0) != 0);
        Assertions.assertTrue((booleanTwo == varList.findVariable("registryTwo.booleanTwo") ? 1 : 0) != 0);
        Assertions.assertTrue((doubleTwo == varList.findVariable("registryTwo.doubleTwo") ? 1 : 0) != 0);
        Assertions.assertTrue((repeatBooleanOne == varList.findVariable("registryTwo.booleanOne") ? 1 : 0) != 0);
        Assertions.assertTrue((null == varList.findVariable("registryOne.doubleTwo") ? 1 : 0) != 0);
        Assertions.assertTrue((null == varList.findVariable("notIncluded") ? 1 : 0) != 0);
    }

    @Test
    public void testGetPerformanceInLargeList() {
        int i;
        YoRegistry rootRegistry = new YoRegistry("rootRegistry");
        YoRegistry registryOne = new YoRegistry("registryOne");
        YoRegistry registryTwo = new YoRegistry("registryTwo");
        YoRegistry registryThree = new YoRegistry("registryThree");
        rootRegistry.addChild(registryOne);
        registryOne.addChild(registryTwo);
        registryTwo.addChild(registryThree);
        YoDouble t = new YoDouble("t", registryThree);
        YoDouble time = new YoDouble("time", registryThree);
        t.set(1.1);
        time.set(2.2);
        int numberOfVariables = 4000;
        ArrayList<YoDouble> variables = new ArrayList<YoDouble>();
        YoVariableList varList = new YoVariableList("test");
        for (i = 0; i < numberOfVariables; ++i) {
            YoDouble variableA = new YoDouble("variable" + i, registryThree);
            YoDouble variableB = new YoDouble("variable" + i, registryTwo);
            variableA.set(Math.random());
            variableB.set(Math.random());
            variables.add(variableA);
            variables.add(variableB);
            varList.add((YoVariable)variableA);
            varList.add((YoVariable)variableB);
        }
        Assertions.assertEquals((int)variables.size(), (int)varList.size());
        for (i = 0; i < variables.size(); ++i) {
            YoVariable yoVariable = (YoVariable)variables.get(i);
            Assertions.assertTrue((boolean)varList.hasUniqueVariable(yoVariable.getFullNameString()));
            Assertions.assertTrue((yoVariable == varList.findVariable(yoVariable.getFullNameString()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testToString() {
        YoRegistry registry = new YoRegistry("registry");
        YoVariableList list = new YoVariableList("list");
        YoDouble a = new YoDouble("a", registry);
        YoDouble b = new YoDouble("b", registry);
        YoDouble c = new YoDouble("c", registry);
        list.add((YoVariable)a);
        list.add((YoVariable)b);
        list.add((YoVariable)c);
        Assertions.assertEquals((Object)(list.getName() + ", variables:\n" + a.toString() + "\n" + b.toString() + "\n" + c.toString()), (Object)list.toString());
    }

    @Test
    public void testAddVariables() {
        YoRegistry registry = new YoRegistry("registry");
        YoVariableList list = new YoVariableList("list");
        YoVariableList listTwo = new YoVariableList("listTwo");
        YoVariableList listThree = new YoVariableList("listThree");
        YoVariableList listFour = new YoVariableList("listFour");
        YoDouble a = new YoDouble("a", registry);
        YoDouble b = new YoDouble("b", registry);
        YoDouble c = new YoDouble("c", registry);
        list.add((YoVariable)a);
        Assertions.assertEquals((int)1, (int)list.size());
        list.add((YoVariable)a);
        Assertions.assertEquals((int)1, (int)list.size());
        listTwo.add((YoVariable)b);
        listTwo.add((YoVariable)c);
        Assertions.assertEquals((int)2, (int)listTwo.size());
        list.addAll((Collection)listTwo);
        Assertions.assertEquals((int)3, (int)list.size());
        listThree.add((YoVariable)a);
        YoVariable[] array = new YoVariable[]{b, c};
        listThree.addAll(Arrays.asList(array));
        ArrayList<YoDouble> arrayList = new ArrayList<YoDouble>();
        arrayList.add(b);
        arrayList.add(c);
        listFour.add((YoVariable)a);
        listFour.addAll(arrayList);
        for (int i = 0; i < list.size(); ++i) {
            Assertions.assertEquals((Object)list.get(i), (Object)listThree.get(i));
            Assertions.assertEquals((Object)list.get(i), (Object)listFour.get(i));
        }
    }

    @Test
    public void testCommonUsageTwo() {
        YoRegistry registry = new YoRegistry("registry");
        YoVariableList list = new YoVariableList("list");
        YoVariableList listTwo = new YoVariableList("list");
        YoVariableList listThree = new YoVariableList("list");
        Assertions.assertTrue((boolean)list.isEmpty());
        YoDouble a = new YoDouble("a", registry);
        YoDouble b = new YoDouble("b", registry);
        YoDouble c = new YoDouble("c", registry);
        YoDouble f = new YoDouble("f", registry);
        list.add((YoVariable)a);
        list.add((YoVariable)b);
        list.add((YoVariable)c);
        list.remove((Object)b);
        list.remove((Object)f);
        listTwo.add((YoVariable)a);
        listTwo.add((YoVariable)c);
        Assertions.assertEquals((Object)list.toString(), (Object)listTwo.toString());
        Assertions.assertFalse((boolean)list.isEmpty());
        list.clear();
        Assertions.assertEquals((Object)list.toString(), (Object)listThree.toString());
        List allVariables = listTwo.getVariables();
        for (int i = 0; i < listTwo.size(); ++i) {
            Assertions.assertEquals((Object)((YoVariable)allVariables.get(i)).toString(), (Object)listTwo.get(i).toString());
        }
    }

    @Test
    public void testGetMatchingVariables() {
        YoRegistry registry = new YoRegistry("registry");
        YoVariableList list = new YoVariableList("list");
        Assertions.assertTrue((boolean)list.isEmpty());
        YoDouble a = new YoDouble("a_arm", registry);
        YoDouble b = new YoDouble("b_arm", registry);
        YoDouble c = new YoDouble("c_arm", registry);
        YoDouble f = new YoDouble("f_arm", registry);
        list.add((YoVariable)a);
        list.add((YoVariable)b);
        list.add((YoVariable)c);
        String[] names = new String[]{"a_arm", "b_arm"};
        String regularExpression = ".*";
        List matchedAll = YoSearchTools.filterVariables((Predicate)YoSearchTools.regularExpressionFilter((String[])new String[]{regularExpression}), (YoVariableHolder)list);
        Assertions.assertTrue((boolean)matchedAll.contains(a));
        Assertions.assertTrue((boolean)matchedAll.contains(b));
        Assertions.assertTrue((boolean)matchedAll.contains(c));
        Assertions.assertFalse((boolean)matchedAll.contains(f));
        String regexpStartWithC = "c.*";
        List matchedStartWithC = YoSearchTools.filterVariables((Predicate)YoSearchTools.regularExpressionFilter((String[])new String[]{regexpStartWithC}), (YoVariableHolder)list);
        Assertions.assertFalse((boolean)matchedStartWithC.contains(a));
        Assertions.assertFalse((boolean)matchedStartWithC.contains(b));
        Assertions.assertTrue((boolean)matchedStartWithC.contains(c));
        Assertions.assertFalse((boolean)matchedStartWithC.contains(f));
        List namesOrStartWithC = YoSearchTools.filterVariables((Predicate)YoSearchTools.regularExpressionFilter((String[])new String[]{regularExpression}), (YoVariableHolder)list);
        Assertions.assertTrue((boolean)namesOrStartWithC.contains(a));
        Assertions.assertTrue((boolean)namesOrStartWithC.contains(b));
        Assertions.assertTrue((boolean)namesOrStartWithC.contains(c));
        Assertions.assertFalse((boolean)namesOrStartWithC.contains(f));
        List matchedNameShouldBeEmpty = YoSearchTools.filterVariables((Predicate)YoSearchTools.regularExpressionFilter((String[])new String[]{"foo"}), (YoVariableHolder)list);
        Assertions.assertTrue((boolean)matchedNameShouldBeEmpty.isEmpty());
        matchedNameShouldBeEmpty = YoSearchTools.filterVariables((Predicate)YoSearchTools.regularExpressionFilter((String[])new String[]{"bar"}), (YoVariableHolder)list);
        Assertions.assertTrue((boolean)matchedNameShouldBeEmpty.isEmpty());
    }
}

