/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameTuple3DBasicsTest;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoMutableFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoMutableFramePoint3DTest
extends FrameTuple3DBasicsTest<YoMutableFramePoint3D> {
    public static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    public Tuple3DBasics createRandomFramelessTuple(Random random) {
        return EuclidCoreRandomTools.nextPoint3D((Random)random);
    }

    public YoMutableFramePoint3D createFrameTuple(ReferenceFrame referenceFrame, double x, double y, double z) {
        return new YoMutableFramePoint3D("", "", null, referenceFrame, x, y, z);
    }

    @Test
    public void testMutableFrameObject() {
        YoRegistry registry = new YoRegistry("TestRegistry");
        Random random = new Random(4290L);
        ArrayList<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
        frames.addAll(Arrays.asList(EuclidFrameRandomTools.nextReferenceFrameTree((Random)random)));
        frames.add(null);
        YoMutableFramePoint3D mutableFrameObject = new YoMutableFramePoint3D("", "", registry);
        YoVariable frameIndex = registry.findVariable(YoGeometryNameTools.assembleName((String[])new String[]{"", "frame", ""}));
        Assertions.assertNotNull((Object)frameIndex);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame frame = (ReferenceFrame)frames.get(random.nextInt(frames.size()));
            mutableFrameObject.setReferenceFrame(frame);
            Assertions.assertTrue((frame == mutableFrameObject.getReferenceFrame() ? 1 : 0) != 0);
            if (frame == null) {
                Assertions.assertEquals((long)-1L, (long)frameIndex.getValueAsLongBits());
                continue;
            }
            Assertions.assertEquals((long)frame.getFrameIndex(), (long)frameIndex.getValueAsLongBits());
        }
    }

    @Test
    public void testConstructors() throws Exception {
        YoMutableFramePoint3D YoMutableFramePoint3D2;
        Point3D randomTuple;
        ReferenceFrame randomFrame;
        int i;
        Random random = new Random(435345L);
        YoMutableFramePoint3D YoMutableFramePoint3D3 = new YoMutableFramePoint3D("", "", null);
        Assertions.assertTrue((YoMutableFramePoint3D3.getReferenceFrame() == worldFrame ? 1 : 0) != 0);
        EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)YoMutableFramePoint3D3);
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFramePoint3D YoMutableFramePoint3D4 = new YoMutableFramePoint3D("", "", null, randomFrame);
            Assertions.assertTrue((YoMutableFramePoint3D4.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DIsSetToZero((Tuple3DReadOnly)YoMutableFramePoint3D4);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFramePoint3D2 = new YoMutableFramePoint3D("", "", null, randomFrame, (randomTuple = EuclidCoreRandomTools.nextPoint3D((Random)random)).getX(), randomTuple.getY(), randomTuple.getZ());
            Assertions.assertTrue((YoMutableFramePoint3D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)randomTuple, (Tuple3DReadOnly)YoMutableFramePoint3D2, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidCoreRandomTools.nextPoint3D((Random)random);
            double[] array = new double[3];
            randomTuple.get(array);
            YoMutableFramePoint3D YoMutableFramePoint3D5 = new YoMutableFramePoint3D("", "", null, randomFrame, array);
            Assertions.assertTrue((YoMutableFramePoint3D5.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)randomTuple, (Tuple3DReadOnly)YoMutableFramePoint3D5, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFramePoint3D2 = new YoMutableFramePoint3D("", "", null, randomFrame, (Tuple3DReadOnly)(randomTuple = EuclidCoreRandomTools.nextPoint3D((Random)random)));
            Assertions.assertTrue((YoMutableFramePoint3D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)randomTuple, (Tuple3DReadOnly)YoMutableFramePoint3D2, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D randomTuple2D;
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            YoMutableFramePoint3D2 = new YoMutableFramePoint3D("", "", null, randomFrame, (Tuple2DReadOnly)(randomTuple2D = EuclidCoreRandomTools.nextPoint2D((Random)random)));
            Assertions.assertTrue((YoMutableFramePoint3D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)randomTuple2D, (Tuple2DReadOnly)new Point2D((Tuple3DReadOnly)YoMutableFramePoint3D2), (double)1.0E-15);
            Assertions.assertTrue((YoMutableFramePoint3D2.getZ() == 0.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            FramePoint2D randomFrameTuple2D = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)randomFrame);
            YoMutableFramePoint3D2 = new YoMutableFramePoint3D("", "", null, (FrameTuple2DReadOnly)randomFrameTuple2D);
            Assertions.assertTrue((YoMutableFramePoint3D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)randomFrameTuple2D, (Tuple2DReadOnly)new Point2D((Tuple3DReadOnly)YoMutableFramePoint3D2), (double)1.0E-15);
            Assertions.assertTrue((YoMutableFramePoint3D2.getZ() == 0.0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 1000; ++i) {
            randomFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random);
            randomTuple = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)randomFrame);
            YoMutableFramePoint3D2 = new YoMutableFramePoint3D("", "", null, (FrameTuple3DReadOnly)randomTuple);
            Assertions.assertTrue((YoMutableFramePoint3D2.getReferenceFrame() == randomFrame ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)randomTuple, (Tuple3DReadOnly)YoMutableFramePoint3D2, (double)1.0E-15);
            EuclidFrameTestTools.assertFrameTuple3DEquals((FrameTuple3DReadOnly)randomTuple, (FrameTuple3DReadOnly)YoMutableFramePoint3D2, (double)1.0E-15);
        }
    }

    @Test
    public void testSetMatchingFrame() throws Exception {
        FramePoint3D source;
        ReferenceFrame destinationFrame;
        ReferenceFrame sourceFrame;
        int i;
        Random random = new Random(544354L);
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            source = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)sourceFrame);
            YoMutableFramePoint3D actual = (YoMutableFramePoint3D)this.createEmptyFrameTuple(destinationFrame);
            actual.setMatchingFrame((FrameTuple3DReadOnly)source);
            YoMutableFramePoint3D expected = new YoMutableFramePoint3D("", "", null, (FrameTuple3DReadOnly)source);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertFrameTuple3DEquals((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual, (double)1.0E-15);
        }
        for (i = 0; i < 1000; ++i) {
            sourceFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            destinationFrame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (boolean)true);
            source = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)sourceFrame);
            double z = EuclidCoreRandomTools.nextDouble((Random)random);
            YoMutableFramePoint3D actual = (YoMutableFramePoint3D)this.createEmptyFrameTuple(destinationFrame);
            actual.setMatchingFrame((FrameTuple2DReadOnly)source, z);
            YoMutableFramePoint3D expected = new YoMutableFramePoint3D("", "", null);
            expected.setIncludingFrame((FrameTuple2DReadOnly)source, z);
            expected.changeFrame(destinationFrame);
            EuclidFrameTestTools.assertFrameTuple3DEquals((FrameTuple3DReadOnly)expected, (FrameTuple3DReadOnly)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testChangeFrame() throws Exception {
        Random random = new Random(43563L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            Point3D expectedPoint = EuclidCoreRandomTools.nextPoint3D((Random)random);
            YoMutableFramePoint3D framePoint = new YoMutableFramePoint3D("", "", null, initialFrame, (Tuple3DReadOnly)expectedPoint);
            RigidBodyTransform transform = initialFrame.getTransformToDesiredFrame(anotherFrame);
            expectedPoint.applyTransform((Transform)transform);
            framePoint.changeFrame(anotherFrame);
            Assertions.assertTrue((anotherFrame == framePoint.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedPoint, (Tuple3DReadOnly)framePoint, (double)1.0000000000000002E-14);
            ReferenceFrame differentRootFrame = ReferenceFrameTools.constructARootFrame((String)"anotherRootFrame");
            try {
                framePoint.changeFrame(differentRootFrame);
                Assertions.fail((String)"Should have thrown a RuntimeException");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSetFromReferenceFrame() throws Exception {
        Random random = new Random(6572L);
        for (int i = 0; i < 1000; ++i) {
            ReferenceFrame[] referenceFrames = EuclidFrameRandomTools.nextReferenceFrameTree((Random)random);
            ReferenceFrame initialFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            ReferenceFrame anotherFrame = referenceFrames[random.nextInt(referenceFrames.length)];
            YoMutableFramePoint3D expected = (YoMutableFramePoint3D)this.createEmptyFrameTuple(anotherFrame);
            expected.changeFrame(initialFrame);
            YoMutableFramePoint3D actual = (YoMutableFramePoint3D)this.createRandomFrameTuple(random, initialFrame);
            actual.setFromReferenceFrame(anotherFrame);
            Assertions.assertTrue((initialFrame == actual.getReferenceFrame() ? 1 : 0) != 0);
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expected, (Tuple3DReadOnly)actual, (double)1.0E-15);
        }
    }

    @Test
    public void testGeometricallyEquals() throws Exception {
        Random random = new Random(32120L);
        for (int i = 0; i < 1000; ++i) {
            YoMutableFramePoint3D framePoint1 = new YoMutableFramePoint3D("", "", null, worldFrame, (Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random));
            YoMutableFramePoint3D framePoint2 = new YoMutableFramePoint3D("", "", null, worldFrame);
            double epsilon = random.nextDouble();
            Vector3D difference = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(0.99 * epsilon));
            framePoint2.add((FrameTuple3DReadOnly)framePoint1, (Tuple3DReadOnly)difference);
            Assertions.assertTrue((boolean)framePoint1.geometricallyEquals((FramePoint3DReadOnly)framePoint2, epsilon));
            difference = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)(1.01 * epsilon));
            framePoint2.add((FrameTuple3DReadOnly)framePoint1, (Tuple3DReadOnly)difference);
            Assertions.assertFalse((boolean)framePoint1.geometricallyEquals((FramePoint3DReadOnly)framePoint2, epsilon));
        }
    }

    @Test
    public void testHashCode() throws Exception {
        Random random = new Random(763L);
        for (int i = 0; i < 1000; ++i) {
            FramePoint3D expected = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)-1.0E15, (double)1.0E15);
            YoMutableFramePoint3D actual = new YoMutableFramePoint3D("", "", null, worldFrame, (Tuple3DReadOnly)expected);
            Assertions.assertEquals((int)expected.hashCode(), (int)actual.hashCode());
        }
    }

    public void testOverloading() throws Exception {
        super.testOverloading();
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{Point3D.class}));
        signaturesToIgnore.add(new MethodSignature("epsilonEquals", new Class[]{Point3D.class, Double.TYPE}));
        signaturesToIgnore.add(new MethodSignature("geometricallyEquals", new Class[]{Point3D.class, Double.TYPE}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertOverloadingWithFrameObjects(YoMutableFramePoint3D.class, Point3D.class, true, 1, methodFilter);
    }
}

