/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Assertions;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.FrameIndexMap;

public class YoMutableFrameObjectTest {
    @Test
    public void testFrameIndexHashMap() {
        Random random = new Random(4290L);
        ArrayList<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
        frames.addAll(Arrays.asList(EuclidFrameRandomTools.nextReferenceFrameTree((Random)random)));
        frames.add(null);
        FrameIndexMap.FrameIndexHashMap mapper = new FrameIndexMap.FrameIndexHashMap();
        mapper.putAll(frames);
        frames.forEach(arg_0 -> YoMutableFrameObjectTest.lambda$testFrameIndexHashMap$0((FrameIndexMap)mapper, arg_0));
        ReferenceFrame unknown = ReferenceFrameTools.constructFrameWithUnchangingTranslationFromParent((String)"Unknown", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)new Vector3D());
        Assertions.assertExceptionThrown(RuntimeException.class, () -> YoMutableFrameObjectTest.lambda$testFrameIndexHashMap$1((FrameIndexMap)mapper, unknown));
        Assertions.assertExceptionThrown(RuntimeException.class, () -> YoMutableFrameObjectTest.lambda$testFrameIndexHashMap$2((FrameIndexMap)mapper, unknown));
    }

    @Test
    public void testFrameIndexFinder() {
        FrameIndexMap.FrameIndexFinder mapper = new FrameIndexMap.FrameIndexFinder(ReferenceFrame.getWorldFrame());
        Random random = new Random(4290L);
        ArrayList<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
        frames.addAll(Arrays.asList(EuclidFrameRandomTools.nextReferenceFrameTree((Random)random)));
        frames.add(null);
        frames.forEach(arg_0 -> YoMutableFrameObjectTest.lambda$testFrameIndexFinder$3((FrameIndexMap)mapper, arg_0));
        long frameIndex = ((ReferenceFrame)frames.get(5)).getFrameIndex();
        org.junit.jupiter.api.Assertions.assertTrue((frameIndex > 0L ? 1 : 0) != 0);
        mapper.getReferenceFrame(frameIndex);
        frames = null;
        System.gc();
        Assertions.assertExceptionThrown(RuntimeException.class, () -> YoMutableFrameObjectTest.lambda$testFrameIndexFinder$4((FrameIndexMap)mapper, frameIndex));
    }

    private static /* synthetic */ void lambda$testFrameIndexFinder$4(FrameIndexMap mapper, long frameIndex) throws Throwable {
        mapper.getReferenceFrame(frameIndex);
    }

    private static /* synthetic */ void lambda$testFrameIndexFinder$3(FrameIndexMap mapper, ReferenceFrame frame) {
        if (frame == null) {
            org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)mapper.getFrameIndex(frame));
            org.junit.jupiter.api.Assertions.assertTrue((mapper.getReferenceFrame(-1L) == frame ? 1 : 0) != 0);
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((long)frame.getFrameIndex(), (long)mapper.getFrameIndex(frame));
            org.junit.jupiter.api.Assertions.assertTrue((mapper.getReferenceFrame(frame.getFrameIndex()) == frame ? 1 : 0) != 0);
        }
    }

    private static /* synthetic */ void lambda$testFrameIndexHashMap$2(FrameIndexMap mapper, ReferenceFrame unknown) throws Throwable {
        mapper.getReferenceFrame(unknown.getFrameIndex());
    }

    private static /* synthetic */ void lambda$testFrameIndexHashMap$1(FrameIndexMap mapper, ReferenceFrame unknown) throws Throwable {
        mapper.getFrameIndex(unknown);
    }

    private static /* synthetic */ void lambda$testFrameIndexHashMap$0(FrameIndexMap mapper, ReferenceFrame frame) {
        if (frame == null) {
            org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)mapper.getFrameIndex(frame));
            org.junit.jupiter.api.Assertions.assertTrue((mapper.getReferenceFrame(-1L) == frame ? 1 : 0) != 0);
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((long)frame.getFrameIndex(), (long)mapper.getFrameIndex(frame));
            org.junit.jupiter.api.Assertions.assertTrue((mapper.getReferenceFrame(frame.getFrameIndex()) == frame ? 1 : 0) != 0);
        }
    }
}

