/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPIDefaultConfiguration;
import us.ihmc.euclid.referenceFrame.api.EuclidFrameAPITester;
import us.ihmc.euclid.referenceFrame.api.MethodSignature;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameUnitVector2D;

public class YoFrameUnitVector2DTest {
    @Test
    public void testAPIOverloading() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        ArrayList<MethodSignature> signaturesToIgnore = new ArrayList<MethodSignature>();
        signaturesToIgnore.add(new MethodSignature("set", new Class[]{UnitVector2DReadOnly.class}));
        Predicate methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        tester.assertOverloadingWithFrameObjects(YoFrameUnitVector2D.class, UnitVector2DBasics.class, false, 1, methodFilter);
    }

    @Test
    public void testReferenceFrameChecks() throws Throwable {
        ArrayList signaturesToIgnore = new ArrayList();
        Predicate<Method> methodFilter = EuclidFrameAPITester.methodFilterFromSignature(signaturesToIgnore);
        methodFilter = methodFilter.and(m -> !m.getName().equals("equals"));
        methodFilter = methodFilter.and(m -> !m.getName().equals("epsilonEquals"));
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertMethodsOfReferenceFrameHolderCheckReferenceFrame(YoFrameUnitVector2DTest::nextYoFrameUnitVector2D, methodFilter, 10);
    }

    @Test
    public void testConsistencyWithUnitVector2D() {
        Predicate<Method> methodFilter = m -> !m.getName().equals("hashCode") && !m.getName().equals("epsilonEquals") && !m.getName().contains("IntermediateVariableSupplier");
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertFrameMethodsOfFrameHolderPreserveFunctionality((referenceFrame, unitVector2D) -> YoFrameUnitVector2DTest.newYoFrameUnitVector2D(referenceFrame, (UnitVector2DReadOnly)unitVector2D), EuclidCoreRandomTools::nextUnitVector2D, methodFilter, 10);
    }

    @Test
    public void testSetMatchingFrame() {
        EuclidFrameAPITester tester = new EuclidFrameAPITester(new EuclidFrameAPIDefaultConfiguration());
        tester.assertSetMatchingFramePreserveFunctionality(YoFrameUnitVector2DTest::nextYoFrameUnitVector2D, 10);
    }

    private static YoFrameUnitVector2D nextYoFrameUnitVector2D(Random random, ReferenceFrame referenceFrame) {
        YoFrameUnitVector2D next = new YoFrameUnitVector2D("", referenceFrame, null);
        next.set((UnitVector2DReadOnly)EuclidCoreRandomTools.nextUnitVector2D((Random)random));
        return next;
    }

    private static YoFrameUnitVector2D newYoFrameUnitVector2D(ReferenceFrame referenceFrame, UnitVector2DReadOnly unitVector2D) {
        YoFrameUnitVector2D next = new YoFrameUnitVector2D("", referenceFrame, null);
        next.set(unitVector2D);
        return next;
    }
}

