/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoFrameConvexPolygon2DTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testBugIssue6() {
        YoFrameConvexPolygon2D polygon = new YoFrameConvexPolygon2D("Test", ReferenceFrame.getWorldFrame(), 20, new YoRegistry("test"));
        Point2D point1 = new Point2D(0.111, 0.222);
        Point2D point2 = new Point2D(0.222, 0.333);
        polygon.addVertex((Point2DReadOnly)point1);
        polygon.addVertex((Point2DReadOnly)point2);
        polygon.update();
        Assertions.assertEquals((int)2, (int)polygon.getNumberOfVertices());
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)point1, (Point2DReadOnly)polygon.getVertex(0), (double)1.0E-8);
        polygon.removeVertex(0);
        polygon.update();
        Assertions.assertEquals((int)1, (int)polygon.getNumberOfVertices());
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)point2, (Point2DReadOnly)polygon.getVertex(0), (double)1.0E-8);
    }

    @Test
    public void testRemoveVertex() {
        Random random = new Random(6325L);
        for (int i = 0; i < 1000; ++i) {
            FrameConvexPolygon2D referencePolygon = EuclidFrameRandomTools.nextFrameConvexPolygon2D((Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame(), (double)1.0, (int)60);
            YoFrameConvexPolygon2D testedPolygon = new YoFrameConvexPolygon2D("Test", ReferenceFrame.getWorldFrame(), 20, new YoRegistry("test"));
            testedPolygon.set((FrameVertex2DSupplier)referencePolygon);
            int numberOfVerticesToRemove = random.nextInt(referencePolygon.getNumberOfVertices());
            for (int j = 0; j < numberOfVerticesToRemove; ++j) {
                int indexToRemove = random.nextInt(referencePolygon.getNumberOfVertices());
                referencePolygon.removeVertex(indexToRemove);
                testedPolygon.removeVertex(indexToRemove);
            }
            referencePolygon.update();
            testedPolygon.update();
            Assertions.assertEquals((int)referencePolygon.getNumberOfVertices(), (int)testedPolygon.getNumberOfVertices());
            EuclidFrameTestTools.assertFrameConvexPolygon2DEquals((FrameConvexPolygon2DReadOnly)referencePolygon, (FrameConvexPolygon2DReadOnly)testedPolygon, (double)0.0);
        }
    }
}

