/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.buffer;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.buffer.KeyPointsHandler;

public class KeyPointsHandlerTest {
    private KeyPointsHandler keyPoints;

    @BeforeEach
    public void setup() {
        this.keyPoints = new KeyPointsHandler();
    }

    @AfterEach
    public void tearDown() {
        this.keyPoints = null;
    }

    @Test
    public void testSetKeyPoint() {
        Assertions.assertTrue((this.keyPoints.getKeyPoints().size() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.keyPoints.toggleKeyPoint(0));
        Assertions.assertTrue((this.keyPoints.getKeyPoints().size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.keyPoints.toggleKeyPoint(4));
        Assertions.assertTrue((this.keyPoints.getKeyPoints().size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.keyPoints.toggleKeyPoint(3));
        Assertions.assertTrue((this.keyPoints.getKeyPoints().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveDuplicateKeyPoint() {
        Assertions.assertTrue((this.keyPoints.getKeyPoints().size() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.keyPoints.toggleKeyPoint(3));
        Assertions.assertTrue((this.keyPoints.getKeyPoints().size() == 1 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)this.keyPoints.toggleKeyPoint(3));
        Assertions.assertTrue((this.keyPoints.getKeyPoints().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetNextTime() {
        int[] keyPointTimes = new int[]{3, 16, 20, 48, 75};
        int nextTimeNotAdded = this.keyPoints.getNextKeyPoint(88);
        Assertions.assertTrue((nextTimeNotAdded == 88 ? 1 : 0) != 0);
        this.clearAndFillKeyPoints(keyPointTimes);
        int nextTimeInRange = this.keyPoints.getNextKeyPoint(17);
        Assertions.assertTrue((nextTimeInRange == 20 ? 1 : 0) != 0);
        int nextTimeOutOfRange = this.keyPoints.getNextKeyPoint(99);
        Assertions.assertTrue((nextTimeOutOfRange == 3 ? 1 : 0) != 0);
    }

    @Test
    public void getPreviousTime() {
        int[] keyPointTimes = new int[]{3, 16, 20, 48, 75};
        int previousTimeNotAdded = this.keyPoints.getPreviousKeyPoint(1);
        Assertions.assertTrue((previousTimeNotAdded == 1 ? 1 : 0) != 0);
        this.clearAndFillKeyPoints(keyPointTimes);
        int previousTimeInRange = this.keyPoints.getPreviousKeyPoint(47);
        Assertions.assertTrue((previousTimeInRange == 20 ? 1 : 0) != 0);
        int previousTimeOutOfRange = this.keyPoints.getPreviousKeyPoint(1);
        Assertions.assertTrue((previousTimeOutOfRange == 75 ? 1 : 0) != 0);
    }

    @Test
    public void testTrim() {
        int[] keyPointTimes = new int[]{3, 16, 20, 48, 75};
        this.clearAndFillKeyPoints(keyPointTimes);
        Assertions.assertTrue((this.keyPoints.getKeyPoints().size() == keyPointTimes.length ? 1 : 0) != 0);
        this.keyPoints.trimKeyPoints(17, 47);
        Assertions.assertTrue((this.keyPoints.getKeyPoints().size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((this.keyPoints.getNextKeyPoint(1) == 20 ? 1 : 0) != 0);
        this.clearAndFillKeyPoints(keyPointTimes);
        this.keyPoints.trimKeyPoints(47, 17);
        Assertions.assertTrue((this.keyPoints.getKeyPoints().size() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue(((Integer)this.keyPoints.getKeyPoints().get(0) == 3 ? 1 : 0) != 0);
        Assertions.assertTrue(((Integer)this.keyPoints.getKeyPoints().get(1) == 16 ? 1 : 0) != 0);
        Assertions.assertTrue(((Integer)this.keyPoints.getKeyPoints().get(2) == 48 ? 1 : 0) != 0);
        Assertions.assertTrue(((Integer)this.keyPoints.getKeyPoints().get(3) == 75 ? 1 : 0) != 0);
    }

    @Test
    public void testUseKeyPoints() {
        Assertions.assertFalse((boolean)this.keyPoints.areKeyPointsEnabled());
        this.keyPoints.enableKeyPoints(true);
        Assertions.assertTrue((boolean)this.keyPoints.areKeyPointsEnabled());
        this.keyPoints.enableKeyPoints(false);
        Assertions.assertFalse((boolean)this.keyPoints.areKeyPointsEnabled());
    }

    private void clearAndFillKeyPoints(int[] keyPointTimes) {
        this.keyPoints.getKeyPoints().clear();
        for (int keyPointTime : keyPointTimes) {
            this.keyPoints.toggleKeyPoint(keyPointTime);
        }
    }
}

