/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.registry;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.tools.YoTools;

public class YoNamespaceTest {
    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testConstructors() {
        new YoNamespace("robot1.controller1.module1");
        try {
            new YoNamespace("");
            Assertions.fail((String)"Shouldn't be able to create a namespace with no name");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            new YoNamespace("foo.bar.");
            Assertions.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            new YoNamespace(".foo.bar");
            Assertions.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            new YoNamespace("foo.foo").checkSanity();
            Assertions.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            new YoNamespace("foo.bar.foo").checkSanity();
            Assertions.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            new YoNamespace("foo..bar");
            Assertions.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testEquals() {
        YoNamespace namespace1 = new YoNamespace("robot1.controller1.module1");
        YoNamespace namespace2 = new YoNamespace("robot1.controller1.module1");
        YoNamespace namespace3 = new YoNamespace("robot1.module1");
        YoNamespace namespace4 = new YoNamespace("robot1.controller1.mod");
        YoNamespace namespace5 = new YoNamespace("bot1.controller1.module1");
        Assertions.assertTrue((boolean)namespace1.equals((Object)namespace1));
        Assertions.assertTrue((boolean)namespace2.equals((Object)namespace2));
        Assertions.assertTrue((boolean)namespace3.equals((Object)namespace3));
        Assertions.assertTrue((boolean)namespace4.equals((Object)namespace4));
        Assertions.assertTrue((boolean)namespace5.equals((Object)namespace5));
        Assertions.assertTrue((boolean)namespace1.equals((Object)namespace2));
        Assertions.assertTrue((boolean)namespace2.equals((Object)namespace1));
        Assertions.assertTrue((!namespace1.equals((Object)namespace3) ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace1.equals((Object)namespace4) ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace1.equals((Object)namespace5) ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace3.equals((Object)namespace1) ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace4.equals((Object)namespace1) ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace5.equals((Object)namespace1) ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace1.equals((Object)"A string") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace1.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testStartsWith() {
        YoNamespace namespace = new YoNamespace("robot1.controller1.module1");
        Assertions.assertTrue((boolean)namespace.startsWith("robot1"));
        Assertions.assertTrue((boolean)namespace.startsWith("robot1.controller1"));
        Assertions.assertTrue((boolean)namespace.startsWith("robot1.controller1.module1"));
        Assertions.assertTrue((!namespace.startsWith("robot1.controller1.mod") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.startsWith("robot1.controll") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.startsWith("rob") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.startsWith(".robot1") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.startsWith("robot1.") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.startsWith("") ? 1 : 0) != 0);
    }

    @Test
    public void testEndsWith() {
        YoNamespace namespace = new YoNamespace("robot1.controller1.module1");
        Assertions.assertTrue((boolean)namespace.endsWith("module1"));
        Assertions.assertTrue((boolean)namespace.endsWith("controller1.module1"));
        Assertions.assertTrue((boolean)namespace.endsWith("robot1.controller1.module1"));
        Assertions.assertTrue((!namespace.endsWith("odule1") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.endsWith("ontroller1.module1") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.endsWith("obot1.controller1.module1") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.endsWith("module1.") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.endsWith(".module1") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.endsWith("") ? 1 : 0) != 0);
    }

    @Test
    public void testGetShortName() {
        YoNamespace namespace = new YoNamespace("robot1.controller1.module1");
        Assertions.assertTrue((boolean)namespace.getShortName().equals("module1"));
        Assertions.assertTrue((boolean)namespace.getName().equals("robot1.controller1.module1"));
        namespace = new YoNamespace("module2");
        Assertions.assertTrue((boolean)namespace.getName().equals("module2"));
        Assertions.assertTrue((boolean)namespace.getShortName().equals("module2"));
    }

    @Test
    public void testContains() {
        YoNamespace namespace = new YoNamespace("robot1.controller1.module1");
        Assertions.assertTrue((boolean)namespace.contains("robot1"));
        Assertions.assertFalse((boolean)namespace.contains("notMe"));
        Assertions.assertFalse((boolean)namespace.contains("notMe.nope.noway.nada.unhunh"));
        Assertions.assertTrue((boolean)namespace.contains("robot1.controller1"));
        Assertions.assertTrue((boolean)namespace.contains("robot1.controller1.module1"));
        Assertions.assertFalse((boolean)namespace.contains("robot1.notMe"));
        Assertions.assertTrue((!namespace.contains("robot1.controller1.mod") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.contains("robot1.controll") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.contains("rob") ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)namespace.contains("module1"));
        Assertions.assertTrue((boolean)namespace.contains("controller1.module1"));
        Assertions.assertTrue((boolean)namespace.contains("robot1.controller1.module1"));
        Assertions.assertTrue((!namespace.contains("odule1") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.contains("ontroller1.module1") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.contains("obot1.controller1.module1") ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)namespace.contains("controller1"));
        Assertions.assertTrue((!namespace.contains("controller1.mod") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.contains("bot1.controller1") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.contains(".controller1") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.contains("controller1.") ? 1 : 0) != 0);
        Assertions.assertTrue((!namespace.contains("") ? 1 : 0) != 0);
    }

    @Test
    public void testStripOffFromBeginning() {
        YoNamespace namespace = new YoNamespace("root.name1.name2");
        YoNamespace namespaceToRemove = new YoNamespace("root");
        YoNamespace newNamespace = namespace.removeStart(namespaceToRemove);
        Assertions.assertEquals((Object)new YoNamespace("name1.name2"), (Object)newNamespace);
        namespaceToRemove = new YoNamespace("root.name1");
        newNamespace = namespace.removeStart(namespaceToRemove);
        Assertions.assertEquals((Object)new YoNamespace("name2"), (Object)newNamespace);
        namespaceToRemove = new YoNamespace("root.name1.name2");
        newNamespace = namespace.removeStart(namespaceToRemove);
        Assertions.assertEquals(null, (Object)newNamespace);
        namespaceToRemove = new YoNamespace("name1");
        newNamespace = namespace.removeStart(namespaceToRemove);
        Assertions.assertEquals(null, (Object)newNamespace);
    }

    @Test
    public void testStripOffNamespaceToGetVariableName() {
        Assertions.assertEquals((Object)"variable", (Object)YoTools.toShortName((String)"root.level1.level2.variable"));
        Assertions.assertEquals((Object)"variable", (Object)YoTools.toShortName((String)"root.variable"));
        Assertions.assertEquals((Object)"variable", (Object)YoTools.toShortName((String)"variable"));
    }
}

