/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.parameters.AbstractParameterReader;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.parameters.ParameterData;
import us.ihmc.yoVariables.registry.YoRegistry;

public class AbstractParameterReaderTest {
    private static final Random random = new Random(9492L);

    @Test
    public void testReadingNamespacesRegistry() {
        for (int i = 0; i < 4; ++i) {
            YoRegistry[] regs = new YoRegistry[]{new YoRegistry("root"), new YoRegistry("a"), new YoRegistry("b"), new YoRegistry("c")};
            String[] expectedNamespaces = new String[]{"root.a.b.c", "a.b.c", "b.c", "c"};
            regs[0].addChild(regs[1]);
            regs[1].addChild(regs[2]);
            regs[2].addChild(regs[3]);
            DoubleParameter parameter = new DoubleParameter("parameter", regs[3], random.nextDouble());
            int numberOfDefaults = random.nextInt(10);
            for (int defaultIdx = 0; defaultIdx < numberOfDefaults; ++defaultIdx) {
                new DoubleParameter("Default" + defaultIdx, regs[3], 0.0);
            }
            HashMap<String, ParameterData> values = new HashMap<String, ParameterData>();
            double expectedValue = random.nextDouble();
            values.put(expectedNamespaces[i] + "." + parameter.getName(), new ParameterData(Double.toString(expectedValue)));
            int numberOfUnmatched = random.nextInt(10);
            for (int unmatchedIdx = 0; unmatchedIdx < numberOfUnmatched; ++unmatchedIdx) {
                values.put("Unmatched" + unmatchedIdx, new ParameterData(Double.toString(0.0)));
            }
            TestParameterReader readerRoot = new TestParameterReader(values);
            HashSet defaultParameters = new HashSet();
            HashSet unmatchedParameters = new HashSet();
            readerRoot.readParametersInRegistry(regs[i], defaultParameters, unmatchedParameters);
            Assertions.assertEquals((int)numberOfDefaults, (int)defaultParameters.size());
            Assertions.assertEquals((int)numberOfUnmatched, (int)unmatchedParameters.size());
            Assertions.assertEquals((double)expectedValue, (double)parameter.getValue(), (double)Double.MIN_VALUE);
        }
    }

    @Test
    public void testDoubleRead() {
        YoRegistry root = new YoRegistry("root");
        YoRegistry a = new YoRegistry("a");
        root.addChild(a);
        DoubleParameter parameter = new DoubleParameter("param", a, random.nextDouble());
        double loadedValue = random.nextDouble();
        HashMap<String, ParameterData> values = new HashMap<String, ParameterData>();
        values.put("root.a.param", new ParameterData(Double.toString(loadedValue)));
        TestParameterReader reader = new TestParameterReader(values);
        reader.readParametersInRegistry(new YoRegistry("RandomRegistry"));
        reader.readParametersInRegistry(root);
        Assertions.assertEquals((double)loadedValue, (double)parameter.getValue(), (double)Double.MIN_VALUE);
    }

    private static class TestParameterReader
    extends AbstractParameterReader {
        private final Map<String, ParameterData> values;

        private TestParameterReader(Map<String, ParameterData> values) {
            this.values = values;
        }

        protected Map<String, ParameterData> getValues() {
            return Collections.unmodifiableMap(this.values);
        }
    }
}

