/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.yoVariables.filters.SimpleMovingAverageFilteredYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimpleMovingAverageFilteredYoVariableTest {
    @Test
    public void testWithFixedSizeDoubleArrays() {
        for (int i = 0; i < 100; ++i) {
            YoRegistry registry = new YoRegistry("Blop");
            Random random = new Random(6541654L);
            int windowSize = RandomNumbers.nextInt((Random)random, (int)1, (int)1000);
            SimpleMovingAverageFilteredYoVariable sma = new SimpleMovingAverageFilteredYoVariable("tested", windowSize, registry);
            double amplitude = 100.0;
            double[] randomArray = RandomNumbers.nextDoubleArray((Random)random, (int)windowSize, (double)amplitude);
            double expected = 0.0;
            for (double val : randomArray) {
                expected += val / (double)windowSize;
            }
            for (int j = 0; j < randomArray.length; ++j) {
                Assertions.assertFalse((boolean)sma.getHasBufferWindowFilled());
                sma.update(randomArray[j]);
            }
            Assertions.assertTrue((boolean)sma.getHasBufferWindowFilled());
            Assertions.assertEquals((double)expected, (double)sma.getDoubleValue(), (double)1.0E-10);
        }
    }

    @Test
    public void testBetaFilteredYoVariable() {
        int beta = 5000;
        double pseudoNoise = 0.0;
        Random random = new Random(1738L);
        YoRegistry registry = new YoRegistry("testRegistry");
        YoDouble positionVariable = new YoDouble("positionVariable", registry);
        SimpleMovingAverageFilteredYoVariable betaFilteredYoVariable = new SimpleMovingAverageFilteredYoVariable("betaFilteredYoVariable", beta, positionVariable, registry);
        positionVariable.set(10.0);
        for (int i = 0; i < 10000; ++i) {
            if (i % 2 == 0) {
                pseudoNoise = random.nextDouble();
            }
            positionVariable.add(Math.pow(-1.0, i) * pseudoNoise);
            betaFilteredYoVariable.update();
        }
        Assertions.assertEquals((double)10.0, (double)betaFilteredYoVariable.getDoubleValue(), (double)1.0);
    }

    @Test
    public void testTrueMovingAverage() {
        int beta = 10;
        YoRegistry registry = new YoRegistry("testRegistry");
        SimpleMovingAverageFilteredYoVariable betaFilteredYoVariable = new SimpleMovingAverageFilteredYoVariable("betaFilteredYoVariable", beta, registry);
        double epsilon = 1.0E-10;
        betaFilteredYoVariable.update(1.0);
        Assertions.assertEquals((double)1.0, (double)betaFilteredYoVariable.getDoubleValue(), (double)epsilon);
        betaFilteredYoVariable.update(2.0);
        Assertions.assertEquals((double)1.5, (double)betaFilteredYoVariable.getDoubleValue(), (double)epsilon);
        betaFilteredYoVariable.update(3.0);
        betaFilteredYoVariable.update(4.0);
        betaFilteredYoVariable.update(5.0);
        betaFilteredYoVariable.update(6.0);
        betaFilteredYoVariable.update(7.0);
        betaFilteredYoVariable.update(8.0);
        betaFilteredYoVariable.update(9.0);
        betaFilteredYoVariable.update(10.0);
        Assertions.assertEquals((double)5.5, (double)betaFilteredYoVariable.getDoubleValue(), (double)epsilon);
    }
}

