/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.filters.SecondOrderFilteredYoDouble;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SecondOrderFilteredYoDoubleTest {
    YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());

    @Test
    public void testLowPassFilterCoefficients() {
        double dt = 0.001;
        double dampingRatio = 1.0;
        double naturalFrequencyInHz = 10.0;
        double[] bAssert = new double[]{3947.8417604357433, 7895.6835208714865, 3947.8417604357433};
        double[] aAssert = new double[]{4255275.254047619, -7992104.316479129, 3752620.429473252};
        SecondOrderFilteredYoDouble filteredYoVariable = new SecondOrderFilteredYoDouble("lowPass", this.registry, dt, naturalFrequencyInHz, dampingRatio, SecondOrderFilteredYoDouble.SecondOrderFilterType.LOW_PASS);
        double[] b = new double[3];
        double[] a = new double[3];
        filteredYoVariable.getFilterCoefficients(b, a);
        Assertions.assertArrayEquals((double[])b, (double[])bAssert, (double)1.0E-8);
        Assertions.assertArrayEquals((double[])a, (double[])aAssert, (double)1.0E-8);
    }

    @Test
    public void testNotchFilterCoefficients() {
        double dt = 0.001;
        double dampingRatio = 1.0;
        double naturalFrequencyInHz = 10.0;
        double[] bAssert = new double[]{4003947.8417604356, -7992104.316479129, 4003947.8417604356};
        double[] aAssert = new double[]{4255275.254047619, -7992104.316479129, 3752620.429473252};
        SecondOrderFilteredYoDouble filteredYoVariable = new SecondOrderFilteredYoDouble("notch", this.registry, dt, naturalFrequencyInHz, dampingRatio, SecondOrderFilteredYoDouble.SecondOrderFilterType.NOTCH);
        double[] b = new double[3];
        double[] a = new double[3];
        filteredYoVariable.getFilterCoefficients(b, a);
        Assertions.assertArrayEquals((double[])b, (double[])bAssert, (double)1.0E-8);
        Assertions.assertArrayEquals((double[])a, (double[])aAssert, (double)1.0E-8);
    }

    @Test
    public void testHighPassFilterCoefficients() {
        double dt = 0.001;
        double dampingRatio = 1.0;
        double naturalFrequencyInHz = 10.0;
        double[] bAssert = new double[]{4000000.0, -8000000.0, 4000000.0};
        double[] aAssert = new double[]{4255275.254047619, -7992104.316479129, 3752620.429473252};
        SecondOrderFilteredYoDouble filteredYoVariable = new SecondOrderFilteredYoDouble("highPass", this.registry, dt, naturalFrequencyInHz, dampingRatio, SecondOrderFilteredYoDouble.SecondOrderFilterType.HIGH_PASS);
        double[] b = new double[3];
        double[] a = new double[3];
        filteredYoVariable.getFilterCoefficients(b, a);
        Assertions.assertArrayEquals((double[])b, (double[])bAssert, (double)1.0E-8);
        Assertions.assertArrayEquals((double[])a, (double[])aAssert, (double)1.0E-8);
    }
}

