/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.filters.RateLimitedYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class RateLimitedYoVariableTest {
    YoRegistry registry = new YoRegistry("registry");
    RateLimitedYoVariable rateLimitedYoVariable1;
    RateLimitedYoVariable rateLimitedYoVariable2;
    RateLimitedYoVariable rateLimitedYoVariable3;
    RateLimitedYoVariable rateLimitedYoVariable4;
    YoDouble maxRate2;
    YoDouble maxRate4;
    YoDouble position3;
    YoDouble position4;
    double maxRate1;
    double maxRate3;
    double dt1;
    double dt2;
    double dt3;
    double dt4;

    @BeforeEach
    public void setUp() {
        this.maxRate2 = new YoDouble("maxRate2", this.registry);
        this.maxRate4 = new YoDouble("maxRate4", this.registry);
        this.position3 = new YoDouble("position3", this.registry);
        this.position4 = new YoDouble("position4", this.registry);
        this.maxRate1 = 10.0;
        this.maxRate2.set(9.0);
        this.maxRate3 = 11.0;
        this.maxRate4.set(12.0);
        this.dt1 = 1.0;
        this.dt2 = 1.0;
        this.dt3 = 1.0;
        this.dt4 = 1.0;
        this.position3.set(0.5);
        this.position4.set(0.75);
        this.rateLimitedYoVariable1 = new RateLimitedYoVariable("rateLimitedYoVariable1", this.registry, this.maxRate1, this.dt1);
        this.rateLimitedYoVariable2 = new RateLimitedYoVariable("rateLimitedYoVariable2", this.registry, (DoubleProvider)this.maxRate2, this.dt2);
        this.rateLimitedYoVariable3 = new RateLimitedYoVariable("rateLimitedYoVariable3", this.registry, this.maxRate3, (DoubleProvider)this.position3, this.dt3);
        this.rateLimitedYoVariable4 = new RateLimitedYoVariable("rateLimitedYoVariable4", this.registry, (DoubleProvider)this.maxRate4, (DoubleProvider)this.position4, this.dt4);
    }

    @Test
    public void testUpdate() {
        try {
            this.rateLimitedYoVariable3.update();
            this.rateLimitedYoVariable4.update();
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }

    @Test
    public void testUpdateWithNullPointerException() {
        try {
            this.rateLimitedYoVariable1.update();
            this.rateLimitedYoVariable2.update();
            Assertions.fail((String)"Did not throw NullPointerException.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateWithCurrentPositionParameter() {
        double angle;
        for (angle = 0.0; angle < 18.84; angle += 1.0) {
            double currentPosition1 = 10.0 * Math.sin(angle);
            this.rateLimitedYoVariable1.update(currentPosition1);
            Assertions.assertEquals((double)this.rateLimitedYoVariable1.getDoubleValue(), (double)currentPosition1, (double)1.0E-13);
        }
        for (angle = 0.0; angle < 18.84; angle += 1.0) {
            double currentPosition2 = 7.0 * Math.sin(angle);
            this.rateLimitedYoVariable2.update(currentPosition2);
            Assertions.assertEquals((double)this.rateLimitedYoVariable2.getDoubleValue(), (double)currentPosition2, (double)1.0E-13);
        }
        for (angle = 0.0; angle < 18.84; angle += 1.0) {
            double currentPosition3 = 11.0 * Math.sin(angle);
            this.rateLimitedYoVariable3.update(currentPosition3);
            Assertions.assertEquals((double)this.rateLimitedYoVariable3.getDoubleValue(), (double)currentPosition3, (double)1.0E-13);
        }
        for (angle = 0.0; angle < 18.84; angle += 1.0) {
            double currentPosition4 = 12.0 * Math.sin(angle);
            this.rateLimitedYoVariable4.update(currentPosition4);
            Assertions.assertEquals((double)this.rateLimitedYoVariable4.getDoubleValue(), (double)currentPosition4, (double)1.0E-13);
        }
    }

    @Test
    public void testUpdateWithCurrentPositionParameterExceedingMaxRate() {
        double signOfSlope;
        double dSinTheta;
        double angle;
        for (angle = 0.0; angle < 18.84; angle += 1.0) {
            double currentPosition1 = 25.0 * Math.sin(angle);
            dSinTheta = Math.cos(angle);
            signOfSlope = Math.signum(dSinTheta) * 1.0;
            if (Math.abs(currentPosition1 - this.rateLimitedYoVariable1.getDoubleValue()) > this.maxRate1) {
                currentPosition1 = this.rateLimitedYoVariable1.getDoubleValue() + signOfSlope * this.maxRate1;
            }
            this.rateLimitedYoVariable1.update(currentPosition1);
            Assertions.assertEquals((double)this.rateLimitedYoVariable1.getDoubleValue(), (double)currentPosition1, (double)1.0E-15);
        }
        for (angle = 0.0; angle < 18.84; angle += 1.0) {
            double currentPosition2 = 25.0 * Math.sin(angle);
            dSinTheta = Math.cos(angle);
            signOfSlope = Math.signum(dSinTheta) * 1.0;
            if (Math.abs(currentPosition2 - this.rateLimitedYoVariable2.getDoubleValue()) > this.maxRate2.getDoubleValue()) {
                currentPosition2 = this.rateLimitedYoVariable2.getDoubleValue() + signOfSlope * this.maxRate2.getDoubleValue();
            }
            this.rateLimitedYoVariable2.update(currentPosition2);
            Assertions.assertEquals((double)this.rateLimitedYoVariable2.getDoubleValue(), (double)currentPosition2, (double)1.0E-15);
        }
        for (angle = 0.0; angle < 18.84; angle += 1.0) {
            double currentPosition3 = 25.0 * Math.sin(angle);
            dSinTheta = Math.cos(angle);
            signOfSlope = Math.signum(dSinTheta) * 1.0;
            if (Math.abs(currentPosition3 - this.rateLimitedYoVariable3.getDoubleValue()) > this.maxRate3) {
                currentPosition3 = this.rateLimitedYoVariable3.getDoubleValue() + signOfSlope * this.maxRate3;
            }
            this.rateLimitedYoVariable3.update(currentPosition3);
            Assertions.assertEquals((double)this.rateLimitedYoVariable3.getDoubleValue(), (double)currentPosition3, (double)1.0E-15);
        }
        for (angle = 0.0; angle < 18.84; angle += 1.0) {
            double currentPosition4 = 25.0 * Math.sin(angle);
            dSinTheta = Math.cos(angle);
            signOfSlope = Math.signum(dSinTheta) * 1.0;
            if (Math.abs(currentPosition4 - this.rateLimitedYoVariable4.getDoubleValue()) > this.maxRate4.getDoubleValue()) {
                currentPosition4 = this.rateLimitedYoVariable4.getDoubleValue() + signOfSlope * this.maxRate4.getDoubleValue();
            }
            this.rateLimitedYoVariable4.update(currentPosition4);
            Assertions.assertEquals((double)this.rateLimitedYoVariable4.getDoubleValue(), (double)currentPosition4, (double)1.0E-15);
        }
    }

    @Test
    public void testUpdateWithMaxRateBeingNegative() {
        try {
            RateLimitedYoVariable rateLimitedYoVariableWithNegativeMaxRate = new RateLimitedYoVariable("rateLimitedYoVariableWithNegativeMaxRate", this.registry, -5.0, 1.0);
            rateLimitedYoVariableWithNegativeMaxRate.update(5.0);
        }
        catch (RuntimeException e) {
            Assertions.assertEquals((Object)e.getMessage(), (Object)"The maxRate parameter in the RateLimitedYoVariable cannot be negative.");
        }
    }
}

