/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.filters.GlitchFilteredYoBoolean;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class GlitchFilteredYoBooleanTest {
    public static final int WINDOW_SIZE = 10;
    private YoRegistry registry;
    private YoBoolean yoVariableToFilter;
    private GlitchFilteredYoBoolean filteredVariable;

    @BeforeEach
    public void setUp() {
        this.registry = new YoRegistry("testRegistry");
        this.yoVariableToFilter = new YoBoolean("variableToFilter", this.registry);
        this.filteredVariable = new GlitchFilteredYoBoolean("filteredVariable", this.registry, this.yoVariableToFilter, 10);
    }

    @AfterEach
    public void tearDown() {
        this.registry = null;
        this.yoVariableToFilter = null;
        this.filteredVariable = null;
    }

    @Test
    public void testConstructors_Set_Get() {
        GlitchFilteredYoBoolean number1 = new GlitchFilteredYoBoolean("stringInt", new YoRegistry("test"), 10);
        GlitchFilteredYoBoolean number2 = new GlitchFilteredYoBoolean("stringYoVariableRegistryInt", this.registry, 10);
        GlitchFilteredYoBoolean number3 = new GlitchFilteredYoBoolean("stringBooleanYoVariableInt", new YoRegistry("test"), this.yoVariableToFilter, 10);
        GlitchFilteredYoBoolean number4 = new GlitchFilteredYoBoolean("stringYoVariableRegistryBooleanYoVariableInt", this.registry, this.yoVariableToFilter, 10);
        GlitchFilteredYoBoolean[] array = new GlitchFilteredYoBoolean[]{number1, number2, number3, number4};
        for (int i = 0; i < array.length; ++i) {
            Assertions.assertFalse((boolean)array[i].getBooleanValue());
            array[i].set(true);
            Assertions.assertTrue((boolean)array[i].getBooleanValue());
            array[i].set(false);
            Assertions.assertFalse((boolean)array[i].getBooleanValue());
        }
    }

    @Test
    public void testUpdate() {
        int windowSize = 3;
        this.filteredVariable.set(true);
        this.filteredVariable.setWindowSize(windowSize);
        int numberOfSets = windowSize * 20;
        int counter = 0;
        for (int i = 0; i < windowSize + 10; ++i) {
            this.filteredVariable.update(false);
            if (++counter < windowSize) {
                Assertions.assertTrue((boolean)this.filteredVariable.getBooleanValue());
                continue;
            }
            Assertions.assertFalse((boolean)this.filteredVariable.getBooleanValue());
        }
        this.filteredVariable = null;
        try {
            this.filteredVariable.update();
            Assertions.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testCounter() {
        int windowSize = 10;
        this.filteredVariable.set(true);
        this.filteredVariable.setWindowSize(windowSize);
        for (int i = 0; i < (int)((double)windowSize / 2.0); ++i) {
            this.filteredVariable.update(this.filteredVariable.getBooleanValue());
            Assertions.assertEquals((int)this.filteredVariable.counter.getIntegerValue(), (int)0);
        }
    }

    @Test
    public void testFiltering() {
        int i;
        this.yoVariableToFilter.set(true);
        for (i = 0; i < 5; ++i) {
            this.filteredVariable.update();
        }
        Assertions.assertFalse((this.yoVariableToFilter.getBooleanValue() == this.filteredVariable.getBooleanValue() ? 1 : 0) != 0);
        for (i = 0; i < 5; ++i) {
            this.filteredVariable.update();
        }
        Assertions.assertTrue((this.yoVariableToFilter.getBooleanValue() == this.filteredVariable.getBooleanValue() ? 1 : 0) != 0);
    }
}

