/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.filters.FirstOrderBandPassFilteredYoDouble;
import us.ihmc.yoVariables.filters.FirstOrderFilteredYoDouble;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class FirstOrderFilteredYoDoubleTest {
    private final YoRegistry registry = new YoRegistry("testRegistry");
    private final YoDouble yoTime = new YoDouble("yoTime", this.registry);
    private final double DT = 0.001;

    @Test
    public void testHighPassAttenuationForSinusoidalInput() {
        double cutoffFrequencyRadPerSec;
        double inputFrequencyRadPerSec = 15.0;
        double filterAttenuation = 1.0;
        FirstOrderFilteredYoDouble highPassFilteredYoVariable = new FirstOrderFilteredYoDouble("highPass", "", cutoffFrequencyRadPerSec / (Math.PI * 2), (DoubleProvider)this.yoTime, FirstOrderFilteredYoDouble.FirstOrderFilterType.HIGH_PASS, this.registry);
        for (cutoffFrequencyRadPerSec = inputFrequencyRadPerSec / 5.0; filterAttenuation > 0.1 && cutoffFrequencyRadPerSec > 0.0; cutoffFrequencyRadPerSec += 10.0) {
            highPassFilteredYoVariable.setCutoffFrequencyHz(cutoffFrequencyRadPerSec / (Math.PI * 2));
            highPassFilteredYoVariable.reset();
            filterAttenuation = this.computeSteadyStateFilteredOutputAmplitude(this.yoTime, 0.001, inputFrequencyRadPerSec, highPassFilteredYoVariable);
            double properHighPassAttenuation = this.computeProperHighPassAttenuation(inputFrequencyRadPerSec, cutoffFrequencyRadPerSec);
            Assertions.assertEquals((double)properHighPassAttenuation, (double)filterAttenuation, (double)0.01);
        }
    }

    @Test
    public void testLowPassAttenuationForSinusoidalInput() {
        double cutoffFrequencyRadPerSec;
        double inputFrequencyRadPerSec = 10.0;
        double filterAttenuation = 1.0;
        FirstOrderFilteredYoDouble lowPassFilteredYoVariable = new FirstOrderFilteredYoDouble("lowPass", "", cutoffFrequencyRadPerSec / (Math.PI * 2), (DoubleProvider)this.yoTime, FirstOrderFilteredYoDouble.FirstOrderFilterType.LOW_PASS, this.registry);
        for (cutoffFrequencyRadPerSec = inputFrequencyRadPerSec * 5.0; filterAttenuation > 0.1 && cutoffFrequencyRadPerSec > 0.0; cutoffFrequencyRadPerSec -= 10.0) {
            lowPassFilteredYoVariable.setCutoffFrequencyHz(cutoffFrequencyRadPerSec / (Math.PI * 2));
            lowPassFilteredYoVariable.reset();
            filterAttenuation = this.computeSteadyStateFilteredOutputAmplitude(this.yoTime, 0.001, inputFrequencyRadPerSec, lowPassFilteredYoVariable);
            double properLowPassAttenuation = this.computeProperLowPassAttenuation(inputFrequencyRadPerSec, cutoffFrequencyRadPerSec);
            Assertions.assertEquals((double)properLowPassAttenuation, (double)filterAttenuation, (double)0.01);
        }
    }

    @Test
    public void testBandPassAttenuationForSinusoidalInput() {
        double b;
        double inputFrequencyRadPerSec = 10.0;
        double a = inputFrequencyRadPerSec / 5.0;
        double filterAttenuation = 1.0;
        FirstOrderBandPassFilteredYoDouble bandPassFilteredYoVariable = new FirstOrderBandPassFilteredYoDouble("sineWave", "", a, b, this.yoTime, this.registry);
        for (b = inputFrequencyRadPerSec * 5.0; filterAttenuation > 0.1 && a > 0.0 && b > 0.0; a -= 10.0, b -= 10.0) {
            bandPassFilteredYoVariable.setPassBand(a / (Math.PI * 2), b / (Math.PI * 2));
            bandPassFilteredYoVariable.reset();
            filterAttenuation = this.computeSteadyStateFilteredOutputAmplitude(this.yoTime, 0.001, inputFrequencyRadPerSec, bandPassFilteredYoVariable);
            double properBandPassAttenuation = this.computeProperBandPassAttenuation(inputFrequencyRadPerSec, a, b);
            Assertions.assertEquals((double)properBandPassAttenuation, (double)filterAttenuation, (double)0.01);
        }
    }

    private double computeProperLowPassAttenuation(double inputFreq_RadPerSec, double cutoffFreq_RadPerSec) {
        double ret = cutoffFreq_RadPerSec / Math.sqrt(inputFreq_RadPerSec * inputFreq_RadPerSec + cutoffFreq_RadPerSec * cutoffFreq_RadPerSec);
        return ret;
    }

    private double computeProperHighPassAttenuation(double inputFreq_RadPerSec, double cutoffFreq_RadPerSec) {
        double ret = inputFreq_RadPerSec / Math.sqrt(inputFreq_RadPerSec * inputFreq_RadPerSec + cutoffFreq_RadPerSec * cutoffFreq_RadPerSec);
        return ret;
    }

    private double computeProperBandPassAttenuation(double inputFreq_RadPerSec, double minFreq_RadPerSec, double maxFreq_RadPerSec) {
        double highPass = this.computeProperHighPassAttenuation(inputFreq_RadPerSec, minFreq_RadPerSec);
        double lowPass = this.computeProperLowPassAttenuation(inputFreq_RadPerSec, maxFreq_RadPerSec);
        double ret = highPass * lowPass;
        return ret;
    }

    private double computeSteadyStateFilteredOutputAmplitude(YoDouble yoTime, double DT, double inputFrequencyRadPerSec, FirstOrderFilteredYoDouble filteredYoVariable) {
        double filterOutput_oldest = 0.0;
        double filterOutput_old = 0.0;
        double filterOutputPeak = 0.0;
        double filterOutputPeakOld = 0.0;
        double filterOutputPeakPercentChange = 100.0;
        boolean filterOutputHasReachedSteadyState = false;
        int i = 0;
        while (!filterOutputHasReachedSteadyState) {
            boolean filterOutputJustHitAPeak;
            double t = (double)i * DT;
            yoTime.set(t);
            double sineWaveInput = Math.sin(inputFrequencyRadPerSec * t);
            filteredYoVariable.update(sineWaveInput);
            double filterOutput = filteredYoVariable.getDoubleValue();
            boolean bl = filterOutputJustHitAPeak = filterOutput_old > filterOutput_oldest && filterOutput_old > filterOutput;
            if (filterOutputJustHitAPeak) {
                filterOutputPeak = filterOutput_old;
                filterOutputPeakPercentChange = 100.0 * Math.abs((filterOutputPeak - filterOutputPeakOld) / filterOutputPeak);
                filterOutputPeakOld = filterOutputPeak;
            }
            filterOutputHasReachedSteadyState = filterOutputPeakPercentChange < 1.0E-6;
            filterOutput_oldest = filterOutput_old;
            filterOutput_old = filterOutput;
            ++i;
        }
        return filterOutputPeak;
    }

    private double computeSteadyStateFilteredOutputAmplitude(YoDouble yoTime, double DT, double inputFrequencyRadPerSec, FirstOrderBandPassFilteredYoDouble filteredYoVariable) {
        double filterOutput_oldest = 0.0;
        double filterOutput_old = 0.0;
        double filterOutputPeak = 0.0;
        double filterOutputPeakOld = 0.0;
        double filterOutputPeakPercentChange = 100.0;
        boolean filterOutputHasReachedSteadyState = false;
        int i = 0;
        while (!filterOutputHasReachedSteadyState) {
            boolean filterOutputJustHitAPeak;
            double t = (double)i * DT;
            yoTime.set(t);
            double sineWaveInput = Math.sin(inputFrequencyRadPerSec * t);
            filteredYoVariable.update(sineWaveInput);
            double filterOutput = filteredYoVariable.getDoubleValue();
            boolean bl = filterOutputJustHitAPeak = filterOutput_old > filterOutput_oldest && filterOutput_old > filterOutput;
            if (filterOutputJustHitAPeak) {
                filterOutputPeak = filterOutput_old;
                filterOutputPeakPercentChange = 100.0 * Math.abs((filterOutputPeak - filterOutputPeakOld) / filterOutputPeak);
                filterOutputPeakOld = filterOutputPeak;
            }
            filterOutputHasReachedSteadyState = filterOutputPeakPercentChange < 1.0E-6;
            filterOutput_oldest = filterOutput_old;
            filterOutput_old = filterOutput;
            ++i;
        }
        return filterOutputPeak;
    }
}

