/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.filters.DelayedYoDouble;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class DelayedYoDoubleTest {
    @Test
    public void testDelayedYoVariableMultipleTickDelays() {
        YoRegistry registry = new YoRegistry("registry");
        YoDouble variableToDelay = new YoDouble("variableToDelay", registry);
        for (int ticksToDelay = 0; ticksToDelay < 10; ++ticksToDelay) {
            int i;
            double firstValue = Math.random();
            variableToDelay.set(firstValue);
            DelayedYoDouble delayedYoVariable = new DelayedYoDouble("delayedVariable" + ticksToDelay, "", (DoubleProvider)variableToDelay, ticksToDelay, registry);
            int ticksToTest = 100;
            double[] valuesToSet = new double[ticksToTest];
            for (i = 0; i < valuesToSet.length; ++i) {
                valuesToSet[i] = Math.random();
            }
            Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)firstValue, (double)1.0E-7);
            for (i = 0; i < ticksToTest; ++i) {
                variableToDelay.set(valuesToSet[i]);
                delayedYoVariable.update();
                if (i < ticksToDelay) {
                    Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)firstValue, (double)1.0E-7);
                    continue;
                }
                Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)valuesToSet[i - ticksToDelay], (double)1.0E-7);
            }
        }
    }

    @Test
    public void testDelayedYoVariableOneTickDelay() {
        YoRegistry registry = new YoRegistry("registry");
        YoDouble variableToDelay = new YoDouble("variableToDelay", registry);
        int ticksToDelay = 1;
        variableToDelay.set(0.0);
        DelayedYoDouble delayedYoVariable = new DelayedYoDouble("delayedVariable" + ticksToDelay, "", (DoubleProvider)variableToDelay, ticksToDelay, registry);
        Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)0.0, (double)1.0E-7);
        variableToDelay.set(1.0);
        delayedYoVariable.update();
        Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)0.0, (double)1.0E-7);
        variableToDelay.set(2.0);
        delayedYoVariable.update();
        Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)1.0, (double)1.0E-7);
        variableToDelay.set(3.0);
        delayedYoVariable.update();
        Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)2.0, (double)1.0E-7);
        delayedYoVariable.update();
        Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)3.0, (double)1.0E-7);
        delayedYoVariable.update();
        Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)3.0, (double)1.0E-7);
        delayedYoVariable.update();
        Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)3.0, (double)1.0E-7);
    }

    @Test
    public void testDelayedYoVariableZeroTickDelay() {
        YoRegistry registry = new YoRegistry("registry");
        YoDouble variableToDelay = new YoDouble("variableToDelay", registry);
        int ticksToDelay = 0;
        variableToDelay.set(0.0);
        DelayedYoDouble delayedYoVariable = new DelayedYoDouble("delayedVariable" + ticksToDelay, "", (DoubleProvider)variableToDelay, ticksToDelay, registry);
        Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)0.0, (double)1.0E-7);
        variableToDelay.set(1.0);
        delayedYoVariable.update();
        Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)1.0, (double)1.0E-7);
        variableToDelay.set(2.0);
        delayedYoVariable.update();
        Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)2.0, (double)1.0E-7);
        variableToDelay.set(3.0);
        delayedYoVariable.update();
        Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)3.0, (double)1.0E-7);
        delayedYoVariable.update();
        Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)3.0, (double)1.0E-7);
        delayedYoVariable.update();
        Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)3.0, (double)1.0E-7);
        delayedYoVariable.update();
        Assertions.assertEquals((double)delayedYoVariable.getDoubleValue(), (double)3.0, (double)1.0E-7);
    }
}

