/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.yoVariables.filters.DeadbandedYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class DeadbandedYoVariableTest {
    @Test
    public void testDeadband() {
        double valueToBeCorrected;
        YoRegistry registry = new YoRegistry("test");
        YoDouble deadzoneSize = new YoDouble("deadzoneSize", registry);
        YoDouble input = new YoDouble("input", registry);
        double deadzone = 2.0;
        deadzoneSize.set(deadzone);
        DeadbandedYoVariable testDeadzone = new DeadbandedYoVariable("testDeadZone", (DoubleProvider)input, (DoubleProvider)deadzoneSize, registry);
        double verySmallStep = 1.0E-4;
        input.set(deadzone - verySmallStep);
        testDeadzone.update();
        Assertions.assertTrue((boolean)MathTools.epsilonEquals((double)testDeadzone.getDoubleValue(), (double)0.0, (double)1.0E-14));
        input.set(deadzone + verySmallStep);
        testDeadzone.update();
        Assertions.assertTrue((boolean)MathTools.epsilonEquals((double)testDeadzone.getDoubleValue(), (double)verySmallStep, (double)1.0E-14));
        input.set(-deadzone + verySmallStep);
        testDeadzone.update();
        Assertions.assertTrue((boolean)MathTools.epsilonEquals((double)testDeadzone.getDoubleValue(), (double)0.0, (double)1.0E-14));
        input.set(-deadzone - verySmallStep);
        testDeadzone.update();
        Assertions.assertTrue((boolean)MathTools.epsilonEquals((double)testDeadzone.getDoubleValue(), (double)(-verySmallStep), (double)1.0E-14));
        for (valueToBeCorrected = -10.0; valueToBeCorrected < -deadzone; valueToBeCorrected += 0.01) {
            input.set(valueToBeCorrected);
            testDeadzone.update();
            Assertions.assertTrue((boolean)MathTools.epsilonEquals((double)testDeadzone.getDoubleValue(), (double)(valueToBeCorrected + deadzone), (double)1.0E-14));
        }
        for (valueToBeCorrected = -deadzone; valueToBeCorrected < deadzone; valueToBeCorrected += 0.01) {
            input.set(valueToBeCorrected);
            testDeadzone.update();
            Assertions.assertTrue((boolean)MathTools.epsilonEquals((double)testDeadzone.getDoubleValue(), (double)0.0, (double)1.0E-14));
        }
        for (valueToBeCorrected = deadzone; valueToBeCorrected < 10.0; valueToBeCorrected += 0.01) {
            input.set(valueToBeCorrected);
            testDeadzone.update();
            Assertions.assertTrue((boolean)MathTools.epsilonEquals((double)testDeadzone.getDoubleValue(), (double)(valueToBeCorrected - deadzone), (double)1.0E-14));
        }
    }
}

