/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.yoVariables.filters.ButterworthFilteredYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ButterworthFilteredYoVariableTest {
    @Test
    public void testAlphaCompute() {
        Random random = new Random(244012L);
        double epsilon = 1.0E-12;
        for (int i = 0; i < 5000; ++i) {
            double dt = RandomNumbers.nextDouble((Random)random, (double)1.0E-4, (double)0.01);
            double samplingFrequency = 1.0 / dt;
            double breakFrequencyIn = 0.0;
            double alpha = ButterworthFilteredYoVariable.computeAlphaGivenBreakFrequency((double)breakFrequencyIn, (double)dt);
            Assertions.assertEquals((double)1.0, (double)alpha, (double)epsilon);
            double breakFrequencyOut = ButterworthFilteredYoVariable.computeBreakFrequencyGivenAlpha((double)alpha, (double)dt);
            Assertions.assertEquals((double)breakFrequencyIn, (double)breakFrequencyOut, (double)epsilon);
            breakFrequencyIn = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)(0.25 * samplingFrequency));
            alpha = ButterworthFilteredYoVariable.computeAlphaGivenBreakFrequency((double)breakFrequencyIn, (double)dt);
            breakFrequencyOut = ButterworthFilteredYoVariable.computeBreakFrequencyGivenAlpha((double)alpha, (double)dt);
            Assertions.assertEquals((double)breakFrequencyIn, (double)breakFrequencyOut, (double)epsilon);
            breakFrequencyIn = RandomNumbers.nextDouble((Random)random, (double)(0.25 * samplingFrequency), (double)(10.0 * samplingFrequency));
            alpha = ButterworthFilteredYoVariable.computeAlphaGivenBreakFrequency((double)breakFrequencyIn, (double)dt);
            Assertions.assertEquals((double)0.0, (double)alpha, (double)epsilon);
            breakFrequencyOut = ButterworthFilteredYoVariable.computeBreakFrequencyGivenAlpha((double)alpha, (double)dt);
            Assertions.assertEquals((double)(0.25 * samplingFrequency), (double)breakFrequencyOut, (double)epsilon);
        }
    }

    @Test
    public void testBreakFrequencyLowPassFilter() {
        double dt = 0.001;
        double desiredBreakFrequency = 4.0;
        double alpha = ButterworthFilteredYoVariable.computeAlphaGivenBreakFrequency((double)desiredBreakFrequency, (double)dt);
        ButterworthFilteredYoVariable butterworthFilteredYoVariable = new ButterworthFilteredYoVariable("test", null, alpha, ButterworthFilteredYoVariable.ButterworthFilterType.LOW_PASS);
        double actualBreakFrequency = ButterworthFilteredYoVariableTest.findBreakFrequency(butterworthFilteredYoVariable, dt, dt);
        double percentError = Math.abs(actualBreakFrequency - desiredBreakFrequency) / desiredBreakFrequency;
        Assertions.assertEquals((double)0.0, (double)percentError, (double)0.05);
    }

    public static double computePredictedAttenuationInDecibels(double cutOffFrequency, int filterOrder, double queryFrequency) {
        return 10.0 * Math.log10(1.0 + Math.pow(queryFrequency / cutOffFrequency, 2.0 * (double)filterOrder));
    }

    @Disabled
    @Test
    public void testButterWorth() {
        YoRegistry registry = new YoRegistry("Test");
        double dt = 0.001;
        double desiredBreakFrequency = 1.0;
        double alpha = ButterworthFilteredYoVariable.computeAlphaGivenBreakFrequency((double)desiredBreakFrequency, (double)dt);
        double testBreakFrequency = desiredBreakFrequency;
        System.out.println(ButterworthFilteredYoVariable.computeAlphaGivenBreakFrequency((double)testBreakFrequency, (double)dt));
        ButterworthFilteredYoVariable butterworthFilteredYoVariable = new ButterworthFilteredYoVariable("test", registry, alpha, ButterworthFilteredYoVariable.ButterworthFilterType.LOW_PASS);
        int numberOfCycles = 6;
        double endTime = (double)numberOfCycles / testBreakFrequency;
        TimedData[] inputCurve = ButterworthFilteredYoVariableTest.generateInputCurve(endTime, testBreakFrequency, dt);
        TimedData[] outputCurve = ButterworthFilteredYoVariableTest.getFilteredCurve(inputCurve, butterworthFilteredYoVariable);
        TimedData[] clippedInputCurve = Arrays.copyOfRange(inputCurve, inputCurve.length / 2, inputCurve.length);
        TimedData[] clippedOutputCurve = Arrays.copyOfRange(outputCurve, outputCurve.length / 2, outputCurve.length);
        double dB = ButterworthFilteredYoVariableTest.getMagnitudeInDecibels(clippedInputCurve, clippedOutputCurve);
        System.out.println("dB= " + dB);
        System.out.println(ButterworthFilteredYoVariableTest.computePredictedAttenuationInDecibels(desiredBreakFrequency, 1, testBreakFrequency));
    }

    private static TimedData[] generateInputCurve(double endTime, double frequency, double dt) {
        return ButterworthFilteredYoVariableTest.generateInputCurve((int)Math.ceil(endTime / dt) + 1, frequency, dt);
    }

    private static TimedData[] generateInputCurve(int numberOfElements, double frequency, double dt) {
        TimedData[] inputCurve = new TimedData[numberOfElements];
        double time = 0.0;
        for (int i = 0; i < numberOfElements; ++i) {
            inputCurve[i] = new TimedData(time, Math.sin(Math.PI * 2 * frequency * time));
            time += dt;
        }
        return inputCurve;
    }

    private static double findBreakFrequency(ButterworthFilteredYoVariable filter, double dt, double tolerance) {
        int numberOfCycles = 10;
        double samplingFrequency = 1.0 / dt;
        double upperBreakFrequency = 0.5 * samplingFrequency;
        double lowerBreakFrequency = 0.0;
        double upper_dB = Double.NEGATIVE_INFINITY;
        double lower_dB = 0.0;
        double cutOff_dB = -ButterworthFilteredYoVariableTest.computePredictedAttenuationInDecibels(samplingFrequency, 1, samplingFrequency);
        while (Math.abs(upper_dB - lower_dB) > tolerance && Math.abs(upperBreakFrequency - lowerBreakFrequency) > 0.01 * dt) {
            double testBreakFrequency = 0.5 * (upperBreakFrequency + lowerBreakFrequency);
            double endTime = (double)numberOfCycles / testBreakFrequency;
            TimedData[] inputCurve = ButterworthFilteredYoVariableTest.generateInputCurve(endTime, testBreakFrequency, dt);
            TimedData[] outputCurve = ButterworthFilteredYoVariableTest.getFilteredCurve(inputCurve, filter);
            TimedData[] clippedInputCurve = Arrays.copyOfRange(inputCurve, inputCurve.length / 2, inputCurve.length);
            TimedData[] clippedOutputCurve = Arrays.copyOfRange(outputCurve, outputCurve.length / 2, outputCurve.length);
            double dB = ButterworthFilteredYoVariableTest.getMagnitudeInDecibels(clippedInputCurve, clippedOutputCurve);
            System.out.println("Test breakFrequency: " + testBreakFrequency + ", dB: " + dB);
            if (dB < cutOff_dB) {
                upperBreakFrequency = testBreakFrequency;
                upper_dB = dB;
                continue;
            }
            lowerBreakFrequency = testBreakFrequency;
            lower_dB = dB;
        }
        return 0.5 * (upperBreakFrequency + lowerBreakFrequency);
    }

    private static TimedData[] getFilteredCurve(TimedData[] input, ButterworthFilteredYoVariable butterworthFilteredYoVariable) {
        TimedData[] filteredCurve = new TimedData[input.length];
        butterworthFilteredYoVariable.reset();
        for (int i = 0; i < input.length; ++i) {
            butterworthFilteredYoVariable.update(input[i].value);
            filteredCurve[i] = new TimedData(input[i].time, butterworthFilteredYoVariable.getDoubleValue());
        }
        return filteredCurve;
    }

    private static double plotBodeForAlpha(double alpha, double dt) {
        YoRegistry registry = new YoRegistry("Test");
        ButterworthFilteredYoVariable butterworthFilteredYoVariable = new ButterworthFilteredYoVariable("test", registry, alpha, ButterworthFilteredYoVariable.ButterworthFilterType.LOW_PASS);
        double startFreq = 0.01;
        double endFreq = 0.25 * (1.0 / dt);
        int numberOfTestPoints = 100;
        double deltaFreq = (endFreq - startFreq) / (double)(numberOfTestPoints - 1);
        ArrayList<Double> testFrequencies = new ArrayList<Double>();
        ArrayList<Double> attenuations = new ArrayList<Double>();
        for (double freq = startFreq; freq <= endFreq; freq += deltaFreq) {
            int numberOfCycles = 3;
            double endTime = (double)numberOfCycles / freq;
            TimedData[] inputCurve = ButterworthFilteredYoVariableTest.generateInputCurve(endTime, freq, dt);
            TimedData[] outputCurve = ButterworthFilteredYoVariableTest.getFilteredCurve(inputCurve, butterworthFilteredYoVariable);
            double dB = ButterworthFilteredYoVariableTest.getMagnitudeInDecibels(inputCurve, outputCurve);
            testFrequencies.add(freq);
            attenuations.add(dB);
        }
        ArrayList<Double> testFrequenciesLog = ButterworthFilteredYoVariableTest.convertToLog(testFrequencies);
        double breakFreq = ButterworthFilteredYoVariableTest.getBreakFreq(testFrequencies, attenuations);
        return breakFreq;
    }

    private static double getBreakFreq(List<Double> freq, List<Double> attenutation_dB) {
        for (int i = 0; i < freq.size(); ++i) {
            double attenuation = attenutation_dB.get(i);
            if (!(attenuation < -3.0)) continue;
            return freq.get(i);
        }
        return Double.POSITIVE_INFINITY;
    }

    private static ArrayList<Double> convertToLog(List<Double> arrayListToConvert) {
        ArrayList<Double> ret = new ArrayList<Double>();
        for (Double value : arrayListToConvert) {
            double logValue = Math.log10(value);
            ret.add(logValue);
        }
        return ret;
    }

    private static double getMagnitudeInDecibels(TimedData[] input, TimedData[] output) {
        double inputAmp = ButterworthFilteredYoVariableTest.getMaximumPeakToPeakAmplitude(input);
        double outputAmp = ButterworthFilteredYoVariableTest.getMaximumPeakToPeakAmplitude(output);
        double attenuation = outputAmp / inputAmp;
        return 10.0 * Math.log10(attenuation);
    }

    private static double getMaximumPeakToPeakAmplitude(TimedData[] dataset) {
        double value;
        double maximumValue = value = dataset[0].value;
        double minimumValue = value;
        for (int i = 1; i < dataset.length; ++i) {
            value = dataset[1].value;
            if (value > maximumValue) {
                maximumValue = value;
                continue;
            }
            if (!(value < minimumValue)) continue;
            minimumValue = value;
        }
        return maximumValue - minimumValue;
    }

    private static class TimedData {
        private double time;
        private double value;

        public TimedData(double time, double value) {
            this.time = time;
            this.value = value;
        }
    }
}

