/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.yoVariables.filters.BacklashCompensatingVelocityYoVariable;
import us.ihmc.yoVariables.filters.FilteredFiniteDifferenceYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class BacklashCompensatingVelocityYoVariableTest {
    private static final double EPSILON = 1.0E-8;

    @Test
    public void testWithoutBacklashOrFiltering1() {
        Random rand = new Random(1798L);
        YoRegistry registry = new YoRegistry("blop");
        YoDouble alphaVariable = new YoDouble("alpha", registry);
        double dt = RandomNumbers.nextDouble((Random)rand, (double)1.0E-8, (double)1.0);
        YoDouble slopTime = new YoDouble("slop", registry);
        BacklashCompensatingVelocityYoVariable unprocessed = new BacklashCompensatingVelocityYoVariable("", "", alphaVariable, dt, slopTime, registry);
        double rawPosition = 0.0;
        double rawPositionPrevValue = 0.0;
        unprocessed.update(rawPosition);
        for (int i = 0; i < 1000; ++i) {
            rawPosition = RandomNumbers.nextDouble((Random)rand, (double)-100.0, (double)100.0);
            unprocessed.update(rawPosition);
            double rawVelocity = (rawPosition - rawPositionPrevValue) / dt;
            Assertions.assertEquals((double)rawVelocity, (double)unprocessed.getDoubleValue(), (double)1.0E-8);
            rawPositionPrevValue = rawPosition;
        }
    }

    @Test
    public void testWithoutBacklashOrFiltering2() {
        Random rand = new Random(1798L);
        YoRegistry registry = new YoRegistry("blop");
        YoDouble alphaVariable = new YoDouble("alpha", registry);
        double dt = RandomNumbers.nextDouble((Random)rand, (double)1.0E-8, (double)1.0);
        YoDouble slopTime = new YoDouble("slop", registry);
        YoDouble rawPosition = new YoDouble("rawPosition", registry);
        BacklashCompensatingVelocityYoVariable unprocessed = new BacklashCompensatingVelocityYoVariable("", "", (DoubleProvider)alphaVariable, (DoubleProvider)rawPosition, dt, (DoubleProvider)slopTime, registry);
        double rawPositionPrevValue = 0.0;
        unprocessed.update();
        for (int i = 0; i < 1000; ++i) {
            rawPosition.set(RandomNumbers.nextDouble((Random)rand, (double)-100.0, (double)100.0));
            unprocessed.update();
            double rawVelocity = (rawPosition.getDoubleValue() - rawPositionPrevValue) / dt;
            Assertions.assertEquals((double)rawVelocity, (double)unprocessed.getDoubleValue(), (double)1.0E-8);
            rawPositionPrevValue = rawPosition.getDoubleValue();
        }
    }

    @Test
    public void testWithoutBacklash1() {
        Random rand = new Random(1798L);
        YoRegistry registry = new YoRegistry("blop");
        YoDouble alphaVariable = new YoDouble("alpha", registry);
        alphaVariable.set(RandomNumbers.nextDouble((Random)rand, (double)0.1, (double)1.0));
        double dt = RandomNumbers.nextDouble((Random)rand, (double)1.0E-8, (double)1.0);
        YoDouble slopTime = new YoDouble("slop", registry);
        YoDouble rawPosition = new YoDouble("rawPosition", registry);
        FilteredFiniteDifferenceYoVariable filtVelocity = new FilteredFiniteDifferenceYoVariable("filtVelocity", "", (DoubleProvider)alphaVariable, (DoubleProvider)rawPosition, dt, registry);
        BacklashCompensatingVelocityYoVariable filteredOnly = new BacklashCompensatingVelocityYoVariable("", "", alphaVariable, dt, slopTime, registry);
        filtVelocity.update();
        filteredOnly.update(rawPosition.getDoubleValue());
        for (int i = 0; i < 1000; ++i) {
            alphaVariable.set(RandomNumbers.nextDouble((Random)rand, (double)0.1, (double)1.0));
            rawPosition.set(RandomNumbers.nextDouble((Random)rand, (double)-100.0, (double)100.0));
            filtVelocity.update();
            filteredOnly.update(rawPosition.getDoubleValue());
            Assertions.assertEquals((double)filtVelocity.getDoubleValue(), (double)filteredOnly.getDoubleValue(), (double)1.0E-8);
        }
    }

    @Test
    public void testWithoutBacklash2() {
        Random rand = new Random(1798L);
        YoRegistry registry = new YoRegistry("blop");
        YoDouble alphaVariable = new YoDouble("alpha", registry);
        alphaVariable.set(RandomNumbers.nextDouble((Random)rand, (double)0.0, (double)1.0));
        double dt = RandomNumbers.nextDouble((Random)rand, (double)1.0E-8, (double)1.0);
        YoDouble slopTime = new YoDouble("slop", registry);
        YoDouble rawPosition = new YoDouble("rawPosition", registry);
        FilteredFiniteDifferenceYoVariable filtVelocity = new FilteredFiniteDifferenceYoVariable("filtVelocity", "", (DoubleProvider)alphaVariable, (DoubleProvider)rawPosition, dt, registry);
        BacklashCompensatingVelocityYoVariable filteredOnly = new BacklashCompensatingVelocityYoVariable("", "", (DoubleProvider)alphaVariable, (DoubleProvider)rawPosition, dt, (DoubleProvider)slopTime, registry);
        filtVelocity.update();
        filteredOnly.update();
        for (int i = 0; i < 1000; ++i) {
            alphaVariable.set(RandomNumbers.nextDouble((Random)rand, (double)0.1, (double)1.0));
            rawPosition.set(RandomNumbers.nextDouble((Random)rand, (double)-100.0, (double)100.0));
            filtVelocity.update();
            filteredOnly.update();
            Assertions.assertEquals((double)filtVelocity.getDoubleValue(), (double)filteredOnly.getDoubleValue(), (double)1.0E-8);
        }
    }

    @Test
    public void testVelocityPositiveWithoutCrossingZero2() {
        Random rand = new Random(1798L);
        YoRegistry registry = new YoRegistry("blop");
        YoDouble alphaVariable = new YoDouble("alpha", registry);
        alphaVariable.set(RandomNumbers.nextDouble((Random)rand, (double)0.0, (double)1.0));
        double dt = RandomNumbers.nextDouble((Random)rand, (double)1.0E-8, (double)1.0);
        YoDouble slopTime = new YoDouble("slop", registry);
        YoDouble rawPosition = new YoDouble("rawPosition", registry);
        FilteredFiniteDifferenceYoVariable filtVelocity = new FilteredFiniteDifferenceYoVariable("filtVelocity", "", (DoubleProvider)alphaVariable, (DoubleProvider)rawPosition, dt, registry);
        BacklashCompensatingVelocityYoVariable backlashAndFiltered = new BacklashCompensatingVelocityYoVariable("", "", (DoubleProvider)alphaVariable, (DoubleProvider)rawPosition, dt, (DoubleProvider)slopTime, registry);
        filtVelocity.update();
        backlashAndFiltered.update();
        double currentTime = 0.0;
        for (int i = 0; i < 10000; ++i) {
            slopTime.set(RandomNumbers.nextDouble((Random)rand, (double)0.0, (double)10.0));
            alphaVariable.set(RandomNumbers.nextDouble((Random)rand, (double)0.1, (double)1.0));
            rawPosition.add(RandomNumbers.nextDouble((Random)rand, (double)0.0, (double)101.0));
            filtVelocity.update();
            backlashAndFiltered.update();
            Assertions.assertEquals((double)filtVelocity.getDoubleValue(), (double)backlashAndFiltered.getDoubleValue(), (double)1.0E-8);
            currentTime += dt;
        }
    }

    @Test
    public void testVelocityNegativeWithoutCrossingZero2() {
        Random rand = new Random(1798L);
        YoRegistry registry = new YoRegistry("blop");
        YoDouble alphaVariable = new YoDouble("alpha", registry);
        alphaVariable.set(RandomNumbers.nextDouble((Random)rand, (double)0.0, (double)1.0));
        double dt = RandomNumbers.nextDouble((Random)rand, (double)1.0E-8, (double)1.0);
        YoDouble slopTime = new YoDouble("slop", registry);
        YoDouble rawPosition = new YoDouble("rawPosition", registry);
        FilteredFiniteDifferenceYoVariable filtVelocity = new FilteredFiniteDifferenceYoVariable("filtVelocity", "", (DoubleProvider)alphaVariable, (DoubleProvider)rawPosition, dt, registry);
        BacklashCompensatingVelocityYoVariable backlashAndFiltered = new BacklashCompensatingVelocityYoVariable("", "", (DoubleProvider)alphaVariable, (DoubleProvider)rawPosition, dt, (DoubleProvider)slopTime, registry);
        filtVelocity.update();
        backlashAndFiltered.update();
        for (int i = 0; i < 1000; ++i) {
            slopTime.set(RandomNumbers.nextDouble((Random)rand, (double)0.0, (double)100.0));
            alphaVariable.set(RandomNumbers.nextDouble((Random)rand, (double)0.0, (double)1.0));
            rawPosition.sub(RandomNumbers.nextDouble((Random)rand, (double)0.0, (double)101.0));
            filtVelocity.update();
            backlashAndFiltered.update();
            Assertions.assertEquals((double)filtVelocity.getDoubleValue(), (double)backlashAndFiltered.getDoubleValue(), (double)1.0E-8);
        }
    }

    @Test
    public void testNoisySignalAndMakeSureVelocityHasSignalContent() {
        Random random = new Random(1798L);
        YoRegistry registry = new YoRegistry("Registry");
        YoDouble alphaVariable = new YoDouble("alpha", registry);
        YoDouble slopTime = new YoDouble("slopTime", registry);
        YoDouble cleanPosition = new YoDouble("cleanPosition", registry);
        YoDouble noisyPosition = new YoDouble("noisyPosition", registry);
        YoDouble cleanVelocity = new YoDouble("cleanVelocity", registry);
        YoDouble reconstructedPosition = new YoDouble("reconstructedPosition", registry);
        YoDouble reconstructedPosition2 = new YoDouble("reconstructedPosition2", registry);
        YoDouble totalReconstructedPositionError2 = new YoDouble("totalReconstructedPositionError2", registry);
        YoDouble averageReconstructedPositionError2 = new YoDouble("averageReconstructedPositionError2", registry);
        double dt = 0.001;
        double totalTime = 5.0;
        double amplitude = 2.0;
        double frequency = 1.0;
        double noiseAmplitude = 0.01;
        slopTime.set(0.1);
        alphaVariable.set(0.95);
        BacklashCompensatingVelocityYoVariable revisedBacklashCompensatingVelocity = new BacklashCompensatingVelocityYoVariable("bl_qd_velocity2", "", (DoubleProvider)alphaVariable, (DoubleProvider)noisyPosition, dt, (DoubleProvider)slopTime, registry);
        reconstructedPosition2.set(amplitude);
        for (double time = 0.0; time < totalTime; time += dt) {
            cleanPosition.set(amplitude * Math.cos(Math.PI * 2 * frequency * time));
            cleanVelocity.set(Math.PI * -2 * amplitude * frequency * Math.sin(Math.PI * 2 * frequency * time));
            noisyPosition.set(cleanPosition.getDoubleValue());
            noisyPosition.add(RandomNumbers.nextDouble((Random)random, (double)noiseAmplitude));
            revisedBacklashCompensatingVelocity.update();
            reconstructedPosition2.add(revisedBacklashCompensatingVelocity.getDoubleValue() * dt);
            double positionError2 = reconstructedPosition2.getDoubleValue() - cleanPosition.getDoubleValue();
            totalReconstructedPositionError2.add(Math.abs(positionError2) * dt);
        }
        averageReconstructedPositionError2.set(totalReconstructedPositionError2.getDoubleValue() / totalTime);
        Assertions.assertTrue((averageReconstructedPositionError2.getDoubleValue() < 0.25 ? 1 : 0) != 0);
    }

    @Test
    public void testSignalWithBacklash() {
        YoRegistry registry = new YoRegistry("Registry");
        YoDouble alphaVariable = new YoDouble("alpha", registry);
        YoDouble slopTime = new YoDouble("slopTime", registry);
        YoDouble cleanPosition = new YoDouble("cleanPosition", registry);
        YoDouble backlashyPosition = new YoDouble("backlashyPosition", registry);
        YoDouble cleanVelocity = new YoDouble("cleanVelocity", registry);
        YoDouble reconstructedPosition2 = new YoDouble("reconstructedPosition2", registry);
        YoDouble totalReconstructedPositionError2 = new YoDouble("totalReconstructedPositionError2", registry);
        YoDouble averageReconstructedPositionError2 = new YoDouble("averageReconstructedPositionError2", registry);
        double dt = 0.001;
        double totalTime = 5.0;
        double amplitude = 2.0;
        double frequency = 1.0;
        double backlashAmount = 0.1;
        slopTime.set(0.1);
        alphaVariable.set(0.95);
        BacklashCompensatingVelocityYoVariable revisedBacklashCompensatingVelocity = new BacklashCompensatingVelocityYoVariable("bl_qd_velocity2", "", (DoubleProvider)alphaVariable, (DoubleProvider)backlashyPosition, dt, (DoubleProvider)slopTime, registry);
        reconstructedPosition2.set(amplitude);
        for (double time = 0.0; time < totalTime; time += dt) {
            cleanPosition.set(amplitude * Math.cos(Math.PI * 2 * frequency * time));
            cleanVelocity.set(Math.PI * -2 * amplitude * frequency * Math.sin(Math.PI * 2 * frequency * time));
            backlashyPosition.set(cleanPosition.getDoubleValue());
            if (cleanVelocity.getDoubleValue() > 0.0) {
                backlashyPosition.add(backlashAmount);
            }
            revisedBacklashCompensatingVelocity.update();
            reconstructedPosition2.add(revisedBacklashCompensatingVelocity.getDoubleValue() * dt);
            double positionError2 = reconstructedPosition2.getDoubleValue() - cleanPosition.getDoubleValue();
            totalReconstructedPositionError2.add(Math.abs(positionError2) * dt);
        }
        averageReconstructedPositionError2.set(totalReconstructedPositionError2.getDoubleValue() / totalTime);
        Assertions.assertTrue((averageReconstructedPositionError2.getDoubleValue() < 0.25 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveSquareWaveBacklash() {
        YoRegistry registry = new YoRegistry("Registry");
        YoDouble alphaVariable = new YoDouble("alpha", registry);
        YoDouble slopTime = new YoDouble("slopTime", registry);
        YoDouble backlashyPosition = new YoDouble("backlashyPosition", registry);
        double dt = 0.001;
        double totalTime = 5.0;
        double frequency = 30.0;
        double backlashAmount = 0.1;
        slopTime.set(0.1);
        alphaVariable.set(0.95);
        BacklashCompensatingVelocityYoVariable revisedBacklashCompensatingVelocity = new BacklashCompensatingVelocityYoVariable("bl_qd_velocity2", "", (DoubleProvider)alphaVariable, (DoubleProvider)backlashyPosition, dt, (DoubleProvider)slopTime, registry);
        backlashyPosition.set(0.0);
        revisedBacklashCompensatingVelocity.update();
        backlashyPosition.set(backlashAmount);
        int i = 0;
        while ((double)i < 2.0 * slopTime.getDoubleValue() / dt) {
            revisedBacklashCompensatingVelocity.update();
            ++i;
        }
        for (double time = 0.0; time < totalTime; time += dt) {
            backlashyPosition.set(Math.cos(Math.PI * 2 * frequency * time));
            if (backlashyPosition.getDoubleValue() > 0.0) {
                backlashyPosition.set(backlashAmount);
            } else {
                backlashyPosition.set(-backlashAmount);
            }
            revisedBacklashCompensatingVelocity.update();
            Assertions.assertEquals((double)0.0, (double)revisedBacklashCompensatingVelocity.getDoubleValue(), (double)0.001);
        }
    }
}

