/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.filters.AlphaBetaFilteredYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class AlphaBetaFilteredYoVariableTest {
    private static final double DT = 0.1;

    @Test
    public void testAlphaBetaFilteredVelocityAndPositionEstimatesWithNoVelocity() {
        YoRegistry registry = new YoRegistry("testRegistry");
        YoDouble positionVariable = new YoDouble("positionVariable", registry);
        YoDouble xMeasuredVariable = new YoDouble("xMeasuredVariable", registry);
        double alpha = 0.2;
        double beta = 0.35;
        AlphaBetaFilteredYoVariable abFilteredYoVariable = new AlphaBetaFilteredYoVariable("abFilteredYoVariable", registry, alpha, beta, positionVariable, xMeasuredVariable, 0.1);
        abFilteredYoVariable.set(0.0);
        positionVariable.set(0.0);
        xMeasuredVariable.set(42.0);
        for (int i = 0; i < 10000; ++i) {
            abFilteredYoVariable.update();
        }
        Assertions.assertEquals((double)0.0, (double)abFilteredYoVariable.getDoubleValue(), (double)1.0E-7);
    }

    @Test
    public void testAlphaBetaFilteredVelocityAndPositionEstimatesWithConstantVelocity() {
        YoRegistry registry = new YoRegistry("testRegistry");
        YoDouble positionVariable = new YoDouble("positionVariable", registry);
        YoDouble xMeasuredVariable = new YoDouble("xMeasuredVariable", registry);
        double alpha = 0.2;
        double beta = 0.35;
        AlphaBetaFilteredYoVariable abFilteredYoVariable = new AlphaBetaFilteredYoVariable("abFilteredYoVariable", registry, alpha, beta, positionVariable, xMeasuredVariable, 0.1);
        for (int i = 0; i < 10000; ++i) {
            abFilteredYoVariable.set(0.0);
            positionVariable.set(0.0);
            xMeasuredVariable.set(42.0);
            for (int j = 0; j < 10000; ++j) {
                xMeasuredVariable.set(xMeasuredVariable.getDoubleValue() + 10.0);
                abFilteredYoVariable.update();
            }
            Assertions.assertEquals((double)100.0, (double)abFilteredYoVariable.getDoubleValue(), (double)1.0E-7);
        }
    }
}

