/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.filters;

import java.util.Random;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.AngleTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.yoVariables.euclid.filters.FiniteDifferenceAngularVelocityYoFrameVector3D;
import us.ihmc.yoVariables.euclid.filters.RateLimitedYoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.registry.YoRegistry;

public class RateLimitedYoFrameQuaternionTest {
    private static final double EPSILON = 1.0E-12;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testConvergenceWithConstantInput() {
        Random random = new Random(46363L);
        double dt = 0.004;
        MutableDouble maxRate = new MutableDouble();
        YoRegistry registry = new YoRegistry("dummy");
        RateLimitedYoFrameQuaternion rateLimitedQuaternion = new RateLimitedYoFrameQuaternion("blop", "", registry, () -> maxRate.doubleValue(), dt, ReferenceFrame.getWorldFrame());
        rateLimitedQuaternion.update((QuaternionReadOnly)new Quaternion());
        FiniteDifferenceAngularVelocityYoFrameVector3D angularVelocity = new FiniteDifferenceAngularVelocityYoFrameVector3D("rate", (YoFrameQuaternion)rateLimitedQuaternion, dt, registry);
        for (int i = 0; i < 1000; ++i) {
            maxRate.setValue(RandomNumbers.nextDouble((Random)random, (double)0.001, (double)10.0));
            Quaternion goalQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            double distanceToGoal = Math.abs(AngleTools.trimAngleMinusPiToPi((double)rateLimitedQuaternion.distance((Orientation3DReadOnly)goalQuaternion)));
            if (distanceToGoal / dt < maxRate.doubleValue()) {
                rateLimitedQuaternion.update((QuaternionReadOnly)goalQuaternion);
                EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)goalQuaternion, (Orientation3DReadOnly)rateLimitedQuaternion, (double)1.0E-12);
                continue;
            }
            double timeToConverge = distanceToGoal / maxRate.doubleValue();
            int numberOfIterations = (int)(timeToConverge / dt);
            double previousDistance = distanceToGoal;
            angularVelocity.update();
            for (int j = 0; j < numberOfIterations; ++j) {
                rateLimitedQuaternion.update((QuaternionReadOnly)goalQuaternion);
                double distance = Math.abs(AngleTools.trimAngleMinusPiToPi((double)rateLimitedQuaternion.distance((Orientation3DReadOnly)goalQuaternion)));
                Assertions.assertTrue((distance < previousDistance ? 1 : 0) != 0);
                angularVelocity.update();
                double rate = angularVelocity.norm();
                Assertions.assertEquals((double)rate, (double)maxRate.doubleValue(), (double)1.0E-12, (String)("difference: " + Math.abs(rate - maxRate.doubleValue())));
                previousDistance = distance;
                Assertions.assertFalse((boolean)rateLimitedQuaternion.geometricallyEquals((EuclidGeometry)goalQuaternion, 1.0E-12));
            }
            rateLimitedQuaternion.update((QuaternionReadOnly)goalQuaternion);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)goalQuaternion, (Orientation3DReadOnly)rateLimitedQuaternion, (double)1.0E-12);
        }
    }
}

