/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.filters;

import java.util.Random;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.AngleTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.yoVariables.euclid.filters.FiniteDifferenceAngularVelocityYoFrameVector3D;
import us.ihmc.yoVariables.euclid.filters.RateLimitedYoFrameOrientation;
import us.ihmc.yoVariables.registry.YoRegistry;

public class RateLimitedYoFrameOrientationTest {
    private static final double EPSILON = 2.0E-11;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testConvergenceWithConstantInput() throws Exception {
        Random random = new Random(46363L);
        double dt = 0.004;
        MutableDouble maxRate = new MutableDouble();
        YoRegistry registry = new YoRegistry("dummy");
        RateLimitedYoFrameOrientation rateLimitedOrientation = new RateLimitedYoFrameOrientation("blop", "", registry, () -> maxRate.doubleValue(), dt, ReferenceFrame.getWorldFrame());
        rateLimitedOrientation.update((QuaternionReadOnly)new Quaternion());
        FiniteDifferenceAngularVelocityYoFrameVector3D angularVelocity = new FiniteDifferenceAngularVelocityYoFrameVector3D("rate", ReferenceFrame.getWorldFrame(), dt, registry);
        for (int i = 0; i < 1000; ++i) {
            maxRate.setValue(RandomNumbers.nextDouble((Random)random, (double)0.001, (double)10.0));
            Quaternion goalQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            double distanceToGoal = Math.abs(AngleTools.trimAngleMinusPiToPi((double)new Quaternion((Orientation3DReadOnly)rateLimitedOrientation).distance((Orientation3DReadOnly)goalQuaternion)));
            if (distanceToGoal / dt < maxRate.doubleValue()) {
                rateLimitedOrientation.update((QuaternionReadOnly)goalQuaternion);
                EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)goalQuaternion, (Orientation3DReadOnly)new Quaternion((Orientation3DReadOnly)rateLimitedOrientation), (double)2.0E-11);
                continue;
            }
            double timeToConverge = distanceToGoal / maxRate.doubleValue();
            int numberOfIterations = (int)(timeToConverge / dt);
            double previousDistance = distanceToGoal;
            angularVelocity.update((FrameOrientation3DReadOnly)rateLimitedOrientation);
            for (int j = 0; j < numberOfIterations; ++j) {
                rateLimitedOrientation.update((QuaternionReadOnly)goalQuaternion);
                double distance = Math.abs(AngleTools.trimAngleMinusPiToPi((double)new Quaternion((Orientation3DReadOnly)rateLimitedOrientation).distance((Orientation3DReadOnly)goalQuaternion)));
                Assertions.assertTrue((distance < previousDistance ? 1 : 0) != 0);
                angularVelocity.update((FrameOrientation3DReadOnly)rateLimitedOrientation);
                double rate = angularVelocity.norm();
                Assertions.assertEquals((double)rate, (double)maxRate.doubleValue(), (double)2.0E-11, (String)("difference: " + Math.abs(rate - maxRate.doubleValue())));
                previousDistance = distance;
                Assertions.assertFalse((boolean)new Quaternion((Orientation3DReadOnly)rateLimitedOrientation).geometricallyEquals((EuclidGeometry)goalQuaternion, 2.0E-11));
            }
            rateLimitedOrientation.update((QuaternionReadOnly)goalQuaternion);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)goalQuaternion, (Orientation3DReadOnly)new Quaternion((Orientation3DReadOnly)rateLimitedOrientation), (double)2.0E-11);
        }
    }
}

