/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.buffer;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.buffer.YoBufferVariableEntry;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferIndexChangedListener;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferProcessor;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoSearchTools;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoBufferTest {
    private final int testBufferSize = 100;
    private YoEnum<EnumYoVariableTestEnums> yoEnum;
    private YoDouble yoDouble;
    private YoBoolean yoBoolean;
    private YoInteger yoInteger;
    private YoRegistry registry;
    private YoBuffer dataBuffer = new YoBuffer(100);
    private YoDouble a;
    private YoDouble b;
    private YoDouble c;
    private YoBufferVariableEntry aBuffer;
    private YoBufferVariableEntry bBuffer;
    private YoBufferVariableEntry cBuffer;

    @BeforeEach
    public void setUp() {
        this.registry = new YoRegistry("testRegistry");
        this.yoDouble = new YoDouble("yoDouble", this.registry);
        this.yoBoolean = new YoBoolean("yoBoolean", this.registry);
        this.yoInteger = new YoInteger("yoInteger", this.registry);
        this.yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class);
        this.a = new YoDouble("a_arm", this.registry);
        this.b = new YoDouble("b_arm", this.registry);
        this.c = new YoDouble("c_arm", this.registry);
        this.aBuffer = new YoBufferVariableEntry((YoVariable)this.a, 100);
        this.bBuffer = new YoBufferVariableEntry((YoVariable)this.b, 100);
        this.cBuffer = new YoBufferVariableEntry((YoVariable)this.c, 100);
    }

    @AfterEach
    public void tearDown() {
        this.yoDouble = null;
        this.registry = null;
    }

    @Test
    public void testGetBufferSize() {
        int testBufferSize = this.dataBuffer.getBufferSize();
        int expectedBufferSize = testBufferSize;
        Assertions.assertTrue((expectedBufferSize == testBufferSize ? 1 : 0) != 0);
    }

    @Test
    public void testAddAndGetEntry() {
        YoBufferVariableEntry doubleDataBufferEntryTest = new YoBufferVariableEntry((YoVariable)this.yoDouble, 100);
        YoBufferVariableEntry booleanDataBufferEntryTest = new YoBufferVariableEntry((YoVariable)this.yoBoolean, 100);
        YoBufferVariableEntry integerDataBufferEntryTest = new YoBufferVariableEntry((YoVariable)this.yoInteger, 100);
        YoBufferVariableEntry enumDataBufferEntryTest = new YoBufferVariableEntry(this.yoEnum, 100);
        this.dataBuffer.addEntry(doubleDataBufferEntryTest);
        this.dataBuffer.addEntry(booleanDataBufferEntryTest);
        this.dataBuffer.addEntry(integerDataBufferEntryTest);
        this.dataBuffer.addEntry(enumDataBufferEntryTest);
        YoBufferVariableEntry testEntryReceivedViaString = this.dataBuffer.findVariableEntry("yoDouble");
        YoBufferVariableEntry testEntryReceivedViaVariableName = this.dataBuffer.getEntry((YoVariable)this.yoDouble);
        Assertions.assertEquals((Object)doubleDataBufferEntryTest, (Object)testEntryReceivedViaString);
        Assertions.assertEquals((Object)doubleDataBufferEntryTest, (Object)testEntryReceivedViaVariableName);
        testEntryReceivedViaString = this.dataBuffer.findVariableEntry("yoBoolean");
        testEntryReceivedViaVariableName = this.dataBuffer.getEntry((YoVariable)this.yoBoolean);
        Assertions.assertEquals((Object)booleanDataBufferEntryTest, (Object)testEntryReceivedViaString);
        Assertions.assertEquals((Object)booleanDataBufferEntryTest, (Object)testEntryReceivedViaVariableName);
        testEntryReceivedViaString = this.dataBuffer.findVariableEntry("yoInteger");
        testEntryReceivedViaVariableName = this.dataBuffer.getEntry((YoVariable)this.yoInteger);
        Assertions.assertEquals((Object)integerDataBufferEntryTest, (Object)testEntryReceivedViaString);
        Assertions.assertEquals((Object)integerDataBufferEntryTest, (Object)testEntryReceivedViaVariableName);
        testEntryReceivedViaString = this.dataBuffer.findVariableEntry("yoEnum");
        testEntryReceivedViaVariableName = this.dataBuffer.getEntry(this.yoEnum);
        Assertions.assertEquals((Object)enumDataBufferEntryTest, (Object)testEntryReceivedViaString);
        Assertions.assertEquals((Object)enumDataBufferEntryTest, (Object)testEntryReceivedViaVariableName);
    }

    @Test
    public void testAddNewEntry() {
        this.dataBuffer.addVariable((YoVariable)this.yoDouble);
        this.dataBuffer.addVariable((YoVariable)this.yoBoolean);
        this.dataBuffer.addVariable((YoVariable)this.yoInteger);
        this.dataBuffer.addVariable(this.yoEnum);
        YoBufferVariableEntry doubleDataBufferEntryTest = new YoBufferVariableEntry((YoVariable)this.yoDouble, 100);
        YoBufferVariableEntry booleanDataBufferEntryTest = new YoBufferVariableEntry((YoVariable)this.yoBoolean, 100);
        YoBufferVariableEntry integerDataBufferEntryTest = new YoBufferVariableEntry((YoVariable)this.yoInteger, 100);
        YoBufferVariableEntry enumDataBufferEntryTest = new YoBufferVariableEntry(this.yoEnum, 100);
        Assertions.assertTrue((doubleDataBufferEntryTest.getVariable() == this.dataBuffer.getEntry((YoVariable)this.yoDouble).getVariable() ? 1 : 0) != 0);
        Assertions.assertTrue((booleanDataBufferEntryTest.getVariable() == this.dataBuffer.getEntry((YoVariable)this.yoBoolean).getVariable() ? 1 : 0) != 0);
        Assertions.assertTrue((integerDataBufferEntryTest.getVariable() == this.dataBuffer.getEntry((YoVariable)this.yoInteger).getVariable() ? 1 : 0) != 0);
        Assertions.assertTrue((enumDataBufferEntryTest.getVariable() == this.dataBuffer.getEntry(this.yoEnum).getVariable() ? 1 : 0) != 0);
    }

    @Test
    public void testAddVariable() {
        this.dataBuffer.addVariable((YoVariable)this.yoDouble);
        this.dataBuffer.addVariable((YoVariable)this.yoBoolean);
        this.dataBuffer.addVariable((YoVariable)this.yoInteger);
        this.dataBuffer.addVariable(this.yoEnum);
        Assertions.assertTrue((this.yoDouble == this.dataBuffer.getEntry((YoVariable)this.yoDouble).getVariable() ? 1 : 0) != 0);
        Assertions.assertTrue((this.yoBoolean == this.dataBuffer.getEntry((YoVariable)this.yoBoolean).getVariable() ? 1 : 0) != 0);
        Assertions.assertTrue((this.yoInteger == this.dataBuffer.getEntry((YoVariable)this.yoInteger).getVariable() ? 1 : 0) != 0);
        Assertions.assertTrue((this.yoEnum == this.dataBuffer.getEntry(this.yoEnum).getVariable() ? 1 : 0) != 0);
    }

    @Test
    public void testAddVariableWithArrayList() {
        ArrayList<Object> arrayListToBeAdded = new ArrayList<Object>();
        arrayListToBeAdded.add(this.yoDouble);
        arrayListToBeAdded.add(this.yoBoolean);
        arrayListToBeAdded.add(this.yoInteger);
        arrayListToBeAdded.add(this.yoEnum);
        this.dataBuffer.addVariables(arrayListToBeAdded);
        Assertions.assertTrue((this.yoDouble == this.dataBuffer.getEntry((YoVariable)this.yoDouble).getVariable() ? 1 : 0) != 0);
        Assertions.assertTrue((this.yoBoolean == this.dataBuffer.getEntry((YoVariable)this.yoBoolean).getVariable() ? 1 : 0) != 0);
        Assertions.assertTrue((this.yoInteger == this.dataBuffer.getEntry((YoVariable)this.yoInteger).getVariable() ? 1 : 0) != 0);
        Assertions.assertTrue((this.yoEnum == this.dataBuffer.getEntry(this.yoEnum).getVariable() ? 1 : 0) != 0);
    }

    @Test
    public void testGetVariablesThatStartWith() {
        YoDouble yoVariable1 = new YoDouble("doy", this.registry);
        YoDouble yoVariable2 = new YoDouble("Dog", this.registry);
        YoDouble yoVariable3 = new YoDouble("bar", this.registry);
        this.dataBuffer.addVariable((YoVariable)this.yoDouble);
        this.dataBuffer.addVariable((YoVariable)this.yoBoolean);
        this.dataBuffer.addVariable((YoVariable)this.yoInteger);
        this.dataBuffer.addVariable(this.yoEnum);
        this.dataBuffer.addVariable((YoVariable)yoVariable1);
        this.dataBuffer.addVariable((YoVariable)yoVariable2);
        this.dataBuffer.addVariable((YoVariable)yoVariable3);
    }

    @Test
    public void testGetEntries() {
        ArrayList<YoBufferVariableEntry> expectedDataEntries = new ArrayList<YoBufferVariableEntry>();
        YoBufferVariableEntry doubleDataBufferEntryTest = new YoBufferVariableEntry((YoVariable)this.yoDouble, 100);
        YoBufferVariableEntry booleanDataBufferEntryTest = new YoBufferVariableEntry((YoVariable)this.yoBoolean, 100);
        YoBufferVariableEntry integerDataBufferEntryTest = new YoBufferVariableEntry((YoVariable)this.yoInteger, 100);
        YoBufferVariableEntry enumDataBufferEntryTest = new YoBufferVariableEntry(this.yoEnum, 100);
        this.dataBuffer.addEntry(doubleDataBufferEntryTest);
        this.dataBuffer.addEntry(booleanDataBufferEntryTest);
        this.dataBuffer.addEntry(integerDataBufferEntryTest);
        this.dataBuffer.addEntry(enumDataBufferEntryTest);
        expectedDataEntries.add(doubleDataBufferEntryTest);
        expectedDataEntries.add(booleanDataBufferEntryTest);
        expectedDataEntries.add(integerDataBufferEntryTest);
        expectedDataEntries.add(enumDataBufferEntryTest);
        Assertions.assertEquals(expectedDataEntries, (Object)this.dataBuffer.getEntries());
    }

    @Test
    public void testGetVariables() {
        this.dataBuffer.addVariable((YoVariable)this.yoDouble);
        this.dataBuffer.addVariable((YoVariable)this.yoBoolean);
        this.dataBuffer.addVariable((YoVariable)this.yoInteger);
        this.dataBuffer.addVariable(this.yoEnum);
        ArrayList<Object> expectedArrayOfVariables = new ArrayList<Object>();
        expectedArrayOfVariables.add(this.yoDouble);
        expectedArrayOfVariables.add(this.yoBoolean);
        expectedArrayOfVariables.add(this.yoInteger);
        expectedArrayOfVariables.add(this.yoEnum);
        List actualArrayOfVariables = this.dataBuffer.getVariables();
        for (int i = 0; i < actualArrayOfVariables.size(); ++i) {
            Assertions.assertTrue((boolean)expectedArrayOfVariables.contains(actualArrayOfVariables.get(i)));
        }
    }

    @Test
    public void testEmptyBufferIncreaseBufferSize() {
        int originalBufferSize = this.dataBuffer.getBufferSize();
        int newBufferSize = originalBufferSize * 2;
        this.dataBuffer.resizeBuffer(newBufferSize);
        Assertions.assertEquals((int)newBufferSize, (int)this.dataBuffer.getBufferSize());
    }

    @Test
    public void testEmptyBufferDecreaseBufferSize() {
        int originalBufferSize = this.dataBuffer.getBufferSize();
        int newBufferSize = originalBufferSize / 2;
        this.dataBuffer.resizeBuffer(newBufferSize);
        Assertions.assertEquals((int)newBufferSize, (int)this.dataBuffer.getBufferSize());
    }

    @Test
    public void testEnlargeBufferSize() {
        YoBufferVariableEntry doubleDataBufferEntryTest = new YoBufferVariableEntry((YoVariable)this.yoDouble, 100);
        this.dataBuffer.addEntry(doubleDataBufferEntryTest);
        int originalBufferSize = this.dataBuffer.getBufferSize();
        int newBufferSize = originalBufferSize * 2;
        this.dataBuffer.resizeBuffer(newBufferSize);
        Assertions.assertEquals((int)newBufferSize, (int)this.dataBuffer.getBufferSize());
    }

    @Test
    public void testDecreaseBufferSize() {
        YoBufferVariableEntry doubleDataBufferEntryTest = new YoBufferVariableEntry((YoVariable)this.yoDouble, 100);
        this.dataBuffer.addEntry(doubleDataBufferEntryTest);
        int originalBufferSize = this.dataBuffer.getBufferSize();
        int newBufferSize = originalBufferSize / 2;
        this.dataBuffer.resizeBuffer(newBufferSize);
        Assertions.assertEquals((int)newBufferSize, (int)this.dataBuffer.getBufferSize());
    }

    @Test
    public void testTick() {
        boolean rolledOver;
        int numberOfTicksAndUpdates = 20;
        for (int i = 0; i < numberOfTicksAndUpdates; ++i) {
            this.dataBuffer.tickAndWriteIntoBuffer();
        }
        this.dataBuffer.gotoInPoint();
        int expectedIndex = 0;
        while (this.dataBuffer.getCurrentIndex() < this.dataBuffer.getBufferInOutLength() - 1) {
            Assertions.assertEquals((int)expectedIndex, (int)this.dataBuffer.getCurrentIndex());
            rolledOver = this.dataBuffer.tickAndReadFromBuffer(1);
            Assertions.assertFalse((boolean)rolledOver);
            ++expectedIndex;
        }
        rolledOver = this.dataBuffer.tickAndReadFromBuffer(1);
        Assertions.assertTrue((boolean)rolledOver);
        expectedIndex = 0;
        Assertions.assertEquals((int)expectedIndex, (int)this.dataBuffer.getCurrentIndex());
        rolledOver = this.dataBuffer.tickAndReadFromBuffer(1);
        Assertions.assertFalse((boolean)rolledOver);
        expectedIndex = 1;
        Assertions.assertEquals((int)expectedIndex, (int)this.dataBuffer.getCurrentIndex());
    }

    @Test
    public void testCropBuffer() {
        this.dataBuffer.cropBuffer();
        int bufferSize = this.dataBuffer.getBufferSize();
        this.dataBuffer.cropBuffer();
        Assertions.assertEquals((int)bufferSize, (int)this.dataBuffer.getBufferSize());
    }

    @Test
    public void testIsIndexBetweenInAndOutPoint() {
        int i;
        Assertions.assertEquals((int)0, (int)this.dataBuffer.getCurrentIndex());
        Assertions.assertEquals((int)0, (int)this.dataBuffer.getInPoint());
        Assertions.assertEquals((int)0, (int)this.dataBuffer.getOutPoint());
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(0));
        Assertions.assertFalse((boolean)this.dataBuffer.isIndexBetweenBounds(1));
        Assertions.assertFalse((boolean)this.dataBuffer.isIndexBetweenBounds(-1));
        this.dataBuffer.tickAndWriteIntoBuffer();
        Assertions.assertEquals((int)1, (int)this.dataBuffer.getCurrentIndex());
        Assertions.assertEquals((int)0, (int)this.dataBuffer.getInPoint());
        Assertions.assertEquals((int)1, (int)this.dataBuffer.getOutPoint());
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(0));
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(1));
        Assertions.assertFalse((boolean)this.dataBuffer.isIndexBetweenBounds(-1));
        this.dataBuffer.tickAndWriteIntoBuffer();
        Assertions.assertEquals((int)2, (int)this.dataBuffer.getCurrentIndex());
        Assertions.assertEquals((int)0, (int)this.dataBuffer.getInPoint());
        Assertions.assertEquals((int)2, (int)this.dataBuffer.getOutPoint());
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(0));
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(1));
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(2));
        Assertions.assertFalse((boolean)this.dataBuffer.isIndexBetweenBounds(3));
        Assertions.assertFalse((boolean)this.dataBuffer.isIndexBetweenBounds(-1));
        int numTicks = 20;
        for (i = 0; i < numTicks; ++i) {
            this.dataBuffer.tickAndWriteIntoBuffer();
        }
        Assertions.assertEquals((int)this.dataBuffer.getOutPoint(), (int)this.dataBuffer.getCurrentIndex());
        Assertions.assertEquals((int)0, (int)this.dataBuffer.getInPoint());
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getCurrentIndex() - 1));
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getCurrentIndex()));
        Assertions.assertFalse((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getCurrentIndex() + 1));
        Assertions.assertFalse((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getInPoint() - 1));
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getInPoint()));
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getInPoint() + 1));
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getOutPoint() - 1));
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getOutPoint()));
        Assertions.assertFalse((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getOutPoint() + 1));
        this.dataBuffer.cropBuffer();
        this.dataBuffer.gotoOutPoint();
        Assertions.assertEquals((int)this.dataBuffer.getOutPoint(), (int)this.dataBuffer.getCurrentIndex());
        Assertions.assertEquals((int)0, (int)this.dataBuffer.getInPoint());
        numTicks = 7;
        for (i = 0; i < numTicks; ++i) {
            this.dataBuffer.tickAndWriteIntoBuffer();
        }
        Assertions.assertEquals((int)this.dataBuffer.getOutPoint(), (int)this.dataBuffer.getCurrentIndex());
        Assertions.assertEquals((int)(numTicks - 1), (int)this.dataBuffer.getOutPoint());
        Assertions.assertEquals((int)numTicks, (int)this.dataBuffer.getInPoint());
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getCurrentIndex() - 1));
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getCurrentIndex()));
        Assertions.assertFalse((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getCurrentIndex() + 1));
        this.dataBuffer.tickAndWriteIntoBuffer();
        Assertions.assertEquals((int)this.dataBuffer.getOutPoint(), (int)this.dataBuffer.getCurrentIndex());
        Assertions.assertEquals((int)this.dataBuffer.getOutPoint(), (int)(this.dataBuffer.getInPoint() - 1));
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getCurrentIndex() - 1));
        Assertions.assertTrue((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getCurrentIndex()));
        Assertions.assertFalse((boolean)this.dataBuffer.isIndexBetweenBounds(this.dataBuffer.getCurrentIndex() + 1));
    }

    @Test
    public void testSetLockIndex() {
        boolean isSafe = this.dataBuffer.isIndexLocked();
        Assertions.assertFalse((boolean)isSafe);
        this.dataBuffer.setLockIndex(true);
        boolean isFinallySafe = this.dataBuffer.isIndexLocked();
        Assertions.assertTrue((boolean)isFinallySafe);
        this.dataBuffer.setLockIndex(false);
        boolean isNowSafe = this.dataBuffer.isIndexLocked();
        Assertions.assertFalse((boolean)isNowSafe);
    }

    @Test
    public void testGetVars() {
        this.dataBuffer.addEntry(this.aBuffer);
        this.dataBuffer.addEntry(this.bBuffer);
        this.dataBuffer.addEntry(this.cBuffer);
        String[] varNames = new String[]{"a_arm", "b_arm", "c_arm"};
        String[] aNames = new String[]{"a_arm"};
        String[] allRegularExpressions = new String[]{".*"};
        String[] cRegularExpressions = new String[]{"c.*"};
        List justNames = Stream.of(varNames).flatMap(varName -> this.dataBuffer.findVariables(varName).stream()).collect(Collectors.toList());
        Assertions.assertTrue((boolean)justNames.contains(this.a));
        Assertions.assertTrue((boolean)justNames.contains(this.b));
        Assertions.assertTrue((boolean)justNames.contains(this.c));
        List justA = Stream.of(aNames).flatMap(varName -> this.dataBuffer.findVariables(varName).stream()).collect(Collectors.toList());
        Assertions.assertTrue((boolean)justA.contains(this.a));
        Assertions.assertFalse((boolean)justA.contains(this.b));
        Assertions.assertFalse((boolean)justA.contains(this.c));
        List justRegExp = this.dataBuffer.filterVariables(YoSearchTools.regularExpressionFilter((String[])allRegularExpressions));
        Assertions.assertTrue((boolean)justRegExp.contains(this.a));
        Assertions.assertTrue((boolean)justRegExp.contains(this.b));
        Assertions.assertTrue((boolean)justRegExp.contains(this.c));
        List cRegExp = this.dataBuffer.filterVariables(YoSearchTools.regularExpressionFilter((String[])cRegularExpressions));
        Assertions.assertFalse((boolean)cRegExp.contains(this.a));
        Assertions.assertFalse((boolean)cRegExp.contains(this.b));
        Assertions.assertTrue((boolean)cRegExp.contains(this.c));
    }

    @Test
    public void testCloseAndDispose() {
        this.dataBuffer.addEntry(this.aBuffer);
        this.dataBuffer.addEntry(this.bBuffer);
        this.dataBuffer.addEntry(this.cBuffer);
        Assertions.assertTrue((this.dataBuffer.getEntries().size() == 3 ? 1 : 0) != 0);
        this.dataBuffer.clear();
        Assertions.assertTrue((boolean)this.dataBuffer.getEntries().isEmpty());
        Assertions.assertTrue((this.dataBuffer.getCurrentIndex() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCopyValuesThrough() {
        YoBufferVariableEntry dataBufferEntry;
        int i;
        Random random = new Random(574893L);
        this.fillDataBufferWithRandomData(random);
        List entries = this.dataBuffer.getEntries();
        for (i = 0; i < entries.size(); ++i) {
            dataBufferEntry = (YoBufferVariableEntry)entries.get(i);
            double[] data = dataBufferEntry.getBuffer();
            for (int j = 0; j < data.length - 1; ++j) {
                Assertions.assertTrue((data[j] != 0.0 ? 1 : 0) != 0);
            }
        }
        this.dataBuffer.fillBuffer();
        for (i = 0; i < entries.size(); ++i) {
            dataBufferEntry = (YoBufferVariableEntry)entries.get(i);
            YoVariable variable = dataBufferEntry.getVariable();
            double[] data = dataBufferEntry.getBuffer();
            for (int j = 0; j < data.length - 1; ++j) {
                Assertions.assertTrue((data[j] == variable.getValueAsDouble() ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testPackDataWithInvalidStartPoint() {
        Random random = new Random(27093L);
        this.fillDataBufferWithRandomData(random);
        Assertions.assertTrue((this.dataBuffer.getInPoint() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.dataBuffer.getOutPoint() == 99 ? 1 : 0) != 0);
        this.dataBuffer.shiftBuffer(-1);
        Assertions.assertTrue((this.dataBuffer.getInPoint() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.dataBuffer.getOutPoint() == 99 ? 1 : 0) != 0);
        this.dataBuffer.shiftBuffer(100);
        Assertions.assertTrue((this.dataBuffer.getInPoint() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.dataBuffer.getOutPoint() == 99 ? 1 : 0) != 0);
    }

    @Test
    public void testPackData() {
        int TEST_ITERATIONS = 1000;
        Random random = new Random(209390L);
        this.fillDataBufferWithRandomData(random);
        Assertions.assertTrue((this.dataBuffer.getInPoint() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.dataBuffer.getOutPoint() == 99 ? 1 : 0) != 0);
        for (int i = 0; i < TEST_ITERATIONS; ++i) {
            YoBuffer dataBufferClone = new YoBuffer(this.dataBuffer);
            int newIndex = random.nextInt(100);
            this.dataBuffer.setCurrentIndex(newIndex);
            int newStartLocation = random.nextInt(100);
            this.dataBuffer.shiftBuffer(newStartLocation);
            List entries = this.dataBuffer.getEntries();
            List entriesClone = dataBufferClone.getEntries();
            for (int j = 0; j < this.dataBuffer.getEntries().size(); ++j) {
                YoBufferVariableEntry entry = (YoBufferVariableEntry)entries.get(j);
                YoBufferVariableEntry entryClone = (YoBufferVariableEntry)entriesClone.get(j);
                double[] data = entry.getBuffer();
                double[] dataClone = entryClone.getBuffer();
                for (int k = 0; k < data.length; ++k) {
                    Assertions.assertTrue((dataClone[k] == data[(k + 100 - newStartLocation) % 100] ? 1 : 0) != 0);
                }
                if (newStartLocation >= newIndex) {
                    Assertions.assertTrue((this.dataBuffer.getCurrentIndex() == 0 ? 1 : 0) != 0);
                } else {
                    Assertions.assertTrue((this.dataBuffer.getCurrentIndex() == newIndex - newStartLocation ? 1 : 0) != 0);
                }
                Assertions.assertTrue((this.dataBuffer.getInPoint() == 0 ? 1 : 0) != 0);
                Assertions.assertTrue((this.dataBuffer.getOutPoint() == 99 - newStartLocation ? 1 : 0) != 0);
            }
            this.dataBuffer.setInOutPointFullBuffer();
        }
    }

    private void fillDataBufferWithRandomData(Random random) {
        this.dataBuffer.addEntry(this.aBuffer);
        this.dataBuffer.addEntry(this.bBuffer);
        this.dataBuffer.addEntry(this.cBuffer);
        this.dataBuffer.setInOutPointFullBuffer();
        for (int i = 0; i < 100; ++i) {
            this.a.set(random.nextDouble());
            this.b.set(random.nextDouble());
            this.c.set(random.nextDouble());
            this.dataBuffer.writeIntoBuffer();
            this.dataBuffer.tickAndReadFromBuffer(1);
        }
    }

    @Test
    public void testCheckIfDataIsEqual() {
        YoBuffer dataBuffer = new YoBuffer(0);
        YoBuffer otherDataBuffer = new YoBuffer(0);
        Assertions.assertTrue((boolean)dataBuffer.epsilonEquals(otherDataBuffer, 1.0E-6));
        YoRegistry dataBufferRegistry = new YoRegistry("dataBufferRegistry");
        YoDouble dataBufferYoDouble = new YoDouble("dataBufferYoDouble", dataBufferRegistry);
        YoBufferVariableEntry dataBufferEntry = new YoBufferVariableEntry((YoVariable)dataBufferYoDouble, 0);
        dataBuffer.addEntry(dataBufferEntry);
        Assertions.assertFalse((boolean)dataBuffer.epsilonEquals(otherDataBuffer, 1.0));
        YoRegistry otherDataBufferRegistry = new YoRegistry("otherDataBufferRegistry");
        YoDouble otherDataBufferYoDouble = new YoDouble("otherDataBufferYoDouble", otherDataBufferRegistry);
        YoBufferVariableEntry otherDataBufferEntry = new YoBufferVariableEntry((YoVariable)otherDataBufferYoDouble, 0);
        otherDataBuffer.addEntry(otherDataBufferEntry);
        Assertions.assertFalse((boolean)dataBuffer.epsilonEquals(otherDataBuffer, 1.0E-6));
        dataBuffer = new YoBuffer(100);
        otherDataBuffer = new YoBuffer(100);
        dataBuffer.addVariable((YoVariable)dataBufferYoDouble);
        otherDataBuffer.addVariable((YoVariable)dataBufferYoDouble);
        int numberOfTicks = 5;
        for (int i = 0; i < numberOfTicks; ++i) {
            dataBufferYoDouble.set(1.0);
            dataBuffer.tickAndWriteIntoBuffer();
            dataBufferYoDouble.set(0.0);
            otherDataBuffer.tickAndWriteIntoBuffer();
        }
        Assertions.assertFalse((boolean)dataBuffer.epsilonEquals(otherDataBuffer, 1.0E-6));
    }

    @Test
    public void testCloneDataBuffer() {
        Random random = new Random(19824L);
        this.fillDataBufferWithRandomData(random);
        YoBuffer dataBufferClone = new YoBuffer(this.dataBuffer);
        Assertions.assertTrue((boolean)this.dataBuffer.epsilonEquals(dataBufferClone, 1.0E-6));
    }

    @Test
    public void testCutDataWithInvalidStartAndEnd() {
        Random random = new Random(6543897L);
        this.fillDataBufferWithRandomData(random);
        Assertions.assertTrue((this.dataBuffer.getCurrentIndex() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.dataBuffer.getInPoint() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.dataBuffer.getOutPoint() == 99 ? 1 : 0) != 0);
        this.dataBuffer.cutBuffer(-1, 50);
        Assertions.assertTrue((this.dataBuffer.getCurrentIndex() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.dataBuffer.getInPoint() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.dataBuffer.getOutPoint() == 99 ? 1 : 0) != 0);
        this.dataBuffer.cutBuffer(50, 101);
        Assertions.assertTrue((this.dataBuffer.getCurrentIndex() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.dataBuffer.getInPoint() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.dataBuffer.getOutPoint() == 99 ? 1 : 0) != 0);
    }

    @Test
    public void testCutDataOfEntireBuffer() {
        Random random = new Random(27489L);
        this.fillDataBufferWithRandomData(random);
        Assertions.assertTrue((this.dataBuffer.getInPoint() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.dataBuffer.getOutPoint() == 99 ? 1 : 0) != 0);
        this.dataBuffer.cutBuffer();
        Assertions.assertTrue((this.dataBuffer.getBufferSize() == 100 ? 1 : 0) != 0);
        for (YoBufferVariableEntry entry : this.dataBuffer.getEntries()) {
            for (double d : entry.getBuffer()) {
                Assertions.assertTrue((d == 0.0 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testCutData() {
        int TEST_ITERATIONS = 1000;
        Random random = new Random(345890L);
        this.fillDataBufferWithRandomData(random);
        Assertions.assertTrue((this.dataBuffer.getInPoint() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.dataBuffer.getOutPoint() == 99 ? 1 : 0) != 0);
        YoBuffer unmodifiedDataBuffer = new YoBuffer(this.dataBuffer);
        for (int i = 0; i < TEST_ITERATIONS; ++i) {
            int start = random.nextInt(100);
            int end = random.nextInt(100);
            this.dataBuffer.cutBuffer(start, end);
            for (int j = 0; j < this.dataBuffer.getEntries().size(); ++j) {
                YoBufferVariableEntry cutEntry = (YoBufferVariableEntry)this.dataBuffer.getEntries().get(j);
                YoBufferVariableEntry unmodifiedEntry = (YoBufferVariableEntry)unmodifiedDataBuffer.getEntries().get(j);
                for (int k = 0; k < cutEntry.getBuffer().length; ++k) {
                    double dataFromUnmodifiedEntry;
                    int indexInUnmodifiedEntry;
                    double dataFromCutEntry;
                    if (start < end) {
                        Assertions.assertTrue((this.dataBuffer.getBufferSize() == 100 - (end - start + 1) ? 1 : 0) != 0);
                        dataFromCutEntry = cutEntry.getBuffer()[k];
                        indexInUnmodifiedEntry = k < start ? k : end + k - start + 1;
                        dataFromUnmodifiedEntry = unmodifiedEntry.getBuffer()[indexInUnmodifiedEntry];
                        Assertions.assertTrue((dataFromCutEntry == dataFromUnmodifiedEntry ? 1 : 0) != 0);
                        continue;
                    }
                    if (start > end) {
                        Assertions.assertTrue((this.dataBuffer.getBufferSize() == 100 ? 1 : 0) != 0);
                        Assertions.assertTrue((cutEntry.getBuffer()[k] == unmodifiedEntry.getBuffer()[k] ? 1 : 0) != 0);
                        continue;
                    }
                    Assertions.assertTrue((this.dataBuffer.getBufferSize() == 99 ? 1 : 0) != 0);
                    dataFromCutEntry = cutEntry.getBuffer()[k];
                    indexInUnmodifiedEntry = k < start ? k : k + 1;
                    dataFromUnmodifiedEntry = unmodifiedEntry.getBuffer()[indexInUnmodifiedEntry];
                    Assertions.assertTrue((dataFromCutEntry == dataFromUnmodifiedEntry ? 1 : 0) != 0);
                }
            }
            this.dataBuffer = new YoBuffer(unmodifiedDataBuffer);
        }
    }

    @Test
    public void testThinData() {
        int TEST_ITERATIONS = 1000;
        Random random = new Random(246370L);
        this.fillDataBufferWithRandomData(random);
        YoBuffer unmodifiedDataBuffer = new YoBuffer(this.dataBuffer);
        for (int i = 0; i < TEST_ITERATIONS; ++i) {
            int keepEveryNthPoint = random.nextInt(99) + 1;
            this.dataBuffer.thinData(keepEveryNthPoint);
            for (int j = 0; j < this.dataBuffer.getEntries().size(); ++j) {
                YoBufferVariableEntry thinnedEntry = (YoBufferVariableEntry)this.dataBuffer.getEntries().get(j);
                YoBufferVariableEntry unmodifiedEntry = (YoBufferVariableEntry)unmodifiedDataBuffer.getEntries().get(j);
                for (int k = 0; k < thinnedEntry.getBuffer().length; ++k) {
                    double[] thinnedEntryData = thinnedEntry.getBuffer();
                    double[] unmodifiedEntryData = unmodifiedEntry.getBuffer();
                    if (keepEveryNthPoint < 50) {
                        Assertions.assertTrue((thinnedEntry.getBufferSize() == 100 / keepEveryNthPoint ? 1 : 0) != 0);
                        double thinnedEntryDatum = thinnedEntryData[k];
                        double unmodifiedEntryDatum = unmodifiedEntryData[k * keepEveryNthPoint];
                        Assertions.assertTrue((thinnedEntryDatum == unmodifiedEntryDatum ? 1 : 0) != 0);
                        continue;
                    }
                    Assertions.assertTrue((thinnedEntry.getBufferSize() == 100 ? 1 : 0) != 0);
                    Assertions.assertTrue((thinnedEntryData[k] == unmodifiedEntryData[k] ? 1 : 0) != 0);
                }
            }
            this.dataBuffer = new YoBuffer(unmodifiedDataBuffer);
        }
    }

    @Test
    public void testAttachIndexChangedListener() {
        boolean[] listenerNotified = new boolean[]{false, false};
        YoBufferIndexChangedListener indexChangedListener = newIndex -> {
            listenerNotified[0] = true;
        };
        this.dataBuffer.addListener(indexChangedListener);
        Assertions.assertFalse((boolean)listenerNotified[0]);
        Assertions.assertFalse((boolean)listenerNotified[1]);
        this.dataBuffer.tickAndWriteIntoBuffer();
        Assertions.assertTrue((boolean)listenerNotified[0]);
        Assertions.assertFalse((boolean)listenerNotified[1]);
    }

    @Test
    public void testApplyDataProcessingFunction() {
        Random random = new Random(74523L);
        this.fillDataBufferWithRandomData(random);
        YoBufferProcessor forwardDataProcessingFunction = new YoBufferProcessor(){

            public void process(int startIndex, int endIndex, int currentIndex) {
                YoBufferTest.this.a.set(1.0);
                YoBufferTest.this.b.set(2.348);
                YoBufferTest.this.c.set(8.7834);
            }
        };
        Assertions.assertFalse((this.a.getDoubleValue() == 1.0 ? 1 : 0) != 0);
        Assertions.assertFalse((this.b.getDoubleValue() == 2.348 ? 1 : 0) != 0);
        Assertions.assertFalse((this.c.getDoubleValue() == 8.7834 ? 1 : 0) != 0);
        this.dataBuffer.applyProcessor(forwardDataProcessingFunction);
        Assertions.assertTrue((this.a.getDoubleValue() == 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.b.getDoubleValue() == 2.348 ? 1 : 0) != 0);
        Assertions.assertTrue((this.c.getDoubleValue() == 8.7834 ? 1 : 0) != 0);
        this.dataBuffer.setCurrentIndex(this.dataBuffer.getOutPoint());
        YoBufferProcessor backwardsDataProcessingFunction = new YoBufferProcessor(){

            public boolean goForward() {
                return false;
            }

            public void process(int startIndex, int endIndex, int currentIndex) {
                YoBufferTest.this.a.set(0.0);
                YoBufferTest.this.b.set(0.0);
                YoBufferTest.this.c.set(0.0);
            }
        };
        Assertions.assertFalse((this.a.getDoubleValue() == 0.0 ? 1 : 0) != 0);
        Assertions.assertFalse((this.b.getDoubleValue() == 0.0 ? 1 : 0) != 0);
        Assertions.assertFalse((this.c.getDoubleValue() == 0.0 ? 1 : 0) != 0);
        this.dataBuffer.applyProcessor(backwardsDataProcessingFunction);
        Assertions.assertTrue((this.a.getDoubleValue() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.b.getDoubleValue() == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.c.getDoubleValue() == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testToggleKeyPointMode() {
        boolean keyPointModeToggled = this.dataBuffer.getKeyPointsHandler().areKeyPointsEnabled();
        this.dataBuffer.getKeyPointsHandler().toggleKeyPoints();
        Assertions.assertFalse((keyPointModeToggled == this.dataBuffer.getKeyPointsHandler().areKeyPointsEnabled() ? 1 : 0) != 0);
        this.dataBuffer.getKeyPointsHandler().toggleKeyPoints();
        Assertions.assertTrue((keyPointModeToggled == this.dataBuffer.getKeyPointsHandler().areKeyPointsEnabled() ? 1 : 0) != 0);
    }

    @Test
    public void testGetSetTimeVariable() {
        String timeVariableName = "time";
        YoDouble time = new YoDouble(timeVariableName, this.registry);
        this.dataBuffer.addVariable((YoVariable)time);
        this.dataBuffer.setTimeVariableName(timeVariableName);
        int numberOfTicks = 5;
        double[] timeData = new double[numberOfTicks];
        for (int i = 0; i < numberOfTicks; ++i) {
            time.set((double)i);
            timeData[i] = i;
            this.dataBuffer.tickAndWriteIntoBuffer();
        }
        Assertions.assertTrue((boolean)this.dataBuffer.getTimeVariableName().equals(timeVariableName));
        Assertions.assertTrue((timeData.length == this.dataBuffer.getCurrentIndex() ? 1 : 0) != 0);
        double[] dataBufferTimeData = this.dataBuffer.getTimeBuffer();
        for (int i = 0; i < timeData.length; ++i) {
            Assertions.assertTrue((timeData[i] == dataBufferTimeData[i + 1] ? 1 : 0) != 0);
        }
    }

    private static enum EnumYoVariableTestEnums {
        ONE,
        TWO;

    }
}

