/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.variable;

import java.util.Random;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariableType;

public class YoDoubleTest {
    private YoRegistry registry;
    private YoDouble yoDouble1;
    private YoDouble yoDouble2;
    private static final double EPSILON = 1.0E-10;
    private Random random = new Random(345345L);

    @BeforeEach
    public void setUp() {
        this.registry = new YoRegistry("testRegistry");
        this.yoDouble1 = new YoDouble("yoDouble1", this.registry);
        this.yoDouble2 = new YoDouble("yoDouble2", "description2", this.registry);
        this.yoDouble2.setVariableBounds(0.0, 10.0);
    }

    @AfterEach
    public void tearDown() {
        this.yoDouble1 = null;
        this.registry = null;
    }

    @Test
    public void testVariableChangeListenerNotification() {
        MutableBoolean valueChanged = new MutableBoolean(false);
        YoVariableChangedListener listener = v -> valueChanged.setTrue();
        this.yoDouble1.addListener(listener);
        this.yoDouble1.set(this.yoDouble1.getValue() + 0.1);
        Assertions.assertTrue((boolean)valueChanged.booleanValue());
        valueChanged.setFalse();
        this.yoDouble1.set(this.yoDouble1.getValue());
        Assertions.assertFalse((boolean)valueChanged.booleanValue());
        this.yoDouble1.set(Double.POSITIVE_INFINITY);
        Assertions.assertTrue((boolean)valueChanged.booleanValue());
        valueChanged.setFalse();
        this.yoDouble1.set(Double.POSITIVE_INFINITY);
        Assertions.assertFalse((boolean)valueChanged.booleanValue());
        this.yoDouble1.set(Double.NEGATIVE_INFINITY);
        Assertions.assertTrue((boolean)valueChanged.booleanValue());
        valueChanged.setFalse();
        this.yoDouble1.set(Double.NEGATIVE_INFINITY);
        Assertions.assertFalse((boolean)valueChanged.booleanValue());
        this.yoDouble1.set(Double.NaN);
        Assertions.assertTrue((boolean)valueChanged.booleanValue());
        valueChanged.setFalse();
        this.yoDouble1.set(Double.NaN);
        Assertions.assertFalse((boolean)valueChanged.booleanValue());
    }

    @Test
    public void testDoubleYoVariableConstructorWithoutDescription() {
        Assertions.assertTrue((this.yoDouble1.getDoubleValue() == 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)this.yoDouble1.getName(), (Object)"yoDouble1");
    }

    @Test
    public void testDoubleYoVariableConstructorWithDescription() {
        String testDescription = "This is a test description.";
        YoDouble yoDoubleWithDescription = new YoDouble("yoDoubleWithDescription", testDescription, this.registry);
        Assertions.assertTrue((yoDoubleWithDescription.getDoubleValue() == 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)yoDoubleWithDescription.getName(), (Object)"yoDoubleWithDescription");
        Assertions.assertTrue((yoDoubleWithDescription.getDescription() == testDescription ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        double randomNumber = Math.random();
        this.yoDouble1.set(randomNumber);
        Assertions.assertEquals((Object)this.yoDouble1.toString(), (Object)("yoDouble1: " + randomNumber));
    }

    @Test
    public void testIsNaN() {
        Assertions.assertFalse((boolean)this.yoDouble2.isNaN());
        this.yoDouble2.set(Double.NaN);
        Assertions.assertTrue((boolean)this.yoDouble2.isNaN());
    }

    @Test
    public void testAdditionWithDoubles() {
        double randomNumber1 = Math.random();
        double randomNumber2 = Math.random();
        this.yoDouble1.set(randomNumber1);
        this.yoDouble1.add(randomNumber2);
        double expectedSum = randomNumber1 + randomNumber2;
        Assertions.assertTrue((this.yoDouble1.getDoubleValue() == expectedSum ? 1 : 0) != 0);
    }

    @Test
    public void testSubtractionWithDoubles() {
        double randomNumber1 = Math.random();
        double randomNumber2 = Math.random();
        this.yoDouble1.set(randomNumber1);
        this.yoDouble1.sub(randomNumber2);
        double expectedDifference = randomNumber1 - randomNumber2;
        Assertions.assertTrue((this.yoDouble1.getDoubleValue() == expectedDifference ? 1 : 0) != 0);
    }

    @Test
    public void testMultiplicationWithDoubles() {
        double randomNumber1 = Math.random();
        double randomNumber2 = Math.random();
        this.yoDouble1.set(randomNumber1);
        this.yoDouble1.mul(randomNumber2);
        double expectedProduct = randomNumber1 * randomNumber2;
        Assertions.assertTrue((this.yoDouble1.getDoubleValue() == expectedProduct ? 1 : 0) != 0);
    }

    @Test
    public void testAdditionWithDoubleYoVariables() {
        double randomNumber1 = Math.random();
        double randomNumber2 = Math.random();
        this.yoDouble1.set(randomNumber1);
        this.yoDouble2.set(randomNumber2);
        double expectedSum = this.yoDouble1.getDoubleValue() + this.yoDouble2.getDoubleValue();
        this.yoDouble1.add(this.yoDouble2);
        Assertions.assertTrue((this.yoDouble1.getDoubleValue() == expectedSum ? 1 : 0) != 0);
    }

    @Test
    public void testSubtractionWithDoubleYoVariables() {
        double randomNumber1 = Math.random();
        double randomNumber2 = Math.random();
        this.yoDouble1.set(randomNumber1);
        this.yoDouble2.set(randomNumber2);
        double expectedDifference = this.yoDouble1.getDoubleValue() - this.yoDouble2.getDoubleValue();
        this.yoDouble1.sub(this.yoDouble2);
        Assertions.assertTrue((this.yoDouble1.getDoubleValue() == expectedDifference ? 1 : 0) != 0);
    }

    @Test
    public void testMultiplicationWithDoubleYoVariables() {
        double randomNumber1 = Math.random();
        double randomNumber2 = Math.random();
        this.yoDouble1.set(randomNumber1);
        this.yoDouble2.set(randomNumber2);
        double expectedProduct = this.yoDouble1.getDoubleValue() * this.yoDouble2.getDoubleValue();
        this.yoDouble1.mul(this.yoDouble2);
        Assertions.assertTrue((this.yoDouble1.getDoubleValue() == expectedProduct ? 1 : 0) != 0);
    }

    @Test
    public void testValueEquals() {
        double randomNumber = Math.random();
        this.yoDouble1.set(randomNumber);
        this.yoDouble1.valueEquals(randomNumber);
    }

    @Test
    public void testGetAndSetMethods() {
        double randomNumber = Math.random();
        this.yoDouble1.set(randomNumber);
        this.yoDouble2.set(this.yoDouble1.getDoubleValue());
        Assertions.assertTrue((this.yoDouble1.getDoubleValue() == this.yoDouble2.getDoubleValue() ? 1 : 0) != 0);
    }

    @Test
    public void testGetAndSetDoubleValue() {
        double randomNumber = Math.random();
        this.yoDouble1.setValueFromDouble(randomNumber);
        this.yoDouble2.setValueFromDouble(this.yoDouble1.getValueAsDouble());
        Assertions.assertTrue((this.yoDouble1.getValueAsDouble() == this.yoDouble2.getValueAsDouble() ? 1 : 0) != 0);
    }

    @Test
    public void testSetFinal() {
        this.yoDouble1.set(0.0);
        this.yoDouble1.set(0.0);
        this.yoDouble1.set(10.0);
        Assertions.assertEquals((double)10.0, (double)this.yoDouble1.getDoubleValue(), (double)1.0E-10);
    }

    @Test
    public void testGetYoVariableType() {
        Assertions.assertTrue((this.yoDouble1.getType() == YoVariableType.DOUBLE ? 1 : 0) != 0);
    }

    @Test
    public void testDuplicate() {
        String newName = "registry2000";
        double value = this.random.nextDouble();
        this.yoDouble2.set(value);
        YoRegistry newRegistry = new YoRegistry(newName);
        YoDouble duplicate = this.yoDouble2.duplicate(newRegistry);
        Assertions.assertEquals((double)this.yoDouble2.getDoubleValue(), (double)duplicate.getDoubleValue(), (double)1.0E-10);
    }

    @Test
    public void testProviderValue() {
        this.yoDouble1.set(1.2509481E7);
        this.yoDouble2.set(2358.0);
        Assertions.assertEquals((double)this.yoDouble1.getDoubleValue(), (double)this.yoDouble1.getValue(), (double)1.0E-9);
        Assertions.assertEquals((double)this.yoDouble2.getDoubleValue(), (double)this.yoDouble2.getValue(), (double)1.0E-9);
    }
}

