/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.registry;

import java.io.OutputStream;
import java.io.PrintStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.exceptions.IllegalNameException;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoToolsTest {
    @Test
    public void testIllegalCharacters() {
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc`abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc~abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc!abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc@abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc#abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc$abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc%abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc^abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc&abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc*abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc(abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc)abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc=abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc+abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc{abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc}abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc|abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc\\abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc'abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc\"abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc,abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc.abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc?abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc:abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc;abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc<abc"));
        Assertions.assertThrows(IllegalNameException.class, () -> YoTools.checkForIllegalCharacters((String)"abc>abc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abcabc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abc_abc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abc-abc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abc0abc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abc1abc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abc2abc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abc3abc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abc4abc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abc5abc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abc6abc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abc7abc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abc8abc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abc9abc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abcAabc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abc[abc"));
        Assertions.assertDoesNotThrow(() -> YoTools.checkForIllegalCharacters((String)"abc]abc"));
    }

    @Test
    public void testPrintSizeRecursively() {
        YoRegistry rootRegistry = new YoRegistry("rootRegistry");
        int numberOfFirstLevelChildRegistries = 2;
        int numberOfFirstLevelYoVariables = 1;
        int numberOfSecondLevelChildRegistries = 1;
        int numberOfSecondLevelYoVariables = 4;
        int numberOfThirdLevelChildRegistries = 1;
        int numberOfThirdLevelYoVariables = 1;
        int totalNumberOfYoVariables = numberOfFirstLevelChildRegistries * (numberOfFirstLevelYoVariables + numberOfSecondLevelChildRegistries * (numberOfSecondLevelYoVariables + numberOfThirdLevelChildRegistries * numberOfThirdLevelYoVariables));
        for (int i = 0; i < numberOfFirstLevelChildRegistries; ++i) {
            YoRegistry firstLevelChild = new YoRegistry("firstLevelChild_" + i);
            this.registerYoDoubles(firstLevelChild, numberOfFirstLevelYoVariables);
            rootRegistry.addChild(firstLevelChild);
            for (int j = 0; j < numberOfSecondLevelChildRegistries; ++j) {
                YoRegistry secondLevelChild = new YoRegistry("secondLevelChild_" + j);
                this.registerYoDoubles(secondLevelChild, numberOfSecondLevelYoVariables);
                firstLevelChild.addChild(secondLevelChild);
                for (int k = 0; k < numberOfThirdLevelChildRegistries; ++k) {
                    YoRegistry thirdLevelChild = new YoRegistry("thirdLevelChild_" + k);
                    this.registerYoDoubles(thirdLevelChild, numberOfThirdLevelYoVariables);
                    secondLevelChild.addChild(thirdLevelChild);
                }
            }
        }
        Interceptor interceptor = new Interceptor(System.out);
        System.setOut(interceptor);
        int minimumVariablesToPrint = 2;
        int minimumChildrenToPrint = 2;
        YoTools.printStatistics((int)minimumVariablesToPrint, (int)minimumChildrenToPrint, (YoRegistry)rootRegistry);
        String[] strings = interceptor.getBuffer();
        Assertions.assertTrue((strings.length != 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)strings[1].contains(String.valueOf(totalNumberOfYoVariables)));
        Assertions.assertTrue((boolean)strings[3].contains("firstLevelChild_0.secondLevelChild_0"));
        Assertions.assertTrue((boolean)strings[3].contains("Variables: " + numberOfSecondLevelYoVariables));
        Assertions.assertTrue((boolean)strings[3].contains("Children: " + numberOfSecondLevelChildRegistries));
        Assertions.assertTrue((boolean)strings[4].contains("firstLevelChild_1.secondLevelChild_0"));
        Assertions.assertTrue((boolean)strings[4].contains("Variables: " + numberOfSecondLevelYoVariables));
        Assertions.assertTrue((boolean)strings[4].contains("Children: " + numberOfSecondLevelChildRegistries));
        Assertions.assertTrue((boolean)strings[5].contains("rootRegistry"));
        Assertions.assertTrue((boolean)strings[5].contains("Variables: 0"));
        Assertions.assertTrue((boolean)strings[5].contains("Children: " + numberOfFirstLevelChildRegistries));
    }

    private void registerYoDoubles(YoRegistry registry, int numberOfYoDoublesToRegister) {
        for (int i = 0; i < numberOfYoDoublesToRegister; ++i) {
            new YoDouble("yoDouble_" + i, registry);
        }
    }

    private class Interceptor
    extends PrintStream {
        private final StringBuffer buffer;

        public Interceptor(OutputStream out) {
            super(out);
            this.buffer = new StringBuffer();
        }

        @Override
        public void print(String s) {
            this.buffer.append(s);
        }

        @Override
        public void println(String s) {
            this.print(s + "\n");
        }

        public String[] getBuffer() {
            return this.buffer.toString().split("\n");
        }
    }
}

