/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.listener.YoParameterChangedListener;
import us.ihmc.yoVariables.parameters.EnumParameter;
import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;

public class EnumParameterTest {
    private static final TestEnum initialValue = TestEnum.D;

    public EnumParameter<TestEnum> createParameterWithNamespace() {
        YoRegistry root = new YoRegistry("root");
        YoRegistry a = new YoRegistry("a");
        YoRegistry b = new YoRegistry("b");
        YoRegistry c = new YoRegistry("c");
        root.addChild(a);
        a.addChild(b);
        b.addChild(c);
        EnumParameter param = new EnumParameter("param", "paramDescription", c, TestEnum.class, true, (Enum)initialValue);
        return param;
    }

    @Test
    public void testLoadNullValue() {
        YoRegistry dummy = new YoRegistry("dummy");
        EnumParameter yesnull = new EnumParameter("yesnull", dummy, TestEnum.class, true, (Enum)initialValue);
        yesnull.load("NULL");
        Assertions.assertEquals(null, (Object)yesnull.getValue());
    }

    @Test
    public void testDuplicate() {
        EnumParameter<TestEnum> param = this.createParameterWithNamespace();
        YoEnum var = (YoEnum)param.getVariable();
        param.loadDefault();
        var.set((Enum)TestEnum.E);
        YoRegistry newRegistry = new YoRegistry("newRegistry");
        YoEnum newVar = var.duplicate(newRegistry);
        EnumParameter newParam = (EnumParameter)newVar.getParameter();
        Assertions.assertEquals((Object)param.getName(), (Object)newParam.getName());
        Assertions.assertEquals((Object)param.getDescription(), (Object)newParam.getDescription());
        Assertions.assertEquals((Object)param.getValue(), (Object)newParam.getValue());
        Assertions.assertEquals((Object)var.isNullAllowed(), (Object)newVar.isNullAllowed());
        Assertions.assertArrayEquals((Object[])var.getEnumValues(), (Object[])newVar.getEnumValues());
    }

    @Test
    public void testStringDuplicate() {
        YoRegistry root = new YoRegistry("root");
        EnumParameter param = new EnumParameter("testString", "stringDescription", root, true, new String[]{"A", "B", "C", "D", "E", "F"});
        YoEnum var = (YoEnum)param.getVariable();
        param.loadDefault();
        var.set(4);
        YoRegistry newRegistry = new YoRegistry("newRegistry");
        YoEnum newVar = var.duplicate(newRegistry);
        EnumParameter newParam = (EnumParameter)newVar.getParameter();
        Assertions.assertEquals((Object)param.getName(), (Object)newParam.getName());
        Assertions.assertEquals((Object)param.getDescription(), (Object)newParam.getDescription());
        Assertions.assertEquals((Object)param.getValueAsString(), (Object)newParam.getValueAsString());
        Assertions.assertEquals((Object)var.isBackedByEnum(), (Object)newVar.isBackedByEnum());
        Assertions.assertEquals((Object)var.isNullAllowed(), (Object)newVar.isNullAllowed());
        Assertions.assertArrayEquals((Object[])var.getEnumValuesAsString(), (Object[])newVar.getEnumValuesAsString());
    }

    @Test
    public void testDisallowNullLoadValue() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            YoRegistry dummy = new YoRegistry("dummy");
            EnumParameter nonull = new EnumParameter("nonull", dummy, TestEnum.class, false, (Enum)initialValue);
            nonull.load("null");
        });
    }

    @Test
    public void testDisallowNullConstructValue() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            YoRegistry dummy = new YoRegistry("dummy");
            new EnumParameter("nonull", dummy, TestEnum.class, false, null);
        });
    }

    @Test
    public void testConstructDefaultValue() {
        YoRegistry dummy = new YoRegistry("dummy");
        EnumParameter nonull = new EnumParameter("nonull", dummy, TestEnum.class, false);
        EnumParameter yesnull = new EnumParameter("yesnull", dummy, TestEnum.class, true);
        nonull.loadDefault();
        yesnull.loadDefault();
        Assertions.assertEquals((Object)((Object)TestEnum.A), (Object)nonull.getValue());
        Assertions.assertEquals(null, (Object)yesnull.getValue());
    }

    @Test
    public void testGetNamespace() {
        EnumParameter<TestEnum> param = this.createParameterWithNamespace();
        Assertions.assertEquals((Object)"root.a.b.c", (Object)param.getNamespace().toString());
        Assertions.assertEquals((Object)"param", (Object)param.getName());
    }

    @Test
    public void testLoadFromString() {
        for (TestEnum element : TestEnum.values()) {
            YoRegistry dummy = new YoRegistry("dummy");
            EnumParameter param = new EnumParameter("test", dummy, TestEnum.class, true, null);
            String stringValue = element.toString();
            param.load(stringValue);
            Assertions.assertEquals((Object)((Object)TestEnum.valueOf(stringValue)), (Object)param.getValue());
            Assertions.assertEquals((Object)stringValue, (Object)param.getValueAsString());
        }
    }

    @Test
    public void testGetBeforeLoad() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            EnumParameter<TestEnum> param = this.createParameterWithNamespace();
            param.getValue();
        });
    }

    @Test
    public void testDefault() {
        EnumParameter<TestEnum> param = this.createParameterWithNamespace();
        param.loadDefault();
        Assertions.assertEquals((Object)((Object)initialValue), (Object)param.getValue());
    }

    @Test
    public void testListener() {
        EnumParameter<TestEnum> param = this.createParameterWithNamespace();
        CallbackTest callback = new CallbackTest();
        param.addListener((YoParameterChangedListener)callback);
        Assertions.assertFalse((boolean)callback.set);
        param.loadDefault();
        callback.set = false;
        param.getVariable().setValueFromDouble(param.getVariable().getValueAsDouble());
        Assertions.assertFalse((boolean)callback.set);
        param.getVariable().setValueFromDouble((double)TestEnum.K.ordinal());
        Assertions.assertTrue((boolean)callback.set);
    }

    @Test
    public void testStringBased() {
        String[] constants = new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};
        YoRegistry registry = new YoRegistry("test");
        EnumParameter nullDefault = new EnumParameter("nullDefault", "", registry, true, constants);
        nullDefault.loadDefault();
        Assertions.assertEquals((Object)"null", (Object)nullDefault.getValueAsString());
        EnumParameter constantDefault = new EnumParameter("constantDefault", "", registry, false, constants);
        constantDefault.loadDefault();
        Assertions.assertEquals((Object)"A", (Object)constantDefault.getValueAsString());
        for (String c : constants) {
            constantDefault.setToString(c);
            Assertions.assertEquals((Object)c, (Object)constantDefault.getValueAsString());
        }
        nullDefault.setToString("A");
        Assertions.assertEquals((Object)"A", (Object)nullDefault.getValueAsString());
        nullDefault.setToString("NULL");
        Assertions.assertEquals((Object)"null", (Object)nullDefault.getValueAsString());
    }

    @Test
    public void testStringBasedAccess() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            String[] constants = new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};
            YoRegistry registry = new YoRegistry("test");
            EnumParameter nullDefault = new EnumParameter("nullDefault", "", registry, true, constants);
            nullDefault.loadDefault();
            nullDefault.getValue();
        });
    }

    @Test
    public void testStringBasedAccessSetNull() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            String[] constants = new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};
            YoRegistry registry = new YoRegistry("test");
            EnumParameter constantDefault = new EnumParameter("constantDefault", "", registry, false, constants);
            constantDefault.loadDefault();
            constantDefault.setToString("null");
        });
    }

    @Test
    public void testStringBasedAccessSetNonExistant() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            String[] constants = new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};
            YoRegistry registry = new YoRegistry("test");
            EnumParameter constantDefault = new EnumParameter("constantDefault", "", registry, false, constants);
            constantDefault.loadDefault();
            constantDefault.setToString("NONEXISTANT");
        });
    }

    @Test
    public void testStringBasedAccessNullValueConstant() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            String[] constants = new String[]{"A", "B", "C", "NuLl", "E", "F", "G", "H"};
            YoRegistry registry = new YoRegistry("test");
            new EnumParameter("constantDefault", "", registry, false, constants);
        });
    }

    @Test
    public void testStringBasedAccessNullConstant() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            String[] constants = new String[]{"A", "B", "C", null, "E", "F", "G", "H"};
            YoRegistry registry = new YoRegistry("test");
            new EnumParameter("constantDefault", "", registry, false, constants);
        });
    }

    @Test
    public void testStringBasedAccessEmptyConstantListNotNull() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            String[] constants = new String[]{};
            YoRegistry registry = new YoRegistry("test");
            new EnumParameter("constantDefault", "", registry, false, constants);
        });
    }

    @Test
    public void testStringBasedAccessEmptyConstantList() {
        String[] constants = new String[]{};
        YoRegistry registry = new YoRegistry("test");
        EnumParameter nullDefault = new EnumParameter("nullDefault", "", registry, true, constants);
        nullDefault.loadDefault();
        Assertions.assertEquals((Object)"null", (Object)nullDefault.getValueAsString());
    }

    private static enum TestEnum {
        A,
        B,
        C,
        D,
        E,
        F,
        G,
        H,
        I,
        J,
        K,
        L,
        M;

    }

    private class CallbackTest
    implements YoParameterChangedListener {
        boolean set = false;

        private CallbackTest() {
        }

        public void changed(YoParameter v) {
            this.set = true;
        }
    }
}

