/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.listener.YoParameterChangedListener;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class BooleanParameterTest {
    private static final boolean initialValue = true;

    public BooleanParameter createParameterWithNamespace() {
        YoRegistry root = new YoRegistry("root");
        YoRegistry a = new YoRegistry("a");
        YoRegistry b = new YoRegistry("b");
        YoRegistry c = new YoRegistry("c");
        root.addChild(a);
        a.addChild(b);
        b.addChild(c);
        BooleanParameter param = new BooleanParameter("param", "paramDescription", c, true);
        return param;
    }

    @Test
    public void testGetNamespace() {
        BooleanParameter param = this.createParameterWithNamespace();
        Assertions.assertEquals((Object)"root.a.b.c", (Object)param.getNamespace().toString());
        Assertions.assertEquals((Object)"param", (Object)param.getName());
    }

    @Test
    public void testGetBeforeLoad() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            BooleanParameter param = this.createParameterWithNamespace();
            param.getValue();
        });
    }

    @Test
    public void testLoadFromString() {
        String[] options = new String[]{"false", "true", "FALSE", "TRUE", "False", "True"};
        for (int i = 0; i < options.length; ++i) {
            YoRegistry dummy = new YoRegistry("dummy");
            BooleanParameter param = new BooleanParameter("test", dummy);
            param.load(options[i]);
            Assertions.assertEquals((Object)(i % 2 == 1 ? 1 : 0), (Object)param.getValue());
            Assertions.assertEquals((Object)options[i].toLowerCase(), (Object)param.getValueAsString());
        }
    }

    @Test
    public void testDefault() {
        BooleanParameter param = this.createParameterWithNamespace();
        param.loadDefault();
        Assertions.assertEquals((Object)true, (Object)param.getValue());
    }

    @Test
    public void testDuplicate() {
        BooleanParameter param = this.createParameterWithNamespace();
        YoBoolean var = param.getVariable();
        param.loadDefault();
        var.set(true);
        YoRegistry newRegistry = new YoRegistry("newRegistry");
        YoBoolean newVar = var.duplicate(newRegistry);
        BooleanParameter newParam = (BooleanParameter)newVar.getParameter();
        Assertions.assertEquals((Object)param.getName(), (Object)newParam.getName());
        Assertions.assertEquals((Object)param.getDescription(), (Object)newParam.getDescription());
        Assertions.assertEquals((Object)param.getValue(), (Object)newParam.getValue());
    }

    @Test
    public void testListener() {
        BooleanParameter param = this.createParameterWithNamespace();
        CallbackTest callback = new CallbackTest();
        param.addListener((YoParameterChangedListener)callback);
        Assertions.assertFalse((boolean)callback.set);
        param.loadDefault();
        callback.set = false;
        param.getVariable().setValueFromDouble(param.getVariable().getValueAsDouble());
        Assertions.assertFalse((boolean)callback.set);
        param.getVariable().setValueFromDouble(0.0);
        Assertions.assertTrue((boolean)callback.set);
    }

    private class CallbackTest
    implements YoParameterChangedListener {
        boolean set = false;

        private CallbackTest() {
        }

        public void changed(YoParameter v) {
            this.set = true;
        }
    }
}

