/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.filters.DelayedYoBoolean;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class DelayedYoBooleanTest {
    private static YoRegistry registry;
    private static YoBoolean variableToDelay;
    private static Boolean DEBUG;
    private int ticksToDelay;

    @BeforeEach
    public void setUp() {
        registry = new YoRegistry("registry");
        variableToDelay = new YoBoolean("variableToDelay", registry);
    }

    @AfterEach
    public void tearDown() {
        registry = null;
        variableToDelay = null;
    }

    @Test
    public void testDelayedYoVariableMultipleTickDelays() {
        this.ticksToDelay = 0;
        while (this.ticksToDelay < 10) {
            int i;
            variableToDelay.set(true);
            DelayedYoBoolean delayedYoVariable = new DelayedYoBoolean("delayedVariable" + this.ticksToDelay, "", variableToDelay, this.ticksToDelay, registry);
            int ticksToTest = 100;
            boolean[] valuesToSet = new boolean[ticksToTest];
            for (i = 0; i < valuesToSet.length; ++i) {
                valuesToSet[i] = Math.random() < 0.5;
            }
            Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)true);
            for (i = 0; i < ticksToTest; ++i) {
                variableToDelay.set(valuesToSet[i]);
                delayedYoVariable.update();
                if (i < this.ticksToDelay) {
                    Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)true);
                    continue;
                }
                Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)valuesToSet[i - this.ticksToDelay]);
            }
            ++this.ticksToDelay;
        }
    }

    @Test
    public void testDelayedYoVariableOneTickDelay() {
        this.ticksToDelay = 1;
        variableToDelay.set(false);
        DelayedYoBoolean delayedYoVariable = new DelayedYoBoolean("delayedVariable" + this.ticksToDelay, "", variableToDelay, this.ticksToDelay, registry);
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)false);
        variableToDelay.set(true);
        delayedYoVariable.update();
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)false);
        variableToDelay.set(false);
        delayedYoVariable.update();
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)true);
        variableToDelay.set(true);
        delayedYoVariable.update();
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)false);
        delayedYoVariable.update();
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)true);
        delayedYoVariable.update();
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)true);
        delayedYoVariable.update();
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)true);
    }

    @Test
    public void testDelayedYoVariableZeroTickDelay() {
        this.ticksToDelay = 0;
        variableToDelay.set(false);
        DelayedYoBoolean delayedYoVariable = new DelayedYoBoolean("delayedVariable" + this.ticksToDelay, "", variableToDelay, this.ticksToDelay, registry);
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)false);
        variableToDelay.set(true);
        delayedYoVariable.update();
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)true);
        variableToDelay.set(false);
        delayedYoVariable.update();
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)false);
        variableToDelay.set(true);
        delayedYoVariable.update();
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)true);
        delayedYoVariable.update();
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)true);
        delayedYoVariable.update();
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)true);
        delayedYoVariable.update();
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)true);
    }

    @Test
    public void testUpdateWithZero() {
        this.ticksToDelay = 0;
        variableToDelay.set(false);
        DelayedYoBoolean delayedYoVariable = new DelayedYoBoolean("delayedVariable" + this.ticksToDelay, "", variableToDelay, this.ticksToDelay, registry);
        delayedYoVariable.getInternalState("Should be all false", DEBUG);
        variableToDelay.set(true);
        delayedYoVariable.update();
        delayedYoVariable.getInternalState("Should be all true", DEBUG);
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)true);
        delayedYoVariable.update();
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)true);
    }

    @Test
    public void testReset() {
        int i;
        this.ticksToDelay = 10;
        variableToDelay.set(false);
        DelayedYoBoolean delayedYoVariable = new DelayedYoBoolean("delayedVariable" + this.ticksToDelay, "", variableToDelay, this.ticksToDelay, registry);
        for (i = 0; i < this.ticksToDelay; ++i) {
            Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)false);
            delayedYoVariable.update();
        }
        delayedYoVariable.getInternalState("Should be all false", DEBUG);
        variableToDelay.set(true);
        delayedYoVariable.update();
        for (i = 0; i < this.ticksToDelay; ++i) {
            Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)false);
            delayedYoVariable.update();
        }
        Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)true);
        variableToDelay.set(false);
        delayedYoVariable.update();
        delayedYoVariable.getInternalState("Should be all true, except for the end", DEBUG);
        delayedYoVariable.reset();
        delayedYoVariable.update();
        for (i = 0; i < this.ticksToDelay; ++i) {
            Assertions.assertEquals((Object)delayedYoVariable.getBooleanValue(), (Object)false);
            delayedYoVariable.update();
        }
        delayedYoVariable.getInternalState("Should be all false", DEBUG);
    }

    static {
        DEBUG = false;
    }
}

