/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.yoVariables.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.filters.BacklashCompensatingVelocityYoVariable;
import us.ihmc.yoVariables.filters.BacklashProcessingYoVariable;
import us.ihmc.yoVariables.filters.FilteredFiniteDifferenceYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class BacklashProcessingYoVariableTest {
    @Test
    public void testAgainstRevisedBacklash() {
        YoRegistry registry = new YoRegistry("dummy");
        YoDouble slopTime = new YoDouble("slopTime", registry);
        double dt = 0.002;
        YoDouble alpha = new YoDouble("alpha", registry);
        alpha.set(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)16.0, (double)dt));
        YoDouble positionVariable = new YoDouble("rawPosition", registry);
        FilteredFiniteDifferenceYoVariable velocityVariable = new FilteredFiniteDifferenceYoVariable("fd", "", (DoubleProvider)alpha, (DoubleProvider)positionVariable, dt, registry);
        BacklashProcessingYoVariable blToTest = new BacklashProcessingYoVariable("blTest", "", (YoDouble)velocityVariable, dt, (DoubleProvider)slopTime, registry);
        BacklashCompensatingVelocityYoVariable blExpected = new BacklashCompensatingVelocityYoVariable("blExpected", "", (DoubleProvider)alpha, (DoubleProvider)positionVariable, dt, (DoubleProvider)slopTime, registry);
        Random random = new Random(561651L);
        for (double t = 0.0; t < 100.0; t += dt) {
            positionVariable.set(2.0 * Math.sin(62.83185307179586) + RandomNumbers.nextDouble((Random)random, (double)1.0) * Math.sin(190.58995431778078));
            velocityVariable.update();
            blToTest.update();
            blExpected.update();
            Assertions.assertEquals((double)blToTest.getDoubleValue(), (double)blExpected.getDoubleValue(), (double)1.0E-10);
        }
    }
}

