/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class AlphaFilteredYoVariableTest {
    private final Random rng = new Random();

    @Test
    public void testNoisyFixedPosition() {
        double alpha = 0.8;
        YoRegistry registry = new YoRegistry("testRegistry");
        YoDouble positionVariable = new YoDouble("positionVariable", registry);
        AlphaFilteredYoVariable alphaFilteredYoVariable = new AlphaFilteredYoVariable("alphaFilteredYoVariable", registry, alpha, positionVariable);
        double pseudoNoise = 0.0;
        positionVariable.set(10.0);
        for (int i = 0; i < 10000; ++i) {
            if (i % 2 == 0) {
                pseudoNoise = this.rng.nextDouble();
            }
            positionVariable.add(Math.pow(-1.0, i) * pseudoNoise);
            alphaFilteredYoVariable.update();
        }
        Assertions.assertEquals((double)10.0, (double)alphaFilteredYoVariable.getDoubleValue(), (double)1.0);
    }

    @Test
    public void testAlphaAndBreakFrequencyComputations() {
        for (int i = 0; i < 1000; ++i) {
            double dt = this.rng.nextDouble();
            double expectedAlpha = this.rng.nextDouble();
            double breakFrequency = AlphaFilteredYoVariable.computeBreakFrequencyGivenAlpha((double)expectedAlpha, (double)dt);
            double actualAlpha = AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)breakFrequency, (double)dt);
            Assertions.assertEquals((double)expectedAlpha, (double)actualAlpha, (double)1.0E-10);
            double maxFrequency = 0.25 / dt;
            double expectedBreakFrequency = maxFrequency * this.rng.nextDouble();
            double alpha = AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)expectedBreakFrequency, (double)dt);
            double actualBreakFrequency = AlphaFilteredYoVariable.computeBreakFrequencyGivenAlpha((double)alpha, (double)dt);
            Assertions.assertEquals((double)expectedBreakFrequency, (double)actualBreakFrequency, (double)1.0E-7);
        }
    }
}

