/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.filters;

import java.util.Random;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.yoVariables.euclid.filters.AlphaFilteredYoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class AlphaFilteredYoFrameQuaternionTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testInitialValue() {
        MutableDouble alpha = new MutableDouble();
        AlphaFilteredYoFrameQuaternion q = this.createAlphaFilteredYoFrameQuaternion(() -> alpha.doubleValue());
        Random random = new Random(12351235L);
        Quaternion qMeasured = EuclidCoreRandomTools.nextQuaternion((Random)random);
        q.getUnfilteredQuaternion().set((QuaternionReadOnly)qMeasured);
        q.update();
        Quaternion qFiltered = new Quaternion((QuaternionReadOnly)q);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)qMeasured, (EuclidGeometry)qFiltered, (double)1.0E-12);
    }

    @Test
    public void testAlpha1() {
        MutableDouble alpha = new MutableDouble();
        AlphaFilteredYoFrameQuaternion q = this.createAlphaFilteredYoFrameQuaternion(() -> alpha.doubleValue());
        alpha.setValue(1.0);
        Random random = new Random(73464L);
        Quaternion qInitial = EuclidCoreRandomTools.nextQuaternion((Random)random);
        q.getUnfilteredQuaternion().set((QuaternionReadOnly)qInitial);
        q.update();
        int nUpdates = 100;
        this.doRandomUpdates(q, random, nUpdates);
        Quaternion qFiltered = new Quaternion((QuaternionReadOnly)q);
        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)qInitial, (Orientation3DReadOnly)qFiltered, (double)1.0E-12);
    }

    @Test
    public void testAlpha0() {
        MutableDouble alpha = new MutableDouble();
        AlphaFilteredYoFrameQuaternion q = this.createAlphaFilteredYoFrameQuaternion(() -> alpha.doubleValue());
        alpha.setValue(0.0);
        Random random = new Random(12525123L);
        int nUpdates = 100;
        this.doRandomUpdates(q, random, nUpdates);
        Quaternion qFinal = EuclidCoreRandomTools.nextQuaternion((Random)random);
        q.getUnfilteredQuaternion().set((QuaternionReadOnly)qFinal);
        q.update();
        Quaternion qFiltered = new Quaternion((QuaternionReadOnly)q);
        EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)qFinal, (Orientation3DReadOnly)qFiltered, (double)1.0E-12);
    }

    @Test
    public void testStepChange() {
        MutableDouble alpha = new MutableDouble();
        AlphaFilteredYoFrameQuaternion q = this.createAlphaFilteredYoFrameQuaternion(() -> alpha.doubleValue());
        alpha.setValue(0.5);
        Random random = new Random(12525123L);
        Quaternion qInitial = EuclidCoreRandomTools.nextQuaternion((Random)random);
        q.getUnfilteredQuaternion().set((QuaternionReadOnly)qInitial);
        q.update();
        Quaternion qFinal = EuclidCoreRandomTools.nextQuaternion((Random)random);
        q.getUnfilteredQuaternion().set((QuaternionReadOnly)qFinal);
        double angleDifference = AlphaFilteredYoFrameQuaternionTest.getAngleDifference(qInitial, qFinal);
        double epsilon = 0.001;
        int nUpdates = 100;
        Quaternion qFiltered = new Quaternion();
        for (int i = 0; i < nUpdates; ++i) {
            q.update();
            qFiltered.set((QuaternionReadOnly)q);
            double newAngleDifference = AlphaFilteredYoFrameQuaternionTest.getAngleDifference(qFiltered, qFinal);
            boolean sameQuaternion = newAngleDifference == 0.0;
            Assertions.assertTrue((sameQuaternion || newAngleDifference < (1.0 + epsilon) * alpha.doubleValue() * angleDifference ? 1 : 0) != 0);
            angleDifference = newAngleDifference;
        }
    }

    private void doRandomUpdates(AlphaFilteredYoFrameQuaternion q, Random random, int nUpdates) {
        for (int i = 0; i < nUpdates; ++i) {
            Quaternion qMeasured = EuclidCoreRandomTools.nextQuaternion((Random)random);
            q.getUnfilteredQuaternion().set((QuaternionReadOnly)qMeasured);
            q.update();
        }
    }

    private AlphaFilteredYoFrameQuaternion createAlphaFilteredYoFrameQuaternion(DoubleProvider alpha) {
        YoRegistry registry = new YoRegistry("test");
        ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
        YoFrameQuaternion unfilteredQuaternion = new YoFrameQuaternion("qMeasured", referenceFrame, registry);
        AlphaFilteredYoFrameQuaternion q = new AlphaFilteredYoFrameQuaternion("qFiltered", "", unfilteredQuaternion, alpha, registry);
        return q;
    }

    private static double getAngleDifference(Quaternion q1, Quaternion q2) {
        Quaternion qDifference = new Quaternion((QuaternionReadOnly)q1);
        qDifference.multiplyConjugateOther((QuaternionReadOnly)q2);
        AxisAngle axisAngle = new AxisAngle();
        axisAngle.set((Orientation3DReadOnly)qDifference);
        return axisAngle.getAngle();
    }
}

