/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.filters.MovingAverageYoDouble;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class MovingAverageYoDoubleTest {
    private final Random rng = new Random();

    @Test
    public void testBetaFilteredYoVariable() {
        int beta = 5000;
        double pseudoNoise = 0.0;
        YoRegistry registry = new YoRegistry("testRegistry");
        YoDouble positionVariable = new YoDouble("positionVariable", registry);
        MovingAverageYoDouble betaFilteredYoVariable = new MovingAverageYoDouble("betaFilteredYoVariable", registry, beta, positionVariable);
        positionVariable.set(10.0);
        for (int i = 0; i < 10000; ++i) {
            if (i % 2 == 0) {
                pseudoNoise = this.rng.nextDouble();
            }
            positionVariable.add(Math.pow(-1.0, i) * pseudoNoise);
            betaFilteredYoVariable.update();
        }
        Assertions.assertEquals((double)10.0, (double)betaFilteredYoVariable.getDoubleValue(), (double)1.0);
    }

    @Test
    public void testTrueMovingAverage() {
        int beta = 10;
        YoRegistry registry = new YoRegistry("testRegistry");
        MovingAverageYoDouble betaFilteredYoVariable = new MovingAverageYoDouble("betaFilteredYoVariable", registry, beta);
        double epsilon = 1.0E-10;
        betaFilteredYoVariable.update(1.0);
        Assertions.assertEquals((double)1.0, (double)betaFilteredYoVariable.getDoubleValue(), (double)epsilon);
        betaFilteredYoVariable.update(2.0);
        Assertions.assertEquals((double)1.5, (double)betaFilteredYoVariable.getDoubleValue(), (double)epsilon);
        betaFilteredYoVariable.update(3.0);
        betaFilteredYoVariable.update(4.0);
        betaFilteredYoVariable.update(5.0);
        betaFilteredYoVariable.update(6.0);
        betaFilteredYoVariable.update(7.0);
        betaFilteredYoVariable.update(8.0);
        betaFilteredYoVariable.update(9.0);
        betaFilteredYoVariable.update(10.0);
        Assertions.assertEquals((double)5.5, (double)betaFilteredYoVariable.getDoubleValue(), (double)epsilon);
    }
}

