/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.filters;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.filters.FilteredDiscreteVelocityYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class FilteredDiscreteVelocityYoVariableTest {
    private static final double DT = 0.1;

    @Test
    public void testFilteredDiscreteVelocityNoDirectionChange() {
        double alpha = 0.99;
        YoRegistry registry = new YoRegistry("testRegistry");
        YoDouble positionVariable = new YoDouble("positionVariable", registry);
        YoDouble time = new YoDouble("time", registry);
        FilteredDiscreteVelocityYoVariable filteredDiscreteVelocityYoVariable = new FilteredDiscreteVelocityYoVariable("filteredDiscreteVelocityYoVariable", "", alpha, positionVariable, time, registry);
        positionVariable.set(10.0);
        time.set(0.0);
        int i = 0;
        while ((double)i < 10000.0) {
            time.add(0.1);
            positionVariable.add(1.0);
            filteredDiscreteVelocityYoVariable.update();
            ++i;
        }
        Assertions.assertEquals((double)10.0, (double)filteredDiscreteVelocityYoVariable.getDoubleValue(), (double)1.0E-7);
    }

    @Test
    public void testFilteredDiscreteVelocityWithDirectionChange() {
        double alpha = 0.99;
        YoRegistry registry = new YoRegistry("testRegistry");
        YoDouble positionVariable = new YoDouble("positionVariable", registry);
        YoDouble time = new YoDouble("time", registry);
        FilteredDiscreteVelocityYoVariable filteredDiscreteVelocityYoVariable = new FilteredDiscreteVelocityYoVariable("filteredDiscreteVelocityYoVariable", "", alpha, positionVariable, time, registry);
        positionVariable.set(10.0);
        time.set(0.0);
        int i = 0;
        while ((double)i < 10000.0) {
            time.add(0.1);
            positionVariable.add(1.0);
            filteredDiscreteVelocityYoVariable.update();
            ++i;
        }
        Assertions.assertEquals((double)10.0, (double)filteredDiscreteVelocityYoVariable.getDoubleValue(), (double)1.0E-7);
        i = 0;
        while ((double)i < 10000.0) {
            time.add(0.1);
            positionVariable.add(-1.0);
            filteredDiscreteVelocityYoVariable.update();
            ++i;
        }
        Assertions.assertEquals((double)-10.0, (double)filteredDiscreteVelocityYoVariable.getDoubleValue(), (double)1.0E-7);
    }
}

