/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.filters;

import java.util.Random;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.yoVariables.euclid.filters.RunningAverageYoFrameVector3D;

public class RunningAverageYoFrameVector3DTest {
    @Test
    public void testAgainstApacheMean() {
        Random random = new Random(1L);
        RunningAverageYoFrameVector3D yoAverage = new RunningAverageYoFrameVector3D("", ReferenceFrame.getWorldFrame(), null);
        Mean meanX = new Mean();
        Mean meanY = new Mean();
        Mean meanZ = new Mean();
        double nextX = -10.0;
        double nextY = -10.0;
        double nextZ = -10.0;
        for (int i = 0; i < 1000; ++i) {
            yoAverage.update(nextX += random.nextDouble(), nextY += random.nextDouble(), nextZ += random.nextDouble());
            meanX.increment(nextX);
            meanY.increment(nextY);
            meanZ.increment(nextZ);
            Assertions.assertEquals((double)meanX.getResult(), (double)yoAverage.getX());
            Assertions.assertEquals((double)meanY.getResult(), (double)yoAverage.getY());
            Assertions.assertEquals((double)meanZ.getResult(), (double)yoAverage.getZ());
            Assertions.assertEquals((long)meanX.getN(), (long)yoAverage.getSampleSize());
            Assertions.assertEquals((long)meanY.getN(), (long)yoAverage.getSampleSize());
            Assertions.assertEquals((long)meanZ.getN(), (long)yoAverage.getSampleSize());
        }
    }
}

