/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.filters;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Tuple3DBasicsTest;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.yoVariables.euclid.filters.AlphaFilteredTuple3D;

public class AlphaFilteredTuple3DTest
extends Tuple3DBasicsTest<AlphaFilteredTuple3D> {
    private double alpha;

    @Test
    public void testFirstSet() {
        double alpha = 0.0;
        AlphaFilteredTuple3D tuple = new AlphaFilteredTuple3D(() -> alpha);
        tuple.set(0.0, 1.0, 2.0);
        Assertions.assertEquals((double)0.0, (double)tuple.getX(), (double)this.getEpsilon());
        Assertions.assertEquals((double)1.0, (double)tuple.getY(), (double)this.getEpsilon());
        Assertions.assertEquals((double)2.0, (double)tuple.getZ(), (double)this.getEpsilon());
    }

    @Test
    public void testFilteredSetters() {
        Random random = new Random(12951L);
        for (int i = 0; i < 1000; ++i) {
            this.alpha = random.nextDouble(0.0, 1.0);
            AlphaFilteredTuple3D tuple = this.createRandomTuple(random);
            double originalX = tuple.getX();
            double originalY = tuple.getY();
            double originalZ = tuple.getZ();
            Point3D point = new Point3D((Tuple3DReadOnly)this.createRandomTuple(random));
            tuple.setX(point.getX());
            tuple.setY(point.getY());
            tuple.setZ(point.getZ());
            double expectedX = (1.0 - this.alpha) * point.getX() + this.alpha * originalX;
            double expectedY = (1.0 - this.alpha) * point.getY() + this.alpha * originalY;
            double expectedZ = (1.0 - this.alpha) * point.getZ() + this.alpha * originalZ;
            Assertions.assertEquals((double)expectedX, (double)tuple.getX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedY, (double)tuple.getY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedZ, (double)tuple.getZ(), (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetOther() {
        Random random = new Random(621541L);
        for (int i = 0; i < 1000; ++i) {
            this.alpha = random.nextDouble(0.0, 1.0);
            AlphaFilteredTuple3D tuple = this.createRandomTuple(random);
            double originalX = tuple.getX();
            double originalY = tuple.getY();
            double originalZ = tuple.getZ();
            Point3D point = new Point3D((Tuple3DReadOnly)this.createRandomTuple(random));
            tuple.set((Tuple3DReadOnly)point);
            double expectedX = (1.0 - this.alpha) * point.getX() + this.alpha * originalX;
            double expectedY = (1.0 - this.alpha) * point.getY() + this.alpha * originalY;
            double expectedZ = (1.0 - this.alpha) * point.getZ() + this.alpha * originalZ;
            Assertions.assertEquals((double)expectedX, (double)tuple.getX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedY, (double)tuple.getY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedZ, (double)tuple.getZ(), (double)this.getEpsilon());
        }
    }

    public AlphaFilteredTuple3D createEmptyTuple() {
        return new AlphaFilteredTuple3D(() -> this.alpha);
    }

    public AlphaFilteredTuple3D createTuple(double v, double v1, double v2) {
        return new AlphaFilteredTuple3D(v, v1, v2, () -> this.alpha);
    }

    public AlphaFilteredTuple3D createRandomTuple(Random random) {
        return new AlphaFilteredTuple3D(random.nextDouble(), random.nextDouble(), random.nextDouble(), () -> this.alpha);
    }

    public double getEpsilon() {
        return 1.0E-7;
    }
}

