/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.math;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.math.YoMatrix;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoMatrixTest {
    private static final double EPSILON = 1.0E-10;
    private static final int ITERATIONS = 1000;

    @Test
    public void testSimpleYoMatrixRefactorExample() {
        Random random = new Random(1984L);
        int rowSize = random.nextInt(5, 10);
        int columnSize = random.nextInt(5, 10);
        YoRegistry registry = new YoRegistry("testRegistry");
        YoMatrix matrix = new YoMatrix("testMatrix", rowSize, columnSize, registry);
        Assertions.assertEquals((int)rowSize, (int)matrix.getNumRows());
        Assertions.assertEquals((int)columnSize, (int)matrix.getNumCols());
        DMatrixRMaj expected = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
        matrix.set((Matrix)expected);
        DMatrixRMaj actual = new DMatrixRMaj(rowSize, columnSize);
        matrix.get((DMatrix)actual);
        Assertions.assertArrayEquals((double[])expected.getData(), (double[])actual.getData(), (double)1.0E-10);
        Assertions.assertEquals((int)(rowSize * columnSize), (int)matrix.getNumElements());
        int smallerRowSize = random.nextInt(1, rowSize);
        int smallerColumnSize = random.nextInt(1, columnSize);
        DMatrixRMaj smallerExpected = RandomMatrices_DDRM.rectangle((int)smallerRowSize, (int)smallerColumnSize, (Random)random);
        matrix.set((Matrix)smallerExpected);
        DMatrixRMaj smallerActual = new DMatrixRMaj(smallerRowSize, smallerColumnSize);
        matrix.get((DMatrix)smallerActual);
        Assertions.assertArrayEquals((double[])smallerExpected.getData(), (double[])smallerActual.getData(), (double)1.0E-10);
        Assertions.assertEquals((int)(smallerRowSize * smallerColumnSize), (int)matrix.getNumElements());
    }

    @Test
    public void testConstructorsWithNamesAndDescriptions() {
        try {
            new YoMatrix("testMatrix", 4, 4, null, new String[]{"col1", "col2", "col3", "col4"}, new YoRegistry("testRegistry"));
            new YoMatrix("testMatrix", "testDescription", 4, 4, null, new String[]{"col1", "col2", "col3", "col4"}, new YoRegistry("testRegistry"));
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            new YoMatrix("testMatrix", 4, 4, new String[]{"row1", "row2", "row3", "row4"}, new YoRegistry("testRegistry"));
            new YoMatrix("testMatrix", "testDescription", 4, 4, new String[]{"row1", "row2", "row3", "row4"}, null, new YoRegistry("testRegistry"));
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            new YoMatrix("testMatrix", 4, 4, new String[]{"row1", "row2", "row3", "row4"}, new String[]{"col1", "col2"}, new YoRegistry("testRegistry"));
            new YoMatrix("testMatrix", "testDescription", 4, 4, new String[]{"row1", "row2", "row3", "row4"}, new String[]{"col1", "col2"}, new YoRegistry("testRegistry"));
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            new YoMatrix("testMatrix", 4, 4, new String[]{"row1", "row2"}, new String[]{"col1", "col2", "col3", "col4"}, new YoRegistry("testRegistry"));
            new YoMatrix("testMatrix", "testDescription", 4, 4, new String[]{"row1", "row2"}, new String[]{"col1", "col2", "col3", "col4"}, new YoRegistry("testRegistry"));
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDimensioning() {
        Random random = new Random(1984L);
        for (int i = 0; i < 1000; ++i) {
            int rowSize = random.nextInt(5, 10);
            int columnSize = random.nextInt(5, 10);
            String name = "testMatrix";
            YoRegistry registry = new YoRegistry("testRegistry");
            YoMatrix matrix = new YoMatrix(name, rowSize, columnSize, registry);
            int smallerRowSize = random.nextInt(1, rowSize);
            int smallerColumnSize = random.nextInt(1, columnSize);
            DMatrixRMaj smallerMatrix = new DMatrixRMaj(smallerRowSize, smallerColumnSize);
            try {
                matrix.get((DMatrix)smallerMatrix);
                Assertions.fail((String)"Should have thrown an exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            matrix.getAndReshape((DMatrixD1)smallerMatrix);
            Assertions.assertEquals((int)rowSize, (int)smallerMatrix.getNumRows());
            Assertions.assertEquals((int)columnSize, (int)smallerMatrix.getNumCols());
            Assertions.assertEquals((int)matrix.getNumRows(), (int)smallerMatrix.getNumRows());
            Assertions.assertEquals((int)matrix.getNumCols(), (int)smallerMatrix.getNumCols());
            int largerRowSize = random.nextInt(smallerRowSize, rowSize);
            int largerColumnSize = random.nextInt(smallerColumnSize, columnSize);
            DMatrixRMaj expected = RandomMatrices_DDRM.rectangle((int)largerRowSize, (int)largerColumnSize, (Random)random);
            matrix.set((Matrix)expected);
            DMatrixRMaj actual = new DMatrixRMaj(largerRowSize, largerColumnSize);
            matrix.get((DMatrix)actual);
            Assertions.assertArrayEquals((double[])expected.getData(), (double[])actual.getData(), (double)1.0E-10);
        }
    }

    @Test
    public void testSetDimensioning() {
        Random random = new Random(1984L);
        for (int i = 0; i < 1000; ++i) {
            int rowSize = random.nextInt(5, 10);
            int columnSize = random.nextInt(5, 10);
            String name = "testMatrix";
            YoRegistry registry = new YoRegistry("testRegistry");
            YoMatrix matrix = new YoMatrix(name, rowSize, columnSize, registry);
            int largerRowSize = random.nextInt(rowSize + 1, 2 * rowSize);
            int largerColumnSize = random.nextInt(columnSize + 1, 2 * columnSize);
            DMatrixRMaj largerMatrix = new DMatrixRMaj(largerRowSize, largerColumnSize);
            try {
                matrix.set((Matrix)largerMatrix);
                Assertions.fail((String)"Should have thrown an exception");
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testZero() {
        Random random = new Random(1984L);
        for (int i = 0; i < 1000; ++i) {
            int rowSize = random.nextInt(5, 10);
            int columnSize = random.nextInt(5, 10);
            String name = "testMatrixForZero";
            YoRegistry registry = new YoRegistry("testRegistry");
            YoMatrix matrix = new YoMatrix(name, rowSize, columnSize, registry);
            DMatrixRMaj randomMatrix = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            matrix.set((Matrix)randomMatrix);
            int smallerRowSize = random.nextInt(1, rowSize);
            int smallerColumnSize = random.nextInt(1, columnSize);
            matrix.zero(smallerRowSize, smallerColumnSize);
            DMatrixRMaj zeroMatrix = new DMatrixRMaj(smallerRowSize, smallerColumnSize);
            this.checkMatrixYoVariablesEqualsCheckMatrixAndOutsideValuesAreNaN(name, rowSize, columnSize, zeroMatrix, registry);
        }
    }

    @Test
    public void testNaN() {
        Random random = new Random(1984L);
        for (int i = 0; i < 1000; ++i) {
            int rowSize = random.nextInt(5, 10);
            int columnSize = random.nextInt(5, 10);
            YoMatrix matrix = new YoMatrix("testMatrix", rowSize, columnSize, new YoRegistry("testRegistry"));
            DMatrixRMaj randomMatrix = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            matrix.set((Matrix)randomMatrix);
            Assertions.assertFalse((boolean)matrix.containsNaN());
            matrix.setToNaN(rowSize, columnSize);
            Assertions.assertTrue((boolean)matrix.containsNaN());
        }
    }

    @Test
    public void testScale() {
        DMatrixRMaj actual;
        DMatrixRMaj expected;
        YoMatrix matrix;
        int columnSize;
        int rowSize;
        Random random = new Random(1984L);
        for (int i = 0; i < 1000; ++i) {
            rowSize = random.nextInt(5, 10);
            columnSize = random.nextInt(5, 10);
            matrix = new YoMatrix("testMatrix", rowSize, columnSize, new YoRegistry("testRegistry"));
            DMatrixRMaj randomMatrix = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            matrix.set((Matrix)randomMatrix);
            double scale = random.nextDouble();
            matrix.scale(scale);
            expected = new DMatrixRMaj(rowSize, columnSize);
            CommonOps_DDRM.scale((double)scale, (DMatrixD1)randomMatrix, (DMatrixD1)expected);
            actual = new DMatrixRMaj(rowSize, columnSize);
            matrix.get((DMatrix)actual);
            Assertions.assertArrayEquals((double[])expected.getData(), (double[])actual.getData(), (double)1.0E-10);
        }
        for (int j = 0; j < 1000; ++j) {
            rowSize = random.nextInt(5, 10);
            columnSize = random.nextInt(5, 10);
            matrix = new YoMatrix("testMatrix", rowSize, columnSize, new YoRegistry("testRegistry"));
            double scale = random.nextDouble();
            DMatrixRMaj randomMatrix = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            matrix.scale(scale, (DMatrix)randomMatrix);
            expected = new DMatrixRMaj(rowSize, columnSize);
            CommonOps_DDRM.scale((double)scale, (DMatrixD1)randomMatrix, (DMatrixD1)expected);
            actual = new DMatrixRMaj(rowSize, columnSize);
            matrix.get((DMatrix)actual);
            Assertions.assertArrayEquals((double[])expected.getData(), (double[])actual.getData(), (double)1.0E-10);
        }
    }

    @Test
    public void testScaleFailureCases() {
        Random random = new Random(1984L);
        for (int i = 0; i < 1000; ++i) {
            int minDimension = 1;
            int maxDimension = 5;
            YoMatrix matrix = new YoMatrix("testMatrix", random.nextInt(minDimension, maxDimension), random.nextInt(minDimension, maxDimension), new YoRegistry("testRegistry"));
            DMatrixRMaj matrixToScale = RandomMatrices_DDRM.rectangle((int)random.nextInt(minDimension, maxDimension), (int)random.nextInt(minDimension, maxDimension), (Random)random);
            if (matrix.getNumRows() != matrixToScale.getNumRows() || matrix.getNumCols() != matrixToScale.getNumCols()) {
                try {
                    matrix.scale(random.nextDouble(), (DMatrix)matrixToScale);
                    Assertions.fail((String)"Should have thrown an exception");
                }
                catch (RuntimeException runtimeException) {}
                continue;
            }
            matrix.scale(random.nextDouble(), (DMatrix)matrixToScale);
        }
    }

    @Test
    public void testAdd() {
        DMatrixRMaj B;
        DMatrixRMaj A;
        YoMatrix matrix;
        int columnSize;
        int rowSize;
        Random random = new Random(1984L);
        for (int i = 0; i < 1000; ++i) {
            rowSize = random.nextInt(5, 10);
            columnSize = random.nextInt(5, 10);
            matrix = new YoMatrix("testMatrix", rowSize, columnSize, new YoRegistry("testRegistry"));
            A = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            B = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            matrix.add((DMatrix)A, (DMatrix)B);
            DMatrixRMaj expected = new DMatrixRMaj(rowSize, columnSize);
            CommonOps_DDRM.add((DMatrixD1)A, (DMatrixD1)B, (DMatrixD1)expected);
            DMatrixRMaj actual = new DMatrixRMaj(rowSize, columnSize);
            matrix.get((DMatrix)actual);
            Assertions.assertArrayEquals((double[])expected.getData(), (double[])actual.getData(), (double)1.0E-10);
        }
        for (int j = 0; j < 1000; ++j) {
            rowSize = random.nextInt(5, 10);
            columnSize = random.nextInt(5, 10);
            matrix = new YoMatrix("testMatrix", rowSize, columnSize, new YoRegistry("testRegistry"));
            A = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            B = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            double beta = random.nextDouble();
            matrix.add((DMatrix)A, beta, (DMatrix)B);
            DMatrixRMaj expected = new DMatrixRMaj(rowSize, columnSize);
            CommonOps_DDRM.add((DMatrixD1)A, (double)beta, (DMatrixD1)B, (DMatrixD1)expected);
            DMatrixRMaj actual = new DMatrixRMaj(rowSize, columnSize);
            matrix.get((DMatrix)actual);
            Assertions.assertArrayEquals((double[])expected.getData(), (double[])actual.getData(), (double)1.0E-10);
        }
        for (int k = 0; k < 1000; ++k) {
            rowSize = random.nextInt(5, 10);
            columnSize = random.nextInt(5, 10);
            matrix = new YoMatrix("testMatrix", rowSize, columnSize, new YoRegistry("testRegistry"));
            A = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            B = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            double alpha = random.nextDouble();
            double beta = random.nextDouble();
            matrix.add(alpha, (DMatrix)A, beta, (DMatrix)B);
            DMatrixRMaj expected = new DMatrixRMaj(rowSize, columnSize);
            CommonOps_DDRM.add((double)alpha, (DMatrixD1)A, (double)beta, (DMatrixD1)B, (DMatrixD1)expected);
            DMatrixRMaj actual = new DMatrixRMaj(rowSize, columnSize);
            matrix.get((DMatrix)actual);
            Assertions.assertArrayEquals((double[])expected.getData(), (double[])actual.getData(), (double)1.0E-10);
        }
    }

    @Test
    public void testAddFailureCases() {
        Random random = new Random(1984L);
        for (int i = 0; i < 1000; ++i) {
            int minDimension = 1;
            int maxDimension = 5;
            YoMatrix matrix = new YoMatrix("testMatrix", random.nextInt(minDimension, maxDimension), random.nextInt(minDimension, maxDimension), new YoRegistry("testRegistry"));
            DMatrixRMaj A = RandomMatrices_DDRM.rectangle((int)random.nextInt(minDimension, maxDimension), (int)random.nextInt(minDimension, maxDimension), (Random)random);
            DMatrixRMaj B = RandomMatrices_DDRM.rectangle((int)random.nextInt(minDimension, maxDimension), (int)random.nextInt(minDimension, maxDimension), (Random)random);
            if (A.getNumRows() != B.getNumRows() || A.getNumCols() != B.getNumCols()) {
                try {
                    matrix.add((DMatrix)A, (DMatrix)B);
                    Assertions.fail((String)"Should have thrown an exception");
                }
                catch (RuntimeException runtimeException) {}
                continue;
            }
            if (matrix.getNumRows() != A.getNumRows() || matrix.getNumCols() != A.getNumCols() || matrix.getNumRows() != B.getNumRows() || matrix.getNumCols() != B.getNumCols()) {
                try {
                    matrix.add((DMatrix)A, (DMatrix)B);
                    Assertions.fail((String)"Should have thrown an exception");
                }
                catch (RuntimeException runtimeException) {}
                continue;
            }
            matrix.add((DMatrix)A, (DMatrix)B);
        }
    }

    @Test
    public void testAddEquals() {
        DMatrixRMaj A;
        DMatrixRMaj randomMatrix;
        YoMatrix matrix;
        int columnSize;
        int rowSize;
        Random random = new Random(1984L);
        for (int i = 0; i < 1000; ++i) {
            rowSize = random.nextInt(5, 10);
            columnSize = random.nextInt(5, 10);
            matrix = new YoMatrix("testMatrix", rowSize, columnSize, new YoRegistry("testRegistry"));
            randomMatrix = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            matrix.set((Matrix)randomMatrix);
            A = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            matrix.addEquals((DMatrix)A);
            DMatrixRMaj expected = new DMatrixRMaj(rowSize, columnSize);
            CommonOps_DDRM.add((DMatrixD1)randomMatrix, (DMatrixD1)A, (DMatrixD1)expected);
            DMatrixRMaj actual = new DMatrixRMaj(rowSize, columnSize);
            matrix.get((DMatrix)actual);
            Assertions.assertArrayEquals((double[])expected.getData(), (double[])actual.getData(), (double)1.0E-10);
        }
        for (int j = 0; j < 1000; ++j) {
            rowSize = random.nextInt(5, 10);
            columnSize = random.nextInt(5, 10);
            matrix = new YoMatrix("testMatrix", rowSize, columnSize, new YoRegistry("testRegistry"));
            randomMatrix = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            matrix.set((Matrix)randomMatrix);
            A = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            double alpha = random.nextDouble();
            matrix.addEquals(alpha, (DMatrix)A);
            DMatrixRMaj expected = new DMatrixRMaj(rowSize, columnSize);
            CommonOps_DDRM.add((DMatrixD1)randomMatrix, (double)alpha, (DMatrixD1)A, (DMatrixD1)expected);
            DMatrixRMaj actual = new DMatrixRMaj(rowSize, columnSize);
            matrix.get((DMatrix)actual);
            Assertions.assertArrayEquals((double[])expected.getData(), (double[])actual.getData(), (double)1.0E-10);
        }
    }

    @Test
    public void testAddEqualsFailureCases() {
        Random random = new Random(1984L);
        for (int i = 0; i < 1000; ++i) {
            int minDimension = 1;
            int maxDimension = 5;
            YoMatrix matrix = new YoMatrix("testMatrix", random.nextInt(minDimension, maxDimension), random.nextInt(minDimension, maxDimension), new YoRegistry("testRegistry"));
            DMatrixRMaj A = RandomMatrices_DDRM.rectangle((int)random.nextInt(minDimension, maxDimension), (int)random.nextInt(minDimension, maxDimension), (Random)random);
            if (matrix.getNumRows() != A.getNumRows() || matrix.getNumCols() != A.getNumCols()) {
                try {
                    matrix.addEquals((DMatrix)A);
                    Assertions.fail((String)"Should have thrown an exception");
                }
                catch (RuntimeException runtimeException) {}
                continue;
            }
            matrix.addEquals((DMatrix)A);
        }
    }

    @Test
    public void testSafeSetAndGetWithIndices() {
        Random random = new Random(1984L);
        for (int i = 0; i < 1000; ++i) {
            int rowSize = random.nextInt(5, 10);
            int columnSize = random.nextInt(5, 10);
            YoMatrix matrix = new YoMatrix("testMatrix", rowSize, columnSize, new YoRegistry("testRegistry"));
            DMatrixRMaj randomMatrix = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            matrix.set((Matrix)randomMatrix);
            for (int row = 0; row < rowSize; ++row) {
                for (int column = 0; column < columnSize; ++column) {
                    double value = random.nextDouble();
                    matrix.set(row, column, value);
                    Assertions.assertEquals((double)value, (double)matrix.get(row, column), (double)1.0E-10);
                }
            }
        }
    }

    private void checkMatrixYoVariablesEqualsCheckMatrixAndOutsideValuesAreNaN(String name, int maxNumberOfRows, int maxNumberOfColumns, DMatrixRMaj checkMatrix, YoRegistry registry) {
        int smallerRows = checkMatrix.getNumRows();
        int smallerColumns = checkMatrix.getNumCols();
        for (int row = 0; row < maxNumberOfRows; ++row) {
            for (int column = 0; column < maxNumberOfColumns; ++column) {
                YoDouble variable = (YoDouble)registry.findVariable(name + "_" + row + "_" + column);
                if (row < smallerRows && column < smallerColumns) {
                    Assertions.assertEquals((double)checkMatrix.get(row, column), (double)variable.getDoubleValue(), (double)1.0E-10);
                    continue;
                }
                Assertions.assertTrue((boolean)Double.isNaN(variable.getDoubleValue()));
            }
        }
    }
}

