/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.variable;

import org.apache.commons.lang3.mutable.MutableBoolean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariableType;

public class YoEnumTest {
    private EnumYoVariableTestEnums enumValue;
    private YoRegistry registry = null;
    private static final double EPSILON = 1.0E-10;

    @BeforeEach
    public void setUp() {
        this.registry = new YoRegistry("testRegistry");
    }

    @AfterEach
    public void tearDown() {
        this.registry = null;
    }

    @Test
    public void testConstructorNoDescription() {
        YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class);
        Assertions.assertFalse((yoEnum == null ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)this.registry.getVariables().size());
        Assertions.assertTrue((boolean)yoEnum.getName().equals("yoEnum"));
        Assertions.assertTrue((boolean)this.registry.findVariable("yoEnum").equals(yoEnum));
    }

    @Test
    public void testConstructorWithDescription() {
        YoEnum yoEnum = new YoEnum("yoEnum", "yoEnum with description", this.registry, EnumYoVariableTestEnums.class, false);
        Assertions.assertFalse((yoEnum == null ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)this.registry.getVariables().size());
        Assertions.assertTrue((boolean)yoEnum.getName().equals("yoEnum"));
        Assertions.assertTrue((boolean)this.registry.findVariable("yoEnum").equals(yoEnum));
        Assertions.assertTrue((boolean)yoEnum.getDescription().equals("yoEnum with description"));
    }

    @Test
    public void testCreateNoDescription() {
        YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class);
        Assertions.assertFalse((yoEnum == null ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)this.registry.getVariables().size());
        Assertions.assertTrue((boolean)yoEnum.getName().equals("yoEnum"));
        Assertions.assertTrue((boolean)this.registry.findVariable("yoEnum").equals(yoEnum));
    }

    @Test
    public void testCreateWithDescription() {
        YoEnum yoEnum = new YoEnum("yoEnum", "yoEnum with description", this.registry, EnumYoVariableTestEnums.class, false);
        Assertions.assertFalse((yoEnum == null ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)this.registry.getVariables().size());
        Assertions.assertTrue((boolean)yoEnum.getName().equals("yoEnum"));
        Assertions.assertTrue((boolean)this.registry.findVariable("yoEnum").equals(yoEnum));
        Assertions.assertTrue((boolean)yoEnum.getDescription().equals("yoEnum with description"));
    }

    @Test
    public void testSetAndValueEquals() {
        YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class, true);
        yoEnum.set((Enum)EnumYoVariableTestEnums.ONE);
        Assertions.assertTrue((boolean)yoEnum.valueEquals((Enum)EnumYoVariableTestEnums.ONE));
        yoEnum.set((Enum)EnumYoVariableTestEnums.TWO);
        Assertions.assertTrue((boolean)yoEnum.valueEquals((Enum)EnumYoVariableTestEnums.TWO));
        yoEnum.set(null);
        Assertions.assertTrue((boolean)yoEnum.valueEquals(null));
    }

    @Test
    public void testSetAndGet() {
        YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class);
        yoEnum.set((Enum)EnumYoVariableTestEnums.ONE);
        Assertions.assertEquals((Object)((Object)EnumYoVariableTestEnums.ONE), (Object)yoEnum.getEnumValue());
        yoEnum.set((Enum)EnumYoVariableTestEnums.TWO);
        Assertions.assertEquals((Object)((Object)EnumYoVariableTestEnums.TWO), (Object)yoEnum.getEnumValue());
        yoEnum.set((Enum)EnumYoVariableTestEnums.ONE, false);
        Assertions.assertEquals((Object)((Object)EnumYoVariableTestEnums.ONE), (Object)yoEnum.getEnumValue());
        yoEnum.set((Enum)EnumYoVariableTestEnums.TWO, false);
        Assertions.assertEquals((Object)((Object)EnumYoVariableTestEnums.TWO), (Object)yoEnum.getEnumValue());
    }

    @Test
    public void testGetValues() {
        YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class);
        EnumYoVariableTestEnums[] enumTypeArray = (EnumYoVariableTestEnums[])yoEnum.getEnumValues();
        Assertions.assertEquals((int)2, (int)enumTypeArray.length);
        Assertions.assertEquals((Object)((Object)EnumYoVariableTestEnums.ONE), (Object)((Object)enumTypeArray[0]));
        Assertions.assertEquals((Object)((Object)EnumYoVariableTestEnums.TWO), (Object)((Object)enumTypeArray[1]));
    }

    @Test
    public void testSetValueAsDoublePositiveNumber() {
        YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class);
        yoEnum.setValueFromDouble(0.0);
        Assertions.assertEquals((Object)((Object)EnumYoVariableTestEnums.ONE), (Object)yoEnum.getEnumValue());
        yoEnum.setValueFromDouble(0.25);
        Assertions.assertEquals((Object)((Object)EnumYoVariableTestEnums.ONE), (Object)yoEnum.getEnumValue());
        yoEnum.setValueFromDouble(0.5);
        Assertions.assertEquals((Object)((Object)EnumYoVariableTestEnums.TWO), (Object)yoEnum.getEnumValue());
        yoEnum.setValueFromDouble(1.0);
        Assertions.assertEquals((Object)((Object)EnumYoVariableTestEnums.TWO), (Object)yoEnum.getEnumValue());
    }

    @Test
    public void testSetValueAsDoubleOutOfBoundsJustIgnoresIt() {
        YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class);
        EnumYoVariableTestEnums originalValue = (EnumYoVariableTestEnums)yoEnum.getEnumValue();
        yoEnum.setValueFromDouble(2.0);
        Assertions.assertEquals((Object)((Object)EnumYoVariableTestEnums.TWO), (Object)yoEnum.getEnumValue());
        yoEnum.setValueFromDouble(-100.0);
        Assertions.assertEquals((Object)((Object)EnumYoVariableTestEnums.ONE), (Object)yoEnum.getEnumValue());
    }

    @Test
    public void testForNull() {
        YoEnum yoEnum = new YoEnum("yoEnum", "", this.registry, EnumYoVariableTestEnums.class, true);
        yoEnum.setValueFromDouble(-1.0);
        Assertions.assertEquals((Object)yoEnum.getEnumValue(), null);
    }

    @Test
    public void testNotAllowNull() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class);
            yoEnum.set(null);
        });
    }

    @Test
    public void testAllowNull() {
        YoEnum yoEnum = new YoEnum("yoEnum", "", this.registry, EnumYoVariableTestEnums.class, true);
        yoEnum.set(null);
        Assertions.assertEquals((Object)yoEnum.getEnumValue(), null);
    }

    @Test
    public void testGetValueAsDouble() {
        YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class, true);
        yoEnum.set((Enum)EnumYoVariableTestEnums.ONE);
        Assertions.assertEquals((double)0.0, (double)yoEnum.getValueAsDouble(), (double)1.0E-10);
        yoEnum.set((Enum)EnumYoVariableTestEnums.TWO);
        Assertions.assertEquals((double)1.0, (double)yoEnum.getValueAsDouble(), (double)1.0E-10);
        yoEnum.set(null);
        Assertions.assertEquals((double)-1.0, (double)yoEnum.getValueAsDouble(), (double)1.0E-10);
    }

    @Test
    public void testToString() {
        YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class);
        yoEnum.set((Enum)EnumYoVariableTestEnums.ONE);
        Assertions.assertEquals((Object)"yoEnum: ONE", (Object)yoEnum.toString());
        yoEnum.set((Enum)EnumYoVariableTestEnums.TWO);
        Assertions.assertEquals((Object)"yoEnum: TWO", (Object)yoEnum.toString());
    }

    @Test
    public void testGetYoVariableType() {
        YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class);
        Assertions.assertEquals((Object)YoVariableType.ENUM, (Object)yoEnum.getType());
    }

    @Test
    public void testGetValueAsLongBitsAndSetValueFromLongBits() {
        boolean notifyListeners = true;
        long longValue = 1L;
        YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class, true);
        yoEnum.setValueFromLongBits(longValue, notifyListeners);
        Assertions.assertEquals((long)longValue, (long)yoEnum.getValueAsLongBits());
        try {
            longValue = 2L;
            yoEnum.setValueFromLongBits(longValue);
            Assertions.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        yoEnum.set(null);
        Assertions.assertEquals((long)-1L, (long)yoEnum.getValueAsLongBits());
    }

    @Test
    public void testGetEnumType() {
        this.enumValue = EnumYoVariableTestEnums.ONE;
        YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class);
        yoEnum.set((Enum)this.enumValue);
        Assertions.assertEquals(((Object)((Object)this.enumValue)).getClass(), (Object)yoEnum.getEnumType());
    }

    @Test
    public void testDuplicate() {
        YoRegistry newRegistry = new YoRegistry("newRegistry");
        YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class);
        YoEnum yoEnum2 = yoEnum.duplicate(newRegistry);
        Assertions.assertTrue((boolean)yoEnum2.getName().equals(yoEnum.getName()));
        Assertions.assertTrue((boolean)yoEnum2.getDescription().equals(yoEnum.getDescription()));
        Assertions.assertTrue((boolean)yoEnum2.getEnumType().equals(yoEnum.getEnumType()));
        Assertions.assertEquals((Object)yoEnum2.isNullAllowed(), (Object)yoEnum.isNullAllowed());
    }

    @Test
    public void testProviderValue() {
        YoEnum yoEnum = new YoEnum("yoEnum", this.registry, EnumYoVariableTestEnums.class);
        YoEnum yoEnum2 = new YoEnum("yoEnum2", this.registry, EnumYoVariableTestEnums.class);
        yoEnum.set((Enum)EnumYoVariableTestEnums.ONE);
        yoEnum2.set((Enum)EnumYoVariableTestEnums.TWO);
        Assertions.assertEquals((Object)yoEnum.getEnumValue(), (Object)yoEnum.getValue());
        Assertions.assertEquals((Object)yoEnum2.getEnumValue(), (Object)yoEnum2.getValue());
    }

    @Test
    public void testStringBasedAccessNullConstant() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            String[] constants = new String[]{"A", "B", "C", null, "E", "F", "G", "H"};
            YoRegistry registry = new YoRegistry("test");
            new YoEnum("constantDefault", "", registry, false, constants);
        });
    }

    @Test
    public void testEmptyConstantList() {
        String[] constants = new String[]{};
        YoRegistry registry = new YoRegistry("test");
        YoEnum stringConstructor = new YoEnum("stringConstructor", "", registry, true, constants);
        YoEnum enumConstructor = new YoEnum("enumConsturctor", "", registry, EmptyEnum.class, true);
        Assertions.assertEquals(null, (Object)enumConstructor.getEnumValue());
        Assertions.assertEquals((Object)"null", (Object)stringConstructor.getStringValue());
    }

    @Test
    public void testEmptyConstantListNotNull() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            YoRegistry registry = new YoRegistry("test");
            new YoEnum("enumConsturctor", "", registry, EmptyEnum.class, false);
        });
    }

    @Test
    public void testEmptyStringConstantListNotNull() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            YoRegistry registry = new YoRegistry("test");
            String[] constants = new String[]{};
            new YoEnum("stringConstructor", "", registry, false, constants);
        });
    }

    @Test
    public void testListener() {
        YoEnum yoEnum = new YoEnum("anEnum", "", this.registry, EnumYoVariableTestEnums.class, true);
        yoEnum.set(null);
        MutableBoolean hasChanged = new MutableBoolean(false);
        yoEnum.addListener(v -> hasChanged.setTrue());
        for (EnumYoVariableTestEnums value : EnumYoVariableTestEnums.values()) {
            yoEnum.set((Enum)value);
            Assertions.assertTrue((boolean)hasChanged.isTrue());
            hasChanged.setFalse();
            yoEnum.set((Enum)value);
            Assertions.assertFalse((boolean)hasChanged.isTrue());
            hasChanged.setFalse();
        }
        yoEnum.set(null);
        Assertions.assertTrue((boolean)hasChanged.isTrue());
        hasChanged.setFalse();
        yoEnum.set(null);
        Assertions.assertFalse((boolean)hasChanged.isTrue());
        hasChanged.setFalse();
    }

    private static enum EnumYoVariableTestEnums {
        ONE,
        TWO;

    }

    static final class EmptyEnum
    extends Enum<EmptyEnum> {
        private static final /* synthetic */ EmptyEnum[] $VALUES;

        public static EmptyEnum[] values() {
            return (EmptyEnum[])$VALUES.clone();
        }

        public static EmptyEnum valueOf(String name) {
            return Enum.valueOf(EmptyEnum.class, name);
        }

        private static /* synthetic */ EmptyEnum[] $values() {
            return new EmptyEnum[0];
        }

        static {
            $VALUES = EmptyEnum.$values();
        }
    }
}

