/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantProfile;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.QueuedROS2Publisher;
import us.ihmc.ros2.QueuedROS2Subscription;
import us.ihmc.ros2.ROS2NodeBasics;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2PublisherBasics;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Subscription;
import us.ihmc.util.PeriodicNonRealtimeThreadSchedulerFactory;
import us.ihmc.util.PeriodicThreadScheduler;
import us.ihmc.util.PeriodicThreadSchedulerFactory;

public class RealtimeROS2Node
implements ROS2NodeInterface {
    public static final int DEFAULT_THREAD_PERIOD_MICROSECONDS = 1000;
    private final ROS2NodeBasics node;
    private final ArrayList<QueuedROS2Publisher<?>> publishers = new ArrayList();
    private final ReentrantLock startupLock = new ReentrantLock();
    private final PeriodicThreadScheduler scheduler;
    private boolean spinning = false;
    private TimeUnit threadPeriodUnit = TimeUnit.MICROSECONDS;
    private long threadPeriod = 1000L;

    public RealtimeROS2Node(DomainFactory.PubSubImplementation pubSubImplementation, String name, int domainId, InetAddress ... addressRestriction) {
        this(DomainFactory.getDomain((DomainFactory.PubSubImplementation)pubSubImplementation), (PeriodicThreadSchedulerFactory)new PeriodicNonRealtimeThreadSchedulerFactory(), name, "/us/ihmc", domainId, addressRestriction);
    }

    public RealtimeROS2Node(DomainFactory.PubSubImplementation pubSubImplementation, PeriodicThreadSchedulerFactory threadFactory, String name, int domainId, InetAddress ... addressRestriction) {
        this(DomainFactory.getDomain((DomainFactory.PubSubImplementation)pubSubImplementation), threadFactory, name, "/us/ihmc", domainId, addressRestriction);
    }

    public RealtimeROS2Node(Domain domain, PeriodicThreadSchedulerFactory threadFactory, String name) {
        this(domain, threadFactory, name, "/us/ihmc");
    }

    public RealtimeROS2Node(Domain domain, PeriodicThreadSchedulerFactory threadFactory, String name, String namespace) {
        this(domain, threadFactory, name, namespace, ROS2NodeInterface.domainFromEnvironment(), ROS2NodeInterface.useSHMFromEnvironment(), new InetAddress[0]);
    }

    public RealtimeROS2Node(Domain domain, PeriodicThreadSchedulerFactory threadFactory, String name, String namespace, int domainId, InetAddress ... addressRestriction) {
        this(domain, threadFactory, name, namespace, domainId, ROS2NodeInterface.useSHMFromEnvironment(), addressRestriction);
    }

    public RealtimeROS2Node(Domain domain, PeriodicThreadSchedulerFactory threadFactory, String name, String namespace, int domainId, boolean useSharedMemory, InetAddress ... addressRestriction) {
        this(domain, threadFactory, name, namespace, ROS2NodeInterface.createParticipantAttributes(domainId, useSharedMemory, addressRestriction));
    }

    public RealtimeROS2Node(Domain domain, PeriodicThreadSchedulerFactory threadFactory, String name, String namespace, ParticipantProfile attributes) {
        this.node = new ROS2NodeBasics(domain, name, namespace, attributes);
        this.scheduler = threadFactory.createPeriodicThreadScheduler("RealtimeNode_" + namespace + "/" + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadPeriod(long period, TimeUnit unit) {
        this.startupLock.lock();
        try {
            if (this.spinning) {
                throw new RuntimeException("Cannot set the thread period while the node is spinning.");
            }
            this.threadPeriod = period;
            this.threadPeriodUnit = unit;
        }
        finally {
            this.startupLock.unlock();
        }
    }

    public <T> QueuedROS2Publisher<T> createPublisher(TopicDataType<T> topicDataType, PublisherAttributes publisherAttributes) {
        return this.createPublisher(topicDataType, publisherAttributes, 10);
    }

    public <T> QueuedROS2Publisher<T> createPublisher(TopicDataType<T> topicDataType, String topicName, ROS2QosProfile qosProfile, int queueSize) {
        return this.createPublisher(topicDataType, this.createPublisherAttributes(topicDataType, topicName, qosProfile), queueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> QueuedROS2Publisher<T> createPublisher(TopicDataType<T> topicDataType, PublisherAttributes publisherAttributes, int queueSize) {
        this.startupLock.lock();
        try {
            if (this.spinning) {
                throw new RuntimeException("Cannot add publishers to a RealtimeROS2Node that is already spinning");
            }
            ROS2PublisherBasics rosPublisher = this.node.createPublisher((TopicDataType)topicDataType, publisherAttributes);
            QueuedROS2Publisher<T> realtimePublisher = new QueuedROS2Publisher<T>(topicDataType, rosPublisher, queueSize);
            this.publishers.add(realtimePublisher);
            QueuedROS2Publisher<T> queuedROS2Publisher = realtimePublisher;
            return queuedROS2Publisher;
        }
        finally {
            this.startupLock.unlock();
        }
    }

    @Override
    public <T> QueuedROS2Subscription<T> createQueuedSubscription(TopicDataType<T> topicDataType, SubscriberAttributes subscriberAttributes, int queueSize) {
        return this.node.createQueuedSubscription(topicDataType, subscriberAttributes, queueSize);
    }

    public void spin() {
        this.startupLock.lock();
        if (this.spinning) {
            this.startupLock.unlock();
            throw new RuntimeException("This RealtimeROS2Node is already spinning");
        }
        this.spinning = true;
        this.scheduler.schedule(this::realtimeNodeThread, this.threadPeriod, this.threadPeriodUnit);
        this.startupLock.unlock();
    }

    private void realtimeNodeThread() {
        for (int i = 0; i < this.publishers.size(); ++i) {
            this.publishers.get(i).spin();
        }
    }

    public void stopSpinning() {
        this.scheduler.shutdown();
        this.startupLock.lock();
        this.spinning = false;
        this.startupLock.unlock();
    }

    public void destroy() {
        if (this.spinning) {
            this.stopSpinning();
        }
        this.node.destroy();
    }

    @Override
    public String getName() {
        return this.node.getName();
    }

    @Override
    public String getNamespace() {
        return this.node.getNamespace();
    }

    @Override
    public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, NewMessageListener<T> subscriberListener, SubscriberAttributes subscriberAttributes) {
        return this.node.createSubscription(topicDataType, subscriberListener, subscriberAttributes);
    }

    @Override
    public <T> SubscriberAttributes createSubscriberAttributes(String topicName, TopicDataType<T> topicDataType, ROS2QosProfile qosProfile) {
        return this.node.createSubscriberAttributes(topicName, topicDataType, qosProfile);
    }

    @Override
    public <T> PublisherAttributes createPublisherAttributes(TopicDataType<T> topicDataType, String topicName, ROS2QosProfile qosProfile) {
        return this.node.createPublisherAttributes(topicDataType, topicName, qosProfile);
    }
}

