/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindPolicyType;
import java.util.Objects;
import us.ihmc.log.LogTools;

public class ROS2QosProfile {
    private final HistoryQosKindPolicyType historyKind;
    private final int historyDepth;
    private final ReliabilityQosKindPolicyType reliabilityKind;
    private final DurabilityQosKindPolicyType durabilityKind;
    private final boolean avoidRosNamespaceConventions;

    public static ROS2QosProfile DEFAULT() {
        String defaultQoS = System.getenv("ROS_DEFAULT_QOS");
        if (defaultQoS != null && defaultQoS.trim().equalsIgnoreCase("reliable")) {
            LogTools.info((String)"Topics with unspecified QoS will use RELIABLE.");
            return ROS2QosProfile.RELIABLE();
        }
        LogTools.info((String)"Topics with unspecified QoS will use BEST_EFFORT.");
        return ROS2QosProfile.BEST_EFFORT();
    }

    public static ROS2QosProfile RELIABLE() {
        int depth = 1;
        return new ROS2QosProfile(HistoryQosKindPolicyType.KEEP_LAST, depth, ReliabilityQosKindPolicyType.RELIABLE, DurabilityQosKindPolicyType.VOLATILE, false);
    }

    public static ROS2QosProfile KEEP_HISTORY(int depth) {
        return new ROS2QosProfile(HistoryQosKindPolicyType.KEEP_LAST, depth, ReliabilityQosKindPolicyType.RELIABLE, DurabilityQosKindPolicyType.TRANSIENT_LOCAL, false);
    }

    public static ROS2QosProfile BEST_EFFORT() {
        int depth = 1;
        return new ROS2QosProfile(HistoryQosKindPolicyType.KEEP_LAST, depth, ReliabilityQosKindPolicyType.BEST_EFFORT, DurabilityQosKindPolicyType.VOLATILE, false);
    }

    public ROS2QosProfile(HistoryQosKindPolicyType historyKind, int historyDepth, ReliabilityQosKindPolicyType reliabilityKind, DurabilityQosKindPolicyType durabilityKind, boolean avoidRosNamespaceConventions) {
        this.historyKind = historyKind;
        this.historyDepth = historyDepth;
        this.reliabilityKind = reliabilityKind;
        this.durabilityKind = durabilityKind;
        this.avoidRosNamespaceConventions = avoidRosNamespaceConventions;
    }

    public HistoryQosKindPolicyType getHistoryKind() {
        return this.historyKind;
    }

    public int getHistoryDepth() {
        return this.historyDepth;
    }

    public ReliabilityQosKindPolicyType getReliabilityKind() {
        return this.reliabilityKind;
    }

    public DurabilityQosKindPolicyType getDurabilityKind() {
        return this.durabilityKind;
    }

    public boolean isAvoidRosNamespaceConventions() {
        return this.avoidRosNamespaceConventions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ROS2QosProfile otherQoS = (ROS2QosProfile)other;
        boolean equals = this.historyKind == otherQoS.historyKind;
        equals &= this.historyDepth == otherQoS.historyDepth;
        equals &= this.reliabilityKind == otherQoS.reliabilityKind;
        equals &= this.durabilityKind == otherQoS.durabilityKind;
        return equals &= this.avoidRosNamespaceConventions == otherQoS.avoidRosNamespaceConventions;
    }

    public int hashCode() {
        return Objects.hash(this.historyKind, this.historyDepth, this.reliabilityKind, this.durabilityKind, this.avoidRosNamespaceConventions);
    }
}

