/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import java.io.IOException;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantProfile;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.QueuedROS2Subscription;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Subscription;
import us.ihmc.ros2.ROS2TopicNameTools;
import us.ihmc.ros2.RealtimeROS2SubscriptionListener;

class ROS2NodeBasics
implements ROS2NodeInterface {
    public static final String DEFAULT_NAMESPACE = "/us/ihmc";
    private Domain domain;
    private Participant participant;
    private final String nodeName;
    private final String namespace;

    ROS2NodeBasics(Domain domain, String name, String namespace, ParticipantProfile attributes) {
        this.domain = domain;
        ROS2TopicNameTools.checkNodename(name);
        ROS2TopicNameTools.checkNamespace(namespace);
        this.nodeName = name;
        this.namespace = namespace;
        attributes.name(name);
        try {
            this.participant = domain.createParticipant(attributes);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public <T> ROS2Publisher<T> createPublisher(TopicDataType<T> topicDataType, PublisherAttributes publisherAttributes) {
        Publisher publisher;
        TopicDataType registeredType = this.domain.getRegisteredType(this.participant, topicDataType.getName());
        if (registeredType == null) {
            this.domain.registerType(this.participant, topicDataType);
        }
        try {
            publisher = this.domain.createPublisher(this.participant, publisherAttributes);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return new ROS2Publisher(this.domain, publisher);
    }

    @Override
    public <T> PublisherAttributes createPublisherAttributes(TopicDataType<T> topicDataType, String topicName, ROS2QosProfile qosProfile) {
        PublisherAttributes publisherAttributes = (PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)PublisherAttributes.create().topicDataType(topicDataType)).reliabilityKind(qosProfile.getReliabilityKind())).heartBeatPeriod(new Time(0, 100000000L)).durabilityKind(qosProfile.getDurabilityKind())).historyDepth((long)qosProfile.getHistoryDepth())).historyQosPolicyKind(qosProfile.getHistoryKind());
        ROS2TopicNameTools.assignNameAndPartitionsToAttributes(publisherAttributes, this.namespace, this.nodeName, topicName, qosProfile.isAvoidRosNamespaceConventions());
        return publisherAttributes;
    }

    @Override
    public <T> QueuedROS2Subscription<T> createQueuedSubscription(TopicDataType<T> topicDataType, SubscriberAttributes subscriberAttributes, int queueSize) {
        RealtimeROS2SubscriptionListener<T> listener = new RealtimeROS2SubscriptionListener<T>(topicDataType, queueSize);
        ROS2Subscription<T> subscriber = this.createSubscription(topicDataType, listener, subscriberAttributes);
        return new QueuedROS2Subscription<T>(subscriber, listener);
    }

    @Override
    public <T> SubscriberAttributes createSubscriberAttributes(String topicName, TopicDataType<T> topicDataType, ROS2QosProfile qosProfile) {
        SubscriberAttributes subscriberAttributes = (SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)SubscriberAttributes.create().topicDataType(topicDataType)).topicName(topicName)).reliabilityKind(qosProfile.getReliabilityKind())).durabilityKind(qosProfile.getDurabilityKind())).historyDepth((long)qosProfile.getHistoryDepth())).historyQosPolicyKind(qosProfile.getHistoryKind());
        ROS2TopicNameTools.assignNameAndPartitionsToAttributes(subscriberAttributes, this.namespace, this.nodeName, topicName, qosProfile.isAvoidRosNamespaceConventions());
        return subscriberAttributes;
    }

    @Override
    public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, NewMessageListener<T> subscriberListener, SubscriberAttributes subscriberAttributes) {
        Subscriber subscriber;
        TopicDataType registeredType = this.domain.getRegisteredType(this.participant, topicDataType.getName());
        if (registeredType == null) {
            this.domain.registerType(this.participant, topicDataType);
        }
        try {
            subscriber = this.domain.createSubscriber(this.participant, subscriberAttributes, subscriberListener);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return new ROS2Subscription(this.domain, subscriber);
    }

    @Override
    public String getName() {
        return this.nodeName;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void destroy() {
        if (this.domain != null) {
            block3: {
                LogTools.info((String)("Shutting down ROS2 node " + this.nodeName));
                try {
                    this.domain.removeParticipant(this.participant);
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().contains("This participant is not registered with this domain")) break block3;
                    throw e;
                }
            }
            this.domain = null;
        }
        this.participant = null;
    }
}

