/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import us.ihmc.commons.time.Stopwatch;
import us.ihmc.concurrent.ConcurrentRingBuffer;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.ros2.ROS2Publisher;

public class QueuedROS2Publisher<T>
extends ROS2Publisher<T> {
    private final TopicDataType<T> topicDataType;
    private final ConcurrentRingBuffer<T> concurrentRingBuffer;
    private final Stopwatch throttleStopwatch = new Stopwatch().start();
    private long errorCount = 0L;
    private int numberOfExceptions = 0;

    QueuedROS2Publisher(TopicDataType<T> topicDataType, ROS2Publisher<T> rosPublisher, int queueDepth) {
        super(rosPublisher.getDomain(), rosPublisher.getPublisher());
        this.topicDataType = topicDataType.newInstance();
        this.concurrentRingBuffer = new ConcurrentRingBuffer(() -> topicDataType.createData(), queueDepth);
    }

    @Override
    public boolean publish(T data) {
        try {
            Object next = this.concurrentRingBuffer.next();
            if (next != null) {
                this.topicDataType.copy(data, next);
                this.concurrentRingBuffer.commit();
                return true;
            }
            if (this.throttleStopwatch.totalElapsed() > 1.0) {
                ++this.errorCount;
                this.throttleStopwatch.reset();
                LogTools.error((String)"No space left in concurrent ring buffer. Buffer capacity: {} Topic: {} Occurence #: {}", (Object)this.concurrentRingBuffer.getCapacity(), (Object)this.getPublisher().getAttributes().getTopicName(), (Object)this.errorCount);
            }
            return false;
        }
        catch (Exception exception) {
            if (this.numberOfExceptions < 6) {
                exception.printStackTrace();
                ++this.numberOfExceptions;
                if (this.numberOfExceptions >= 6) {
                    LogTools.error((String)"Stopping to print exceptions after 5.");
                }
            }
            return false;
        }
    }

    void spin() {
        if (this.concurrentRingBuffer.poll()) {
            Object next;
            while ((next = this.concurrentRingBuffer.read()) != null) {
                super.publish(next);
            }
            this.concurrentRingBuffer.flush();
        }
    }

    @Override
    public void remove() {
    }
}

