/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import us.ihmc.log.LogTools;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.ros2.ROS2PublisherBasics;

public class ROS2Publisher<T>
implements ROS2PublisherBasics<T> {
    private static final int NUMBER_OF_EXCEPTIONS_TO_PRINT = 5;
    private int numberOfExceptions = 0;
    private final Domain domain;
    private final Publisher publisher;

    ROS2Publisher(Domain domain, Publisher publisher) {
        this.domain = domain;
        this.publisher = publisher;
    }

    @Override
    public synchronized boolean publish(T data) {
        try {
            if (this.publisher.isAvailable()) {
                this.publisher.write(data);
                return true;
            }
            throw new Exception("Failed to publish message. Type: " + data.getClass().getSimpleName());
        }
        catch (Exception exception) {
            if (this.numberOfExceptions <= 5) {
                LogTools.error((String)exception.getMessage());
                if (++this.numberOfExceptions > 5) {
                    LogTools.error((String)"Stopping to print exceptions after {}.", (Object)5);
                }
            }
            return false;
        }
    }

    @Override
    public void remove() {
        this.domain.removePublisher(this.publisher);
    }

    Publisher getPublisher() {
        return this.publisher;
    }

    Domain getDomain() {
        return this.domain;
    }
}

