/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import com.eprosima.xmlschemas.fastrtps_profiles.RtpsTransportDescriptorType;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.QueuedROS2Subscription;
import us.ihmc.ros2.ROS2PublisherBasics;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Subscription;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.ROS2TopicNameTools;
import us.ihmc.ros2.SubscriptionMatchedListener;

public interface ROS2NodeInterface {
    public static final int DEFAULT_QUEUE_SIZE = 10;

    public static ParticipantAttributes createParticipantAttributes(int domainId, boolean useSharedMemory, InetAddress ... addressRestriction) {
        ParticipantAttributes participantAttributes = ParticipantAttributes.create().domainId(domainId).discoveryLeaseDuration(Time.Infinite);
        boolean restrictedToAddress = false;
        if (addressRestriction != null && addressRestriction.length > 0 && addressRestriction[0] != null) {
            participantAttributes.bindToAddressRestrictions(useSharedMemory, Arrays.asList(addressRestriction));
            restrictedToAddress = true;
        }
        if (!restrictedToAddress && !useSharedMemory) {
            participantAttributes.useBuiltinTransports(false);
            String transportName = UUID.randomUUID().toString();
            RtpsTransportDescriptorType transportDescriptor = new RtpsTransportDescriptorType();
            transportDescriptor.setTransportId(transportName);
            transportDescriptor.setType("UDPv4");
            participantAttributes.addTransport(transportDescriptor);
        }
        return participantAttributes;
    }

    public static boolean useSHMFromEnvironment() {
        String disableSharedMemoryTransportEnv = System.getenv("ROS_DISABLE_SHARED_MEMORY_TRANSPORT");
        if (disableSharedMemoryTransportEnv == null) {
            return false;
        }
        if (disableSharedMemoryTransportEnv.equalsIgnoreCase("true")) {
            LogTools.info((String)"Shared memory transport is disabled via environment variable ROS_DISABLE_SHARED_MEMORY_TRANSPORT");
            return false;
        }
        return true;
    }

    public static int domainFromEnvironment() {
        String rosDomainId = System.getenv("ROS_DOMAIN_ID");
        int rosDomainIdAsInteger = 0;
        if (rosDomainId != null) {
            rosDomainId = rosDomainId.trim();
            try {
                rosDomainIdAsInteger = Integer.parseInt(rosDomainId);
            }
            catch (NumberFormatException e) {
                LogTools.warn((String)"Environment variable ROS_DOMAIN_ID cannot be parsed as an integer: {}", (Object)rosDomainId);
            }
        }
        LogTools.info((String)"ROS_DOMAIN_ID environment variable is {}.", (Object)rosDomainIdAsInteger);
        LogTools.info((String)"Nodes created without a specified domain ID will use ROS_DOMAIN_ID.");
        return rosDomainIdAsInteger;
    }

    default public <T> ROS2PublisherBasics<T> createPublisher(ROS2Topic<T> topic) {
        return this.createPublisher(topic.getType(), topic.getName(), topic.getQoS());
    }

    default public <T> ROS2PublisherBasics<T> createPublisher(TopicDataType<T> topicDataType, String topicName) {
        return this.createPublisher(topicDataType, topicName, ROS2QosProfile.DEFAULT());
    }

    default public <T> ROS2PublisherBasics<T> createPublisher(Class<T> messageType, String topicName) {
        return this.createPublisher(messageType, topicName, ROS2QosProfile.DEFAULT());
    }

    default public <T> ROS2PublisherBasics<T> createPublisher(Class<T> messageType, String topicName, ROS2QosProfile qosProfile) {
        TopicDataType<T> topicDataType = ROS2TopicNameTools.newMessageTopicDataTypeInstance(messageType);
        return this.createPublisher(topicDataType, this.createPublisherAttributes(topicDataType, topicName, qosProfile));
    }

    default public <T> ROS2PublisherBasics<T> createPublisher(TopicDataType<T> topicDataType, String topicName, ROS2QosProfile qosProfile) {
        return this.createPublisher(topicDataType, this.createPublisherAttributes(topicDataType, topicName, qosProfile));
    }

    public <T> PublisherAttributes createPublisherAttributes(TopicDataType<T> var1, String var2, ROS2QosProfile var3);

    public <T> ROS2PublisherBasics<T> createPublisher(TopicDataType<T> var1, PublisherAttributes var2);

    default public <T> QueuedROS2Subscription<T> createQueuedSubscription(TopicDataType<T> topicDataType, String topicName) {
        return this.createQueuedSubscription(topicDataType, topicName, ROS2QosProfile.DEFAULT(), 10);
    }

    default public <T> QueuedROS2Subscription<T> createQueuedSubscription(ROS2Topic<T> topic) {
        return this.createQueuedSubscription(topic, 10);
    }

    default public <T> QueuedROS2Subscription<T> createQueuedSubscription(ROS2Topic<T> topic, int queueSize) {
        return this.createQueuedSubscription(topic.getType(), topic.getName(), topic.getQoS(), queueSize);
    }

    default public <T> QueuedROS2Subscription<T> createQueuedSubscription(Class<T> messageType, String topicName, ROS2QosProfile qosProfile, int queueSize) {
        TopicDataType<T> topicDataType = ROS2TopicNameTools.newMessageTopicDataTypeInstance(messageType);
        return this.createQueuedSubscription(topicDataType, this.createSubscriberAttributes(topicName, topicDataType, qosProfile), queueSize);
    }

    default public <T> QueuedROS2Subscription<T> createQueuedSubscription(TopicDataType<T> topicDataType, String topicName, ROS2QosProfile qosProfile, int queueSize) {
        return this.createQueuedSubscription(topicDataType, this.createSubscriberAttributes(topicName, topicDataType, qosProfile), queueSize);
    }

    public <T> QueuedROS2Subscription<T> createQueuedSubscription(TopicDataType<T> var1, SubscriberAttributes var2, int var3);

    default public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, NewMessageListener<T> newMessageListener, String topicName) {
        return this.createSubscription(topicDataType, newMessageListener, topicName, ROS2QosProfile.DEFAULT());
    }

    default public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, NewMessageListener<T> newMessageListener, String topicName, ROS2QosProfile qosProfile) {
        return this.createSubscription(topicDataType, newMessageListener, this.createSubscriberAttributes(topicName, topicDataType, qosProfile));
    }

    public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> var1, NewMessageListener<T> var2, SubscriberAttributes var3);

    default public <T> ROS2Subscription<T> createSubscription2(ROS2Topic<T> topic, final Consumer<T> messageCallback) {
        TopicDataType<T> topicDataType = ROS2TopicNameTools.newMessageTopicDataTypeInstance(topic.getType());
        return this.createSubscription(topicDataType, new NewMessageListener<T>(){

            @Override
            public void onNewDataMessage(Subscriber<T> subscriber) {
                Object incomingData = subscriber.takeNextData();
                if (incomingData != null) {
                    messageCallback.accept(incomingData);
                } else {
                    LogTools.warn((String)"Received null from takeNextData()");
                }
            }

            @Override
            public void onSubscriptionMatched(Subscriber<T> subscriber, MatchingInfo info) {
            }
        }, this.createSubscriberAttributes(topic.getName(), topicDataType, topic.getQoS()));
    }

    default public <T> ROS2Subscription<T> createSubscription(ROS2Topic<T> topic, NewMessageListener<T> newMessageListener) {
        return this.createSubscription(topic.getType(), newMessageListener, topic.getName(), topic.getQoS());
    }

    default public <T> ROS2Subscription<T> createSubscription(ROS2Topic<T> topic, NewMessageListener<T> newMessageListener, SubscriptionMatchedListener<T> subscriptionMatchedListener) {
        return this.createSubscription(topic.getType(), newMessageListener, subscriptionMatchedListener, topic.getName(), topic.getQoS());
    }

    default public <T> ROS2Subscription<T> createSubscription(Class<T> messageType, NewMessageListener<T> newMessageListener, String topicName) {
        return this.createSubscription(messageType, newMessageListener, topicName, ROS2QosProfile.DEFAULT());
    }

    default public <T> ROS2Subscription<T> createSubscription(Class<T> messageType, NewMessageListener<T> newMessageListener, String topicName, ROS2QosProfile qosProfile) {
        TopicDataType<T> topicDataType = ROS2TopicNameTools.newMessageTopicDataTypeInstance(messageType);
        return this.createSubscription(topicDataType, newMessageListener, topicName, qosProfile);
    }

    default public <T> ROS2Subscription<T> createSubscription(Class<T> messageType, NewMessageListener<T> newMessageListener, SubscriptionMatchedListener<T> subscriptionMatchedListener, String topicName, ROS2QosProfile qosProfile) {
        TopicDataType<T> topicDataType = ROS2TopicNameTools.newMessageTopicDataTypeInstance(messageType);
        return this.createSubscription(topicDataType, newMessageListener, subscriptionMatchedListener, topicName, qosProfile);
    }

    default public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, final NewMessageListener<T> newMessageListener, final SubscriptionMatchedListener<T> subscriptionMatchedListener, String topicName, ROS2QosProfile qosProfile) {
        return this.createSubscription(topicDataType, new NewMessageListener<T>(){

            @Override
            public void onNewDataMessage(Subscriber<T> subscriber) {
                newMessageListener.onNewDataMessage(subscriber);
            }

            @Override
            public void onSubscriptionMatched(Subscriber<T> subscriber, MatchingInfo info) {
                subscriptionMatchedListener.onSubscriptionMatched(subscriber, info);
            }
        }, this.createSubscriberAttributes(topicName, topicDataType, qosProfile));
    }

    public String getName();

    public String getNamespace();

    public <T> SubscriberAttributes createSubscriberAttributes(String var1, TopicDataType<T> var2, ROS2QosProfile var3);
}

