/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import com.eprosima.xmlschemas.fastrtps_profiles.TopicKindType;
import java.io.IOException;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.QueuedROS2Subscription;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Subscription;
import us.ihmc.ros2.ROS2TopicNameTools;
import us.ihmc.ros2.RealtimeROS2SubscriptionListener;

class ROS2NodeBasics
implements ROS2NodeInterface {
    private Domain domain;
    private Participant participant;
    private final String nodeName;
    private final String namespace;

    ROS2NodeBasics(Domain domain, String name, String namespace, ParticipantAttributes attributes) throws IOException {
        this.domain = domain;
        ROS2TopicNameTools.checkNodename(name);
        ROS2TopicNameTools.checkNamespace(namespace);
        this.nodeName = name;
        this.namespace = namespace;
        attributes.name(name);
        this.participant = domain.createParticipant(attributes);
    }

    public <T> ROS2Publisher<T> createPublisher(TopicDataType<T> topicDataType, PublisherAttributes publisherAttributes) throws IOException {
        TopicDataType registeredType = this.domain.getRegisteredType(this.participant, topicDataType.getName());
        if (registeredType == null) {
            this.domain.registerType(this.participant, topicDataType);
        }
        return new ROS2Publisher(this.domain, this.domain.createPublisher(this.participant, publisherAttributes));
    }

    @Override
    public <T> PublisherAttributes createPublisherAttributes(TopicDataType<T> topicDataType, String topicName, ROS2QosProfile qosProfile) {
        PublisherAttributes publisherAttributes = (PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)PublisherAttributes.create().topicKind(topicDataType.isGetKeyDefined() ? TopicKindType.WITH_KEY : TopicKindType.NO_KEY)).topicDataType(topicDataType)).reliabilityKind(qosProfile.getReliability())).heartBeatPeriod(new Time(0, 100000000L)).durabilityKind(qosProfile.getDurability().toKind())).historyDepth(qosProfile.getSize())).historyQosPolicyKind(qosProfile.getHistory());
        ROS2TopicNameTools.assignNameAndPartitionsToAttributes(publisherAttributes, this.namespace, this.nodeName, topicName, qosProfile.isAvoidRosNamespaceConventions());
        return publisherAttributes;
    }

    @Override
    public <T> QueuedROS2Subscription<T> createQueuedSubscription(TopicDataType<T> topicDataType, SubscriberAttributes subscriberAttributes, int queueSize) throws IOException {
        RealtimeROS2SubscriptionListener<T> listener = new RealtimeROS2SubscriptionListener<T>(topicDataType, queueSize);
        ROS2Subscription<T> subscriber = this.createSubscription(topicDataType, listener, subscriberAttributes);
        return new QueuedROS2Subscription<T>(subscriber, listener);
    }

    @Override
    public <T> SubscriberAttributes createSubscriberAttributes(String topicName, TopicDataType<T> topicDataType, ROS2QosProfile qosProfile) {
        SubscriberAttributes subscriberAttributes = (SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)SubscriberAttributes.create().topicKind(topicDataType.isGetKeyDefined() ? TopicKindType.WITH_KEY : TopicKindType.NO_KEY)).topicDataType(topicDataType)).topicName(topicName)).reliabilityKind(qosProfile.getReliability())).durabilityKind(qosProfile.getDurability().toKind())).historyDepth(qosProfile.getSize())).historyQosPolicyKind(qosProfile.getHistory());
        ROS2TopicNameTools.assignNameAndPartitionsToAttributes(subscriberAttributes, this.namespace, this.nodeName, topicName, qosProfile.isAvoidRosNamespaceConventions());
        return subscriberAttributes;
    }

    @Override
    public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, NewMessageListener<T> subscriberListener, SubscriberAttributes subscriberAttributes) throws IOException {
        TopicDataType registeredType = this.domain.getRegisteredType(this.participant, topicDataType.getName());
        if (registeredType == null) {
            this.domain.registerType(this.participant, topicDataType);
        }
        return new ROS2Subscription(this.domain, this.domain.createSubscriber(this.participant, subscriberAttributes, subscriberListener));
    }

    @Override
    public String getName() {
        return this.nodeName;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void destroy() {
        if (this.domain != null) {
            block3: {
                LogTools.info((String)("Shutting down ROS2 node " + this.nodeName));
                try {
                    this.domain.removeParticipant(this.participant);
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().contains("This participant is not registered with this domain")) break block3;
                    throw e;
                }
            }
            this.domain = null;
        }
        this.participant = null;
    }
}

