/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import us.ihmc.commons.thread.TypedNotification;
import us.ihmc.ros2.ROS2Callback;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.ROS2TopicNameTools;

public class ROS2Input<T> {
    private final AtomicReference<T> atomicReference;
    private final MessageFilter<T> messageFilter;
    private boolean hasReceivedFirstMessage = false;
    private final ROS2Callback<T> ros2Callback;
    private final TypedNotification<T> messageNotification = new TypedNotification();
    private final List<Consumer<T>> userCallbacks = new ArrayList<Consumer<T>>();

    public ROS2Input(ROS2NodeInterface ros2Node, ROS2Topic<T> topic) {
        this(ros2Node, topic, ROS2TopicNameTools.newMessageInstance(topic.getType()), message -> true);
    }

    public ROS2Input(ROS2NodeInterface ros2Node, Class<T> messageType, ROS2Topic topicName) {
        this(ros2Node, messageType, topicName.withTypeName(messageType).toString());
    }

    public ROS2Input(ROS2NodeInterface ros2Node, Class<T> messageType, String topicName) {
        this(ros2Node, messageType, topicName, ROS2TopicNameTools.newMessageInstance(messageType), (T message) -> true);
    }

    public ROS2Input(ROS2NodeInterface ros2Node, Class<T> messageType, ROS2Topic topicName, T initialValue, MessageFilter<T> messageFilter) {
        this(ros2Node, messageType, topicName.withTypeName(messageType).toString(), initialValue, messageFilter);
    }

    public ROS2Input(ROS2NodeInterface ros2Node, ROS2Topic<T> topic, T initialValue, MessageFilter<T> messageFilter) {
        this(ros2Node, topic.getType(), topic.getName(), initialValue, messageFilter);
    }

    public ROS2Input(ROS2NodeInterface ros2Node, Class<T> messageType, String topicName, T initialValue, MessageFilter<T> messageFilter) {
        this.atomicReference = new AtomicReference<T>(initialValue);
        this.messageFilter = messageFilter;
        this.ros2Callback = new ROS2Callback<Object>(ros2Node, messageType, topicName, this::messageReceivedCallback);
    }

    private void messageReceivedCallback(T incomingData) {
        if (this.messageFilter.accept(incomingData)) {
            this.atomicReference.set(incomingData);
            this.messageNotification.set(incomingData);
            for (Consumer<T> userCallback : this.userCallbacks) {
                userCallback.accept(incomingData);
            }
            this.hasReceivedFirstMessage = true;
        }
    }

    public T getLatest() {
        return this.atomicReference.get();
    }

    public TypedNotification<T> getMessageNotification() {
        return this.messageNotification;
    }

    public boolean hasReceivedFirstMessage() {
        return this.hasReceivedFirstMessage;
    }

    public void setEnabled(boolean enabled) {
        this.ros2Callback.setEnabled(enabled);
    }

    public void addCallback(Consumer<T> messageReceivedCallback) {
        this.userCallbacks.add(messageReceivedCallback);
    }

    public void destroy() {
        this.ros2Callback.destroy();
    }

    public static interface MessageFilter<T> {
        public boolean accept(T var1);
    }
}

